/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.NotAcceptableException;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.util.CertificateUtils;
import org.keycloak.util.PemUtils;

public class ClientAttributeCertificateResource {
    public static final String PRIVATE_KEY = "private.key";
    public static final String X509CERTIFICATE = "certificate";
    protected RealmModel realm;
    private RealmAuth auth;
    protected ClientModel client;
    protected KeycloakSession session;
    protected AdminEventBuilder adminEvent;
    protected String attributePrefix;
    protected String privateAttribute;
    protected String certificateAttribute;

    public ClientAttributeCertificateResource(RealmModel realm, RealmAuth auth, ClientModel client, KeycloakSession session, String attributePrefix, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.auth = auth;
        this.client = client;
        this.session = session;
        this.attributePrefix = attributePrefix;
        this.privateAttribute = attributePrefix + "." + PRIVATE_KEY;
        this.certificateAttribute = attributePrefix + "." + X509CERTIFICATE;
        this.adminEvent = adminEvent;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public ClientKeyPairInfo getKeyInfo() {
        ClientKeyPairInfo info = new ClientKeyPairInfo();
        info.setCertificate(this.client.getAttribute(this.certificateAttribute));
        info.setPrivateKey(this.client.getAttribute(this.privateAttribute));
        return info;
    }

    @POST
    @NoCache
    @Path(value="generate")
    @Produces(value={"application/json"})
    public ClientKeyPairInfo generate() {
        this.auth.requireManage();
        String subject = this.client.getClientId();
        KeyPair keyPair = null;
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048);
            keyPair = generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        X509Certificate certificate = null;
        try {
            certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keyPair, (String)subject);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)keyPair.getPrivate());
        String certPem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)certificate);
        this.client.setAttribute(this.privateAttribute, privateKeyPem);
        this.client.setAttribute(this.certificateAttribute, certPem);
        KeycloakModelUtils.generateClientKeyPairCertificate((ClientModel)this.client);
        ClientKeyPairInfo info = new ClientKeyPairInfo();
        info.setCertificate(this.client.getAttribute(this.certificateAttribute));
        info.setPrivateKey(this.client.getAttribute(this.privateAttribute));
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.session.getContext().getUri()).representation(info).success();
        return info;
    }

    @POST
    @Path(value="upload")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public ClientKeyPairInfo uploadJks(@Context UriInfo uriInfo, MultipartFormDataInput input) throws IOException {
        this.auth.requireManage();
        ClientKeyPairInfo info = new ClientKeyPairInfo();
        Map uploadForm = input.getFormDataMap();
        List inputParts = (List)uploadForm.get("file");
        String keystoreFormat = ((InputPart)((List)uploadForm.get("keystoreFormat")).get(0)).getBodyAsString();
        String keyAlias = ((InputPart)((List)uploadForm.get("keyAlias")).get(0)).getBodyAsString();
        List keyPasswordPart = (List)uploadForm.get("keyPassword");
        char[] keyPassword = keyPasswordPart != null ? ((InputPart)keyPasswordPart.get(0)).getBodyAsString().toCharArray() : null;
        List storePasswordPart = (List)uploadForm.get("storePassword");
        char[] storePassword = storePasswordPart != null ? ((InputPart)storePasswordPart.get(0)).getBodyAsString().toCharArray() : null;
        PrivateKey privateKey = null;
        X509Certificate certificate = null;
        try {
            KeyStore keyStore = null;
            keyStore = keystoreFormat.equals("JKS") ? KeyStore.getInstance("JKS") : KeyStore.getInstance(keystoreFormat, "BC");
            keyStore.load((InputStream)((InputPart)inputParts.get(0)).getBody(InputStream.class, null), storePassword);
            try {
                privateKey = (PrivateKey)keyStore.getKey(keyAlias, keyPassword);
            }
            catch (Exception e) {
                // empty catch block
            }
            certificate = (X509Certificate)keyStore.getCertificate(keyAlias);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (privateKey != null) {
            String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
            this.client.setAttribute(this.privateAttribute, privateKeyPem);
            info.setPrivateKey(privateKeyPem);
        } else if (certificate != null) {
            this.client.removeAttribute(this.privateAttribute);
        }
        if (certificate != null) {
            String certPem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)certificate);
            this.client.setAttribute(this.certificateAttribute, certPem);
            info.setCertificate(certPem);
        }
        this.adminEvent.operation(OperationType.ACTION).resourcePath(this.session.getContext().getUri()).representation(info).success();
        return info;
    }

    @POST
    @NoCache
    @Path(value="/download")
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/json"})
    public byte[] getKeystore(KeyStoreConfig config) {
        this.auth.requireView();
        if (config.getFormat() != null && !config.getFormat().equals("JKS") && !config.getFormat().equals("PKCS12")) {
            throw new NotAcceptableException("Only support jks format.");
        }
        String format = config.getFormat();
        String privatePem = this.client.getAttribute(this.privateAttribute);
        String certPem = this.client.getAttribute(this.certificateAttribute);
        if (privatePem == null && certPem == null) {
            throw new NotFoundException("keypair not generated for client");
        }
        if (privatePem != null && config.getKeyPassword() == null) {
            throw new BadRequestException("Need to specify a key password for jks download");
        }
        if (config.getStorePassword() == null) {
            throw new BadRequestException("Need to specify a store password for jks download");
        }
        try {
            KeyStore keyStore = format.equals("JKS") ? KeyStore.getInstance("JKS") : KeyStore.getInstance(format, "BC");
            keyStore.load(null, null);
            String keyAlias = config.getKeyAlias();
            if (keyAlias == null) {
                keyAlias = this.client.getClientId();
            }
            if (privatePem != null) {
                PrivateKey privateKey = PemUtils.decodePrivateKey((String)privatePem);
                X509Certificate clientCert = PemUtils.decodeCertificate((String)certPem);
                Certificate[] chain = new Certificate[]{clientCert};
                keyStore.setKeyEntry(keyAlias, privateKey, config.getKeyPassword().trim().toCharArray(), chain);
            } else {
                X509Certificate clientCert = PemUtils.decodeCertificate((String)certPem);
                keyStore.setCertificateEntry(keyAlias, clientCert);
            }
            if (config.isRealmCertificate() == null || config.isRealmCertificate().booleanValue()) {
                String certificateAlias;
                X509Certificate certificate = this.realm.getCertificate();
                if (certificate == null) {
                    KeycloakModelUtils.generateRealmCertificate((RealmModel)this.realm);
                    certificate = this.realm.getCertificate();
                }
                if ((certificateAlias = config.getRealmAlias()) == null) {
                    certificateAlias = this.realm.getName();
                }
                keyStore.setCertificateEntry(certificateAlias, certificate);
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            keyStore.store(stream, config.getStorePassword().trim().toCharArray());
            stream.flush();
            stream.close();
            byte[] rtn = stream.toByteArray();
            return rtn;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class KeyStoreConfig {
        protected Boolean realmCertificate;
        protected String storePassword;
        protected String keyPassword;
        protected String keyAlias;
        protected String realmAlias;
        protected String format;

        public Boolean isRealmCertificate() {
            return this.realmCertificate;
        }

        public void setRealmCertificate(Boolean realmCertificate) {
            this.realmCertificate = realmCertificate;
        }

        public String getStorePassword() {
            return this.storePassword;
        }

        public void setStorePassword(String storePassword) {
            this.storePassword = storePassword;
        }

        public String getKeyPassword() {
            return this.keyPassword;
        }

        public void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }

        public String getKeyAlias() {
            return this.keyAlias;
        }

        public void setKeyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
        }

        public String getRealmAlias() {
            return this.realmAlias;
        }

        public void setRealmAlias(String realmAlias) {
            this.realmAlias = realmAlias;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }

    public static class ClientKeyPairInfo {
        protected String privateKey;
        protected String publicKey;
        protected String certificate;

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public void setCertificate(String certificate) {
            this.certificate = certificate;
        }
    }
}

