/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.dom.saml.v2.assertion;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.EncryptedAssertionType;

public class EvidenceType
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected List<ChoiceType> evidences = new ArrayList<ChoiceType>();

    public void addEvidence(ChoiceType evidence) {
        this.evidences.add(evidence);
    }

    public void removeEvidence(ChoiceType evidence) {
        this.evidences.remove(evidence);
    }

    public List<ChoiceType> evidences() {
        return Collections.unmodifiableList(this.evidences);
    }

    public static class ChoiceType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String AssertionIDRef;
        private URI AssertionURIRef;
        private AssertionType assertion;
        private EncryptedAssertionType encryptedAssertion;

        public ChoiceType(String assertionIDRef) {
            this.AssertionIDRef = assertionIDRef;
        }

        public ChoiceType(URI assertionURIRef) {
            this.AssertionURIRef = assertionURIRef;
        }

        public ChoiceType(AssertionType assertion) {
            this.assertion = assertion;
        }

        public ChoiceType(EncryptedAssertionType encryptedAssertion) {
            this.encryptedAssertion = encryptedAssertion;
        }

        public String getAssertionIDRef() {
            return this.AssertionIDRef;
        }

        public URI getAssertionURIRef() {
            return this.AssertionURIRef;
        }

        public AssertionType getAssertion() {
            return this.assertion;
        }

        public EncryptedAssertionType getEncryptedAssertion() {
            return this.encryptedAssertion;
        }
    }
}

