/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.idm.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.keycloak.federation.ldap.idm.model.LDAPDn;

public class LDAPObject {
    private String uuid;
    private LDAPDn dn;
    private String rdnAttributeName;
    private final List<String> objectClasses = new LinkedList<String>();
    private final List<String> readOnlyAttributeNames = new LinkedList<String>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public LDAPDn getDn() {
        return this.dn;
    }

    public void setDn(LDAPDn dn) {
        this.dn = dn;
    }

    public List<String> getObjectClasses() {
        return this.objectClasses;
    }

    public void setObjectClasses(Collection<String> objectClasses) {
        this.objectClasses.clear();
        this.objectClasses.addAll(objectClasses);
    }

    public List<String> getReadOnlyAttributeNames() {
        return this.readOnlyAttributeNames;
    }

    public void addReadOnlyAttributeName(String readOnlyAttribute) {
        this.readOnlyAttributeNames.add(readOnlyAttribute);
    }

    public String getRdnAttributeName() {
        return this.rdnAttributeName;
    }

    public void setRdnAttributeName(String rdnAttributeName) {
        this.rdnAttributeName = rdnAttributeName;
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String getAttributeAsString(String name) {
        Object attrValue = this.attributes.get(name);
        if (attrValue != null && !(attrValue instanceof String)) {
            throw new IllegalStateException("Expected String but attribute was " + attrValue + " of type " + attrValue.getClass().getName());
        }
        return (String)attrValue;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        LDAPObject other = (LDAPObject)obj;
        return this.getUuid() != null && other.getUuid() != null && this.getUuid().equals(other.getUuid());
    }

    public int hashCode() {
        int result = this.getUuid() != null ? this.getUuid().hashCode() : 0;
        result = 31 * result + (this.getUuid() != null ? this.getUuid().hashCode() : 0);
        return result;
    }
}

