/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorContext;
import org.keycloak.authentication.authenticators.AbstractFormAuthenticator;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.AuthenticatorModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.services.managers.AuthenticationManager;

public class LoginFormUsernameAuthenticator
extends AbstractFormAuthenticator
implements Authenticator {
    public static final String FORM_USERNAME = "FORM_USERNAME";
    protected AuthenticatorModel model;

    public LoginFormUsernameAuthenticator(AuthenticatorModel model) {
        this.model = model;
    }

    @Override
    public void authenticate(AuthenticatorContext context) {
        if (this.isAction(context, "registration_form") && context.getUser() != null) {
            context.success();
            return;
        }
        if (!this.isAction(context, "login_form")) {
            MultivaluedMapImpl formData = new MultivaluedMapImpl();
            String loginHint = context.getClientSession().getNote("login_hint");
            String rememberMeUsername = AuthenticationManager.getRememberMeUsername(context.getRealm(), context.getHttpRequest().getHttpHeaders());
            if (loginHint != null || rememberMeUsername != null) {
                if (loginHint != null) {
                    formData.add((Object)"username", (Object)loginHint);
                } else {
                    formData.add((Object)"username", (Object)rememberMeUsername);
                    formData.add((Object)"rememberMe", (Object)"on");
                }
            }
            Response challengeResponse = this.challenge(context, (MultivaluedMap<String, String>)formData);
            context.challenge(challengeResponse);
            return;
        }
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        if (formData.containsKey((Object)"cancel")) {
            context.getEvent().error("rejected_by_user");
            LoginProtocol protocol = (LoginProtocol)context.getSession().getProvider(LoginProtocol.class, context.getClientSession().getAuthMethod());
            protocol.setRealm(context.getRealm()).setHttpHeaders(context.getHttpRequest().getHttpHeaders()).setUriInfo(context.getUriInfo());
            Response response = protocol.cancelLogin(context.getClientSession());
            context.challenge(response);
            return;
        }
        this.validateUser(context, (MultivaluedMap<String, String>)formData);
    }

    @Override
    public boolean requiresUser() {
        return false;
    }

    protected Response challenge(AuthenticatorContext context, MultivaluedMap<String, String> formData) {
        LoginFormsProvider forms = this.loginForm(context);
        if (formData.size() > 0) {
            forms.setFormData(formData);
        }
        return forms.createLogin();
    }

    public void validateUser(AuthenticatorContext context, MultivaluedMap<String, String> inputData) {
        boolean remember;
        String username = (String)inputData.getFirst((Object)"username");
        if (username == null) {
            context.getEvent().error("user_not_found");
            Response challengeResponse = this.invalidUser(context);
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_USER, challengeResponse);
            return;
        }
        context.getEvent().detail("username", username);
        context.getClientSession().setNote(FORM_USERNAME, username);
        UserModel user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)context.getSession(), (RealmModel)context.getRealm(), (String)username);
        if (this.invalidUser(context, user)) {
            return;
        }
        String rememberMe = (String)inputData.getFirst((Object)"rememberMe");
        boolean bl = remember = rememberMe != null && rememberMe.equalsIgnoreCase("on");
        if (remember) {
            context.getClientSession().setNote("remember_me", "true");
            context.getEvent().detail("remember_me", "true");
        }
        context.setUser(user);
        context.success();
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    @Override
    public String getRequiredAction() {
        return null;
    }

    public void close() {
    }
}

