/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators;

import java.net.URI;
import java.util.LinkedList;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorContext;
import org.keycloak.authentication.authenticators.AbstractFormAuthenticator;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.AuthenticatorModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.ClientSessionCode;

public class OTPFormAuthenticator
extends AbstractFormAuthenticator
implements Authenticator {
    public static final String TOTP_FORM_ACTION = "totp";
    protected AuthenticatorModel model;

    public OTPFormAuthenticator(AuthenticatorModel model) {
        this.model = model;
    }

    @Override
    public void authenticate(AuthenticatorContext context) {
        if (!this.isAction(context, TOTP_FORM_ACTION)) {
            Response challengeResponse = this.challenge(context, null);
            context.challenge(challengeResponse);
            return;
        }
        this.validateOTP(context);
    }

    public void validateOTP(AuthenticatorContext context) {
        MultivaluedMap inputData = context.getHttpRequest().getDecodedFormParameters();
        LinkedList<UserCredentialModel> credentials = new LinkedList<UserCredentialModel>();
        String password = (String)inputData.getFirst((Object)TOTP_FORM_ACTION);
        if (password == null) {
            Response challengeResponse = this.challenge(context, null);
            context.challenge(challengeResponse);
            return;
        }
        credentials.add(UserCredentialModel.totp((String)password));
        boolean valid = context.getSession().users().validCredentials(context.getRealm(), context.getUser(), credentials);
        if (!valid) {
            context.getEvent().user(context.getUser()).error("invalid_user_credentials");
            Response challengeResponse = this.challenge(context, "invalidTotpMessage");
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_CREDENTIALS, challengeResponse);
            return;
        }
        context.success();
    }

    @Override
    public boolean requiresUser() {
        return true;
    }

    protected Response challenge(AuthenticatorContext context, String error) {
        ClientSessionCode clientSessionCode = new ClientSessionCode(context.getRealm(), context.getClientSession());
        URI action = AbstractFormAuthenticator.getActionUrl(context, clientSessionCode, TOTP_FORM_ACTION);
        LoginFormsProvider forms = ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setActionUri(action).setClientSessionCode(clientSessionCode.getCode());
        if (error != null) {
            forms.setError(error, new Object[0]);
        }
        return forms.createLoginTotp();
    }

    @Override
    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return session.users().configuredForCredentialType(TOTP_FORM_ACTION, realm, user) && user.isTotp();
    }

    @Override
    public String getRequiredAction() {
        return UserModel.RequiredAction.CONFIGURE_TOTP.name();
    }

    public void close() {
    }
}

