/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderFactory;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.UserFederationProviderFactoryRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.services.managers.UsersSyncManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.UserFederationProviderResource;
import org.keycloak.timer.TimerProvider;

public class UserFederationProvidersResource {
    protected static final Logger logger = Logger.getLogger(UserFederationProvidersResource.class);
    protected RealmModel realm;
    protected RealmAuth auth;
    protected AdminEventBuilder adminEvent;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;

    public UserFederationProvidersResource(RealmModel realm, RealmAuth auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent;
        auth.init(RealmAuth.Resource.USER);
    }

    @GET
    @NoCache
    @Path(value="providers")
    @Produces(value={"application/json"})
    public List<UserFederationProviderFactoryRepresentation> getProviders() {
        this.auth.requireView();
        LinkedList<UserFederationProviderFactoryRepresentation> providers = new LinkedList<UserFederationProviderFactoryRepresentation>();
        for (ProviderFactory factory : this.session.getKeycloakSessionFactory().getProviderFactories(UserFederationProvider.class)) {
            UserFederationProviderFactoryRepresentation rep = new UserFederationProviderFactoryRepresentation();
            rep.setId(factory.getId());
            rep.setOptions(((UserFederationProviderFactory)factory).getConfigurationOptions());
            providers.add(rep);
        }
        return providers;
    }

    @GET
    @NoCache
    @Path(value="providers/{id}")
    @Produces(value={"application/json"})
    public UserFederationProviderFactoryRepresentation getProvider(@PathParam(value="id") String id) {
        this.auth.requireView();
        for (ProviderFactory factory : this.session.getKeycloakSessionFactory().getProviderFactories(UserFederationProvider.class)) {
            if (!factory.getId().equals(id)) continue;
            UserFederationProviderFactoryRepresentation rep = new UserFederationProviderFactoryRepresentation();
            rep.setId(factory.getId());
            rep.setOptions(((UserFederationProviderFactory)factory).getConfigurationOptions());
            return rep;
        }
        throw new NotFoundException("Could not find provider");
    }

    @POST
    @Path(value="instances")
    @Consumes(value={"application/json"})
    public Response createProviderInstance(UserFederationProviderRepresentation rep) {
        this.auth.requireManage();
        String displayName = rep.getDisplayName();
        if (displayName != null && displayName.trim().equals("")) {
            displayName = null;
        }
        UserFederationProviderModel model = this.realm.addUserFederationProvider(rep.getProviderName(), rep.getConfig(), rep.getPriority(), displayName, rep.getFullSyncPeriod(), rep.getChangedSyncPeriod(), rep.getLastSync());
        new UsersSyncManager().refreshPeriodicSyncForProvider(this.session.getKeycloakSessionFactory(), (TimerProvider)this.session.getProvider(TimerProvider.class), model, this.realm.getId());
        boolean kerberosCredsAdded = KeycloakModelUtils.checkKerberosCredential((RealmModel)this.realm, (UserFederationProviderModel)model);
        if (kerberosCredsAdded) {
            logger.info((Object)"Added 'kerberos' to required realm credentials");
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo).representation(rep).success();
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
    }

    @GET
    @Path(value="instances")
    @Produces(value={"application/json"})
    @NoCache
    public List<UserFederationProviderRepresentation> getUserFederationInstances() {
        this.auth.requireManage();
        LinkedList<UserFederationProviderRepresentation> reps = new LinkedList<UserFederationProviderRepresentation>();
        for (UserFederationProviderModel model : this.realm.getUserFederationProviders()) {
            UserFederationProviderRepresentation rep = ModelToRepresentation.toRepresentation((UserFederationProviderModel)model);
            reps.add(rep);
        }
        return reps;
    }

    @Path(value="instances/{id}")
    public UserFederationProviderResource getUserFederationInstance(@PathParam(value="id") String id) {
        this.auth.requireView();
        UserFederationProviderModel model = KeycloakModelUtils.findUserFederationProviderById((String)id, (RealmModel)this.realm);
        if (model == null) {
            throw new NotFoundException("Could not find federation provider with id: " + id);
        }
        UserFederationProviderResource instanceResource = new UserFederationProviderResource(this.session, this.realm, this.auth, model, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)instanceResource);
        return instanceResource;
    }
}

