/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.login.freemarker.model;

import java.net.URI;
import org.keycloak.freemarker.Theme;
import org.keycloak.models.RealmModel;
import org.keycloak.services.Urls;

public class UrlBean {
    private final URI actionuri;
    private URI baseURI;
    private Theme theme;
    private String realm;

    public UrlBean(RealmModel realm, Theme theme, URI baseURI, URI actionUri) {
        this.realm = realm.getName();
        this.theme = theme;
        this.baseURI = baseURI;
        this.actionuri = actionUri;
    }

    public String getLoginAction() {
        if (this.actionuri != null) {
            return this.actionuri.toString();
        }
        return Urls.realmLoginAction((URI)this.baseURI, (String)this.realm).toString();
    }

    public String getLoginUrl() {
        return Urls.realmLoginPage((URI)this.baseURI, (String)this.realm).toString();
    }

    public String getRegistrationAction() {
        return Urls.realmRegisterAction((URI)this.baseURI, (String)this.realm).toString();
    }

    public String getRegistrationUrl() {
        return Urls.realmRegisterPage((URI)this.baseURI, (String)this.realm).toString();
    }

    public String getLoginUpdatePasswordUrl() {
        return Urls.loginActionUpdatePassword((URI)this.baseURI, (String)this.realm).toString();
    }

    public String getLoginUpdateTotpUrl() {
        return Urls.loginActionUpdateTotp((URI)this.baseURI, (String)this.realm).toString();
    }

    public String getLoginUpdateProfileUrl() {
        return Urls.loginActionUpdateProfile((URI)this.baseURI, (String)this.realm).toString();
    }

    public String getLoginPasswordResetUrl() {
        return Urls.loginPasswordReset((URI)this.baseURI, (String)this.realm).toString();
    }

    public String getLoginUsernameReminderUrl() {
        return Urls.loginUsernameReminder((URI)this.baseURI, (String)this.realm).toString();
    }

    public String getLoginEmailVerificationUrl() {
        return Urls.loginActionEmailVerification((URI)this.baseURI, (String)this.realm).toString();
    }

    public String getOauthAction() {
        if (this.actionuri != null) {
            return this.actionuri.getPath();
        }
        return Urls.realmOauthAction((URI)this.baseURI, (String)this.realm).toString();
    }

    public String getResourcesPath() {
        URI uri = Urls.themeRoot((URI)this.baseURI);
        return uri.getPath() + "/" + this.theme.getType().toString().toLowerCase() + "/" + this.theme.getName();
    }
}

