/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.enums.SslRequired;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationMapperEventImpl;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderCreationEventImpl;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.entities.AuthenticationExecutionEntity;
import org.keycloak.models.entities.AuthenticationFlowEntity;
import org.keycloak.models.entities.AuthenticatorEntity;
import org.keycloak.models.entities.IdentityProviderEntity;
import org.keycloak.models.entities.IdentityProviderMapperEntity;
import org.keycloak.models.entities.RequiredCredentialEntity;
import org.keycloak.models.entities.UserFederationMapperEntity;
import org.keycloak.models.entities.UserFederationProviderEntity;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.adapters.ClientAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoClientEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRealmEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;

public class RealmAdapter
extends AbstractMongoAdapter<MongoRealmEntity>
implements RealmModel {
    private final MongoRealmEntity realm;
    private final RealmProvider model;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    protected volatile transient X509Certificate certificate;
    protected volatile transient Key codeSecretKey;
    private volatile transient PasswordPolicy passwordPolicy;
    private volatile transient KeycloakSession session;

    public RealmAdapter(KeycloakSession session, MongoRealmEntity realmEntity, MongoStoreInvocationContext invocationContext) {
        super(invocationContext);
        this.realm = realmEntity;
        this.session = session;
        this.model = session.realms();
    }

    public String getId() {
        return this.realm.getId();
    }

    public String getName() {
        return this.realm.getName();
    }

    public void setName(String name) {
        this.realm.setName(name);
        this.updateRealm();
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
        this.updateRealm();
    }

    public SslRequired getSslRequired() {
        return this.realm.getSslRequired() != null ? SslRequired.valueOf((String)this.realm.getSslRequired()) : null;
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.realm.setSslRequired(sslRequired.name());
        this.updateRealm();
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
        this.updateRealm();
    }

    public boolean isRegistrationEmailAsUsername() {
        return this.realm.isRegistrationEmailAsUsername();
    }

    public void setRegistrationEmailAsUsername(boolean registrationEmailAsUsername) {
        this.realm.setRegistrationEmailAsUsername(registrationEmailAsUsername);
        this.updateRealm();
    }

    public boolean isRememberMe() {
        return this.realm.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.realm.setRememberMe(rememberMe);
        this.updateRealm();
    }

    public boolean isBruteForceProtected() {
        return this.realm.isBruteForceProtected();
    }

    public void setBruteForceProtected(boolean value) {
        this.realm.setBruteForceProtected(value);
        this.updateRealm();
    }

    public int getMaxFailureWaitSeconds() {
        return this.realm.getMaxFailureWaitSeconds();
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.realm.setMaxFailureWaitSeconds(val);
        this.updateRealm();
    }

    public int getWaitIncrementSeconds() {
        return this.realm.getWaitIncrementSeconds();
    }

    public void setWaitIncrementSeconds(int val) {
        this.realm.setWaitIncrementSeconds(val);
        this.updateRealm();
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.realm.getQuickLoginCheckMilliSeconds();
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.realm.setQuickLoginCheckMilliSeconds(val);
        this.updateRealm();
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.realm.getMinimumQuickLoginWaitSeconds();
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.realm.setMinimumQuickLoginWaitSeconds(val);
        this.updateRealm();
    }

    public int getMaxDeltaTimeSeconds() {
        return this.realm.getMaxDeltaTimeSeconds();
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.realm.setMaxDeltaTimeSeconds(val);
        this.updateRealm();
    }

    public int getFailureFactor() {
        return this.realm.getFailureFactor();
    }

    public void setFailureFactor(int failureFactor) {
        this.realm.setFailureFactor(failureFactor);
        this.updateRealm();
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
        this.updateRealm();
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPassword) {
        this.realm.setResetPasswordAllowed(resetPassword);
        this.updateRealm();
    }

    public boolean isEditUsernameAllowed() {
        return this.realm.isEditUsernameAllowed();
    }

    public void setEditUsernameAllowed(boolean editUsernameAllowed) {
        this.realm.setEditUsernameAllowed(editUsernameAllowed);
        this.updateRealm();
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = new PasswordPolicy(this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
        this.updateRealm();
    }

    public int getNotBefore() {
        return this.realm.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.realm.setNotBefore(notBefore);
        this.updateRealm();
    }

    public int getSsoSessionIdleTimeout() {
        return this.realm.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.realm.setSsoSessionIdleTimeout(seconds);
        this.updateRealm();
    }

    public int getSsoSessionMaxLifespan() {
        return this.realm.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.realm.setSsoSessionMaxLifespan(seconds);
        this.updateRealm();
    }

    public int getAccessTokenLifespan() {
        return this.realm.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int tokenLifespan) {
        this.realm.setAccessTokenLifespan(tokenLifespan);
        this.updateRealm();
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
        this.updateRealm();
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
        this.updateRealm();
    }

    public void setAccessCodeLifespanLogin(int accessCodeLifespanLogin) {
        this.realm.setAccessCodeLifespanLogin(accessCodeLifespanLogin);
        this.updateRealm();
    }

    public int getAccessCodeLifespanLogin() {
        return this.realm.getAccessCodeLifespanLogin();
    }

    public String getPublicKeyPem() {
        return this.realm.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.realm.setPublicKeyPem(publicKeyPem);
        this.publicKey = null;
        this.updateRealm();
    }

    public X509Certificate getCertificate() {
        if (this.certificate != null) {
            return this.certificate;
        }
        this.certificate = KeycloakModelUtils.getCertificate((String)this.getCertificatePem());
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        String certificatePem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)certificate);
        this.setCertificatePem(certificatePem);
    }

    public String getCertificatePem() {
        return this.realm.getCertificatePem();
    }

    public void setCertificatePem(String certificate) {
        this.realm.setCertificatePem(certificate);
    }

    public String getPrivateKeyPem() {
        return this.realm.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.realm.setPrivateKeyPem(privateKeyPem);
        this.privateKey = null;
        this.updateRealm();
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = KeycloakModelUtils.getPublicKey((String)this.getPublicKeyPem());
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
        this.setPublicKeyPem(publicKeyPem);
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = KeycloakModelUtils.getPrivateKey((String)this.getPrivateKeyPem());
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
        this.setPrivateKeyPem(privateKeyPem);
    }

    public String getCodeSecret() {
        return this.realm.getCodeSecret();
    }

    public Key getCodeSecretKey() {
        if (this.codeSecretKey == null) {
            this.codeSecretKey = KeycloakModelUtils.getSecretKey((String)this.getCodeSecret());
        }
        return this.codeSecretKey;
    }

    public void setCodeSecret(String codeSecret) {
        this.realm.setCodeSecret(codeSecret);
        this.updateRealm();
    }

    public String getLoginTheme() {
        return this.realm.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.realm.setLoginTheme(name);
        this.updateRealm();
    }

    public String getAccountTheme() {
        return this.realm.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.realm.setAccountTheme(name);
        this.updateRealm();
    }

    public String getAdminTheme() {
        return this.realm.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.realm.setAdminTheme(name);
        this.updateRealm();
    }

    public String getEmailTheme() {
        return this.realm.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.realm.setEmailTheme(name);
        this.updateRealm();
    }

    public RoleAdapter getRole(String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).and("realmId").is((Object)this.getId()).get();
        MongoRoleEntity role = (MongoRoleEntity)this.getMongoStore().loadSingleEntity(MongoRoleEntity.class, query, this.invocationContext);
        if (role == null) {
            return null;
        }
        return new RoleAdapter(this.session, this, role, (RoleContainerModel)this, this.invocationContext);
    }

    public RoleModel addRole(String name) {
        return this.addRole(null, name);
    }

    public RoleModel addRole(String id, String name) {
        MongoRoleEntity roleEntity = new MongoRoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setRealmId(this.getId());
        this.getMongoStore().insertEntity((MongoIdentifiableEntity)roleEntity, this.invocationContext);
        return new RoleAdapter(this.session, this, roleEntity, (RoleContainerModel)this, this.invocationContext);
    }

    public boolean removeRole(RoleModel role) {
        return this.removeRoleById(role.getId());
    }

    public boolean removeRoleById(String id) {
        RoleModel role = this.getRoleById(id);
        if (role == null) {
            return false;
        }
        this.session.users().preRemove((RealmModel)this, role);
        return this.getMongoStore().removeEntity(MongoRoleEntity.class, id, this.invocationContext);
    }

    public Set<RoleModel> getRoles() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List roles = this.getMongoStore().loadEntities(MongoRoleEntity.class, query, this.invocationContext);
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        if (roles == null) {
            return result;
        }
        for (MongoRoleEntity role : roles) {
            result.add(new RoleAdapter(this.session, this, role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public RoleModel getRoleById(String id) {
        return this.model.getRoleById(id, (RealmModel)this);
    }

    public List<String> getDefaultRoles() {
        return this.realm.getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        RoleAdapter role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.realm, "defaultRoles", (Object)name, true, this.invocationContext);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleName : defaultRoles) {
            RoleAdapter role = this.getRole(roleName);
            if (role == null) {
                this.addRole(roleName);
            }
            roleNames.add(roleName);
        }
        this.realm.setDefaultRoles(roleNames);
        this.updateRealm();
    }

    public ClientModel getClientById(String id) {
        return this.model.getClientById(id, (RealmModel)this);
    }

    public ClientModel getClientByClientId(String clientId) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).and("clientId").is((Object)clientId).get();
        MongoClientEntity appEntity = (MongoClientEntity)this.getMongoStore().loadSingleEntity(MongoClientEntity.class, query, this.invocationContext);
        return appEntity == null ? null : new ClientAdapter(this.session, this, appEntity, this.invocationContext);
    }

    public Map<String, ClientModel> getClientNameMap() {
        HashMap<String, ClientModel> resourceMap = new HashMap<String, ClientModel>();
        for (ClientModel resource : this.getClients()) {
            resourceMap.put(resource.getClientId(), resource);
        }
        return resourceMap;
    }

    public List<ClientModel> getClients() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List clientEntities = this.getMongoStore().loadEntities(MongoClientEntity.class, query, this.invocationContext);
        ArrayList<ClientModel> result = new ArrayList<ClientModel>();
        for (MongoClientEntity clientEntity : clientEntities) {
            result.add(new ClientAdapter(this.session, this, clientEntity, this.invocationContext));
        }
        return result;
    }

    public ClientModel addClient(String name) {
        return this.addClient(null, name);
    }

    public ClientModel addClient(String id, String clientId) {
        MongoClientEntity clientEntity = new MongoClientEntity();
        clientEntity.setId(id);
        clientEntity.setClientId(clientId);
        clientEntity.setRealmId(this.getId());
        clientEntity.setEnabled(true);
        this.getMongoStore().insertEntity((MongoIdentifiableEntity)clientEntity, this.invocationContext);
        final ClientAdapter model = new ClientAdapter(this.session, this, clientEntity, this.invocationContext);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.ClientCreationEvent(){

            public ClientModel getCreatedClient() {
                return model;
            }
        });
        return model;
    }

    public boolean removeClient(String id) {
        if (id == null) {
            return false;
        }
        ClientModel client = this.getClientById(id);
        if (client == null) {
            return false;
        }
        this.session.users().preRemove((RealmModel)this, client);
        return this.getMongoStore().removeEntity(MongoClientEntity.class, id, this.invocationContext);
    }

    public void addRequiredCredential(String type) {
        RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(credentialModel, this.realm.getRequiredCredentials());
    }

    protected void addRequiredCredential(RequiredCredentialModel credentialModel, List<RequiredCredentialEntity> persistentCollection) {
        RequiredCredentialEntity credEntity = new RequiredCredentialEntity();
        credEntity.setType(credentialModel.getType());
        credEntity.setFormLabel(credentialModel.getFormLabel());
        credEntity.setInput(credentialModel.isInput());
        credEntity.setSecret(credentialModel.isSecret());
        persistentCollection.add(credEntity);
        this.updateRealm();
    }

    public void updateRequiredCredentials(Set<String> creds) {
        this.updateRequiredCredentials(creds, this.realm.getRequiredCredentials());
    }

    protected void updateRequiredCredentials(Set<String> creds, List<RequiredCredentialEntity> credsEntities) {
        HashSet<String> already = new HashSet<String>();
        HashSet<RequiredCredentialEntity> toRemove = new HashSet<RequiredCredentialEntity>();
        for (RequiredCredentialEntity entity : credsEntities) {
            if (!creds.contains(entity.getType())) {
                toRemove.add(entity);
                continue;
            }
            already.add(entity.getType());
        }
        for (RequiredCredentialEntity entity : toRemove) {
            credsEntities.remove(entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(cred);
            this.addRequiredCredential(credentialModel, credsEntities);
        }
        this.updateRealm();
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        return this.convertRequiredCredentialEntities(this.realm.getRequiredCredentials());
    }

    protected List<RequiredCredentialModel> convertRequiredCredentialEntities(Collection<RequiredCredentialEntity> credEntities) {
        ArrayList<RequiredCredentialModel> result = new ArrayList<RequiredCredentialModel>();
        for (RequiredCredentialEntity entity : credEntities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setInput(entity.isInput());
            model.setSecret(entity.isSecret());
            model.setType(entity.getType());
            result.add(model);
        }
        return result;
    }

    protected void updateRealm() {
        super.updateMongoEntity();
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return model;
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        return this.realm.getBrowserSecurityHeaders();
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        this.realm.setBrowserSecurityHeaders(headers);
        this.updateRealm();
    }

    public Map<String, String> getSmtpConfig() {
        return this.realm.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
        this.updateRealm();
    }

    public List<IdentityProviderModel> getIdentityProviders() {
        ArrayList<IdentityProviderModel> identityProviders = new ArrayList<IdentityProviderModel>();
        for (IdentityProviderEntity entity : this.realm.getIdentityProviders()) {
            IdentityProviderModel identityProviderModel = new IdentityProviderModel();
            identityProviderModel.setProviderId(entity.getProviderId());
            identityProviderModel.setAlias(entity.getAlias());
            identityProviderModel.setInternalId(entity.getInternalId());
            identityProviderModel.setConfig(entity.getConfig());
            identityProviderModel.setEnabled(entity.isEnabled());
            identityProviderModel.setUpdateProfileFirstLoginMode(entity.getUpdateProfileFirstLoginMode());
            identityProviderModel.setTrustEmail(entity.isTrustEmail());
            identityProviderModel.setAuthenticateByDefault(entity.isAuthenticateByDefault());
            identityProviderModel.setStoreToken(entity.isStoreToken());
            identityProviderModel.setAddReadTokenRoleOnCreate(entity.isAddReadTokenRoleOnCreate());
            identityProviders.add(identityProviderModel);
        }
        return identityProviders;
    }

    public IdentityProviderModel getIdentityProviderByAlias(String alias) {
        for (IdentityProviderModel identityProviderModel : this.getIdentityProviders()) {
            if (!identityProviderModel.getAlias().equals(alias)) continue;
            return identityProviderModel;
        }
        return null;
    }

    public void addIdentityProvider(IdentityProviderModel identityProvider) {
        IdentityProviderEntity entity = new IdentityProviderEntity();
        entity.setInternalId(KeycloakModelUtils.generateId());
        entity.setAlias(identityProvider.getAlias());
        entity.setProviderId(identityProvider.getProviderId());
        entity.setEnabled(identityProvider.isEnabled());
        entity.setUpdateProfileFirstLoginMode(identityProvider.getUpdateProfileFirstLoginMode());
        entity.setTrustEmail(identityProvider.isTrustEmail());
        entity.setAddReadTokenRoleOnCreate(identityProvider.isAddReadTokenRoleOnCreate());
        entity.setStoreToken(identityProvider.isStoreToken());
        entity.setAuthenticateByDefault(identityProvider.isAuthenticateByDefault());
        entity.setConfig(identityProvider.getConfig());
        this.realm.getIdentityProviders().add(entity);
        this.updateRealm();
    }

    public void removeIdentityProviderByAlias(String alias) {
        for (IdentityProviderEntity entity : this.realm.getIdentityProviders()) {
            if (!entity.getAlias().equals(alias)) continue;
            this.realm.getIdentityProviders().remove(entity);
            this.updateRealm();
            break;
        }
    }

    public void updateIdentityProvider(IdentityProviderModel identityProvider) {
        for (IdentityProviderEntity entity : this.realm.getIdentityProviders()) {
            if (!entity.getInternalId().equals(identityProvider.getInternalId())) continue;
            entity.setAlias(identityProvider.getAlias());
            entity.setEnabled(identityProvider.isEnabled());
            entity.setUpdateProfileFirstLoginMode(identityProvider.getUpdateProfileFirstLoginMode());
            entity.setTrustEmail(identityProvider.isTrustEmail());
            entity.setAuthenticateByDefault(identityProvider.isAuthenticateByDefault());
            entity.setAddReadTokenRoleOnCreate(identityProvider.isAddReadTokenRoleOnCreate());
            entity.setStoreToken(identityProvider.isStoreToken());
            entity.setConfig(identityProvider.getConfig());
        }
        this.updateRealm();
    }

    public UserFederationProviderModel addUserFederationProvider(String providerName, Map<String, String> config, int priority, String displayName, int fullSyncPeriod, int changedSyncPeriod, int lastSync) {
        KeycloakModelUtils.ensureUniqueDisplayName((String)displayName, null, this.getUserFederationProviders());
        UserFederationProviderEntity entity = new UserFederationProviderEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setPriority(priority);
        entity.setProviderName(providerName);
        entity.setConfig(config);
        if (displayName == null) {
            displayName = entity.getId();
        }
        entity.setDisplayName(displayName);
        entity.setFullSyncPeriod(fullSyncPeriod);
        entity.setChangedSyncPeriod(changedSyncPeriod);
        entity.setLastSync(lastSync);
        this.realm.getUserFederationProviders().add(entity);
        this.updateRealm();
        UserFederationProviderModel providerModel = new UserFederationProviderModel(entity.getId(), providerName, config, priority, displayName, fullSyncPeriod, changedSyncPeriod, lastSync);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserFederationProviderCreationEventImpl((RealmModel)this, providerModel));
        return providerModel;
    }

    public void removeUserFederationProvider(UserFederationProviderModel provider) {
        Iterator it = this.realm.getUserFederationProviders().iterator();
        while (it.hasNext()) {
            UserFederationProviderEntity entity = (UserFederationProviderEntity)it.next();
            if (!entity.getId().equals(provider.getId())) continue;
            this.session.users().preRemove((RealmModel)this, new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
            this.removeFederationMappersForProvider(provider.getId());
            it.remove();
        }
        this.updateRealm();
    }

    private void removeFederationMappersForProvider(String federationProviderId) {
        Set<UserFederationMapperEntity> mappers = this.getUserFederationMapperEntitiesByFederationProvider(federationProviderId);
        for (UserFederationMapperEntity mapper : mappers) {
            this.getMongoEntity().getUserFederationMappers().remove(mapper);
        }
    }

    public void updateUserFederationProvider(UserFederationProviderModel model) {
        KeycloakModelUtils.ensureUniqueDisplayName((String)model.getDisplayName(), (UserFederationProviderModel)model, this.getUserFederationProviders());
        for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
            if (!entity.getId().equals(model.getId())) continue;
            entity.setProviderName(model.getProviderName());
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            String displayName = model.getDisplayName();
            if (displayName != null) {
                entity.setDisplayName(model.getDisplayName());
            }
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
        }
        this.updateRealm();
    }

    public List<UserFederationProviderModel> getUserFederationProviders() {
        List entities = this.realm.getUserFederationProviders();
        LinkedList<UserFederationProviderEntity> copy = new LinkedList<UserFederationProviderEntity>();
        for (UserFederationProviderEntity entity : entities) {
            copy.add(entity);
        }
        Collections.sort(copy, new Comparator<UserFederationProviderEntity>(){

            @Override
            public int compare(UserFederationProviderEntity o1, UserFederationProviderEntity o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        LinkedList<UserFederationProviderModel> result = new LinkedList<UserFederationProviderModel>();
        for (UserFederationProviderEntity entity : copy) {
            result.add(new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
        }
        return result;
    }

    public void setUserFederationProviders(List<UserFederationProviderModel> providers) {
        for (UserFederationProviderModel currentProvider : providers) {
            KeycloakModelUtils.ensureUniqueDisplayName((String)currentProvider.getDisplayName(), (UserFederationProviderModel)currentProvider, providers);
        }
        List existingProviders = this.realm.getUserFederationProviders();
        LinkedList<UserFederationProviderEntity> toRemove = new LinkedList<UserFederationProviderEntity>();
        for (UserFederationProviderEntity entity : existingProviders) {
            boolean found = false;
            for (UserFederationProviderModel model : providers) {
                if (!entity.getId().equals(model.getId())) continue;
                entity.setConfig(model.getConfig());
                entity.setPriority(model.getPriority());
                entity.setProviderName(model.getProviderName());
                String displayName = model.getDisplayName();
                if (displayName != null) {
                    entity.setDisplayName(displayName);
                }
                entity.setFullSyncPeriod(model.getFullSyncPeriod());
                entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
                entity.setLastSync(model.getLastSync());
                found = true;
                break;
            }
            if (found) continue;
            this.session.users().preRemove((RealmModel)this, new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
            this.removeFederationMappersForProvider(entity.getId());
            toRemove.add(entity);
        }
        for (UserFederationProviderEntity entity : toRemove) {
            this.realm.getUserFederationProviders().remove(entity);
        }
        LinkedList<UserFederationProviderModel> add = new LinkedList<UserFederationProviderModel>();
        for (UserFederationProviderModel model : providers) {
            boolean found = false;
            for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
                if (!entity.getId().equals(model.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            add.add(model);
        }
        for (UserFederationProviderModel model : add) {
            UserFederationProviderEntity entity = new UserFederationProviderEntity();
            if (model.getId() != null) {
                entity.setId(model.getId());
            } else {
                String id = KeycloakModelUtils.generateId();
                entity.setId(id);
                model.setId(id);
            }
            entity.setProviderName(model.getProviderName());
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            String displayName = model.getDisplayName();
            if (displayName == null) {
                displayName = entity.getId();
            }
            entity.setDisplayName(displayName);
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
            this.realm.getUserFederationProviders().add(entity);
            this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserFederationProviderCreationEventImpl((RealmModel)this, model));
        }
        this.updateRealm();
    }

    public boolean isEventsEnabled() {
        return this.realm.isEventsEnabled();
    }

    public void setEventsEnabled(boolean enabled) {
        this.realm.setEventsEnabled(enabled);
        this.updateRealm();
    }

    public long getEventsExpiration() {
        return this.realm.getEventsExpiration();
    }

    public void setEventsExpiration(long expiration) {
        this.realm.setEventsExpiration(expiration);
        this.updateRealm();
    }

    public Set<String> getEventsListeners() {
        return new HashSet<String>(this.realm.getEventsListeners());
    }

    public void setEventsListeners(Set<String> listeners) {
        if (listeners != null) {
            this.realm.setEventsListeners(new ArrayList<String>(listeners));
        } else {
            this.realm.setEventsListeners(Collections.EMPTY_LIST);
        }
        this.updateRealm();
    }

    public Set<String> getEnabledEventTypes() {
        return new HashSet<String>(this.realm.getEnabledEventTypes());
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        if (enabledEventTypes != null) {
            this.realm.setEnabledEventTypes(new ArrayList<String>(enabledEventTypes));
        } else {
            this.realm.setEnabledEventTypes(Collections.EMPTY_LIST);
        }
        this.updateRealm();
    }

    public boolean isAdminEventsEnabled() {
        return this.realm.isAdminEventsEnabled();
    }

    public void setAdminEventsEnabled(boolean enabled) {
        this.realm.setAdminEventsEnabled(enabled);
        this.updateRealm();
    }

    public boolean isAdminEventsDetailsEnabled() {
        return this.realm.isAdminEventsDetailsEnabled();
    }

    public void setAdminEventsDetailsEnabled(boolean enabled) {
        this.realm.setAdminEventsDetailsEnabled(enabled);
        this.updateRealm();
    }

    public ClientModel getMasterAdminClient() {
        MongoClientEntity appData = (MongoClientEntity)this.getMongoStore().loadEntity(MongoClientEntity.class, this.realm.getMasterAdminClient(), this.invocationContext);
        return appData != null ? new ClientAdapter(this.session, this, appData, this.invocationContext) : null;
    }

    public void setMasterAdminClient(ClientModel client) {
        String adminAppId = client != null ? client.getId() : null;
        this.realm.setMasterAdminClient(adminAppId);
        this.updateRealm();
    }

    @Override
    public MongoRealmEntity getMongoEntity() {
        return this.realm;
    }

    public boolean isIdentityFederationEnabled() {
        return this.realm.getIdentityProviders() != null && !this.realm.getIdentityProviders().isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RealmModel)) {
            return false;
        }
        RealmModel that = (RealmModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean isInternationalizationEnabled() {
        return this.realm.isInternationalizationEnabled();
    }

    public void setInternationalizationEnabled(boolean enabled) {
        this.realm.setInternationalizationEnabled(enabled);
        this.updateRealm();
    }

    public Set<String> getSupportedLocales() {
        return new HashSet<String>(this.realm.getSupportedLocales());
    }

    public void setSupportedLocales(Set<String> locales) {
        if (locales != null) {
            this.realm.setSupportedLocales(new ArrayList<String>(locales));
        } else {
            this.realm.setSupportedLocales(Collections.EMPTY_LIST);
        }
        this.updateRealm();
    }

    public String getDefaultLocale() {
        return this.realm.getDefaultLocale();
    }

    public void setDefaultLocale(String locale) {
        this.realm.setDefaultLocale(locale);
        this.updateRealm();
    }

    public Set<IdentityProviderMapperModel> getIdentityProviderMappers() {
        HashSet<IdentityProviderMapperModel> mappings = new HashSet<IdentityProviderMapperModel>();
        for (IdentityProviderMapperEntity entity : this.getMongoEntity().getIdentityProviderMappers()) {
            IdentityProviderMapperModel mapping = this.entityToModel(entity);
            mappings.add(mapping);
        }
        return mappings;
    }

    public Set<IdentityProviderMapperModel> getIdentityProviderMappersByAlias(String brokerAlias) {
        HashSet<IdentityProviderMapperModel> mappings = new HashSet<IdentityProviderMapperModel>();
        for (IdentityProviderMapperEntity entity : this.getMongoEntity().getIdentityProviderMappers()) {
            if (!entity.getIdentityProviderAlias().equals(brokerAlias)) continue;
            IdentityProviderMapperModel mapping = this.entityToModel(entity);
            mappings.add(mapping);
        }
        return mappings;
    }

    public IdentityProviderMapperModel addIdentityProviderMapper(IdentityProviderMapperModel model) {
        if (this.getIdentityProviderMapperByName(model.getIdentityProviderAlias(), model.getIdentityProviderMapper()) != null) {
            throw new RuntimeException("identity provider mapper name must be unique per identity provider");
        }
        String id = KeycloakModelUtils.generateId();
        IdentityProviderMapperEntity entity = new IdentityProviderMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setIdentityProviderAlias(model.getIdentityProviderAlias());
        entity.setIdentityProviderMapper(model.getIdentityProviderMapper());
        entity.setConfig(model.getConfig());
        this.getMongoEntity().getIdentityProviderMappers().add(entity);
        this.updateMongoEntity();
        return this.entityToModel(entity);
    }

    protected IdentityProviderMapperEntity getIdentityProviderMapperEntity(String id) {
        for (IdentityProviderMapperEntity entity : this.getMongoEntity().getIdentityProviderMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected IdentityProviderMapperEntity getIdentityProviderMapperEntityByName(String alias, String name) {
        for (IdentityProviderMapperEntity entity : this.getMongoEntity().getIdentityProviderMappers()) {
            if (!entity.getIdentityProviderAlias().equals(alias) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public void removeIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        IdentityProviderMapperEntity toDelete = this.getIdentityProviderMapperEntity(mapping.getId());
        if (toDelete != null) {
            this.realm.getIdentityProviderMappers().remove(toDelete);
            this.updateMongoEntity();
        }
    }

    public void updateIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntity(mapping.getId());
        entity.setIdentityProviderAlias(mapping.getIdentityProviderAlias());
        entity.setIdentityProviderMapper(mapping.getIdentityProviderMapper());
        if (entity.getConfig() == null) {
            entity.setConfig(mapping.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        }
        this.updateMongoEntity();
    }

    public IdentityProviderMapperModel getIdentityProviderMapperById(String id) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public IdentityProviderMapperModel getIdentityProviderMapperByName(String alias, String name) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntityByName(alias, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected IdentityProviderMapperModel entityToModel(IdentityProviderMapperEntity entity) {
        IdentityProviderMapperModel mapping = new IdentityProviderMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setIdentityProviderAlias(entity.getIdentityProviderAlias());
        mapping.setIdentityProviderMapper(entity.getIdentityProviderMapper());
        HashMap config = new HashMap();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }

    public List<AuthenticationFlowModel> getAuthenticationFlows() {
        List flows = this.getMongoEntity().getAuthenticationFlows();
        LinkedList<AuthenticationFlowModel> models = new LinkedList<AuthenticationFlowModel>();
        for (AuthenticationFlowEntity entity : flows) {
            AuthenticationFlowModel model = this.entityToModel(entity);
            models.add(model);
        }
        return models;
    }

    protected AuthenticationFlowModel entityToModel(AuthenticationFlowEntity entity) {
        AuthenticationFlowModel model = new AuthenticationFlowModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        model.setDescription(entity.getDescription());
        return model;
    }

    public AuthenticationFlowModel getAuthenticationFlowById(String id) {
        AuthenticationFlowEntity entity = this.getFlowEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected AuthenticationFlowEntity getFlowEntity(String id) {
        List flows = this.getMongoEntity().getAuthenticationFlows();
        for (AuthenticationFlowEntity entity : flows) {
            if (!id.equals(entity.getId())) continue;
            return entity;
        }
        return null;
    }

    public void removeAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity toDelete = this.getFlowEntity(model.getId());
        if (toDelete == null) {
            return;
        }
        this.getMongoEntity().getAuthenticationFlows().remove(toDelete);
        this.updateMongoEntity();
    }

    public void updateAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity toUpdate = this.getFlowEntity(model.getId());
        if (toUpdate == null) {
            return;
        }
        toUpdate.setAlias(model.getAlias());
        toUpdate.setDescription(model.getDescription());
        this.updateMongoEntity();
    }

    public AuthenticationFlowModel addAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity entity = new AuthenticationFlowEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setAlias(model.getAlias());
        entity.setDescription(model.getDescription());
        this.getMongoEntity().getAuthenticationFlows().add(entity);
        model.setId(entity.getId());
        this.updateMongoEntity();
        return model;
    }

    public List<AuthenticationExecutionModel> getAuthenticationExecutions(String flowId) {
        AuthenticationFlowEntity flow = this.getFlowEntity(flowId);
        if (flow == null) {
            return Collections.EMPTY_LIST;
        }
        List queryResult = flow.getExecutions();
        LinkedList<AuthenticationExecutionModel> executions = new LinkedList<AuthenticationExecutionModel>();
        for (AuthenticationExecutionEntity entity : queryResult) {
            AuthenticationExecutionModel model = this.entityToModel(entity);
            executions.add(model);
        }
        return executions;
    }

    public AuthenticationExecutionModel entityToModel(AuthenticationExecutionEntity entity) {
        AuthenticationExecutionModel model = new AuthenticationExecutionModel();
        model.setId(entity.getId());
        model.setUserSetupAllowed(entity.isUserSetupAllowed());
        model.setRequirement(entity.getRequirement());
        model.setPriority(entity.getPriority());
        model.setAuthenticator(entity.getAuthenticator());
        model.setParentFlow(entity.getParentFlow());
        model.setAutheticatorFlow(entity.isAuthenticatorFlow());
        return model;
    }

    public AuthenticationExecutionModel getAuthenticationExecutionById(String id) {
        AuthenticationExecutionEntity execution = this.getAuthenticationExecutionEntity(id);
        return this.entityToModel(execution);
    }

    public AuthenticationExecutionEntity getAuthenticationExecutionEntity(String id) {
        List flows = this.getMongoEntity().getAuthenticationFlows();
        for (AuthenticationFlowEntity entity : flows) {
            for (AuthenticationExecutionEntity exe : entity.getExecutions()) {
                if (!exe.getId().equals(id)) continue;
                return exe;
            }
        }
        return null;
    }

    public AuthenticationExecutionModel addAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = new AuthenticationExecutionEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setAuthenticator(model.getAuthenticator());
        entity.setPriority(model.getPriority());
        entity.setRequirement(model.getRequirement());
        entity.setUserSetupAllowed(model.isUserSetupAllowed());
        entity.setAuthenticatorFlow(model.isAutheticatorFlow());
        entity.setParentFlow(model.getParentFlow());
        AuthenticationFlowEntity flow = this.getFlowEntity(model.getParentFlow());
        flow.getExecutions().add(entity);
        this.updateMongoEntity();
        model.setId(entity.getId());
        return model;
    }

    public void updateAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = null;
        AuthenticationFlowEntity flow = this.getFlowEntity(model.getParentFlow());
        for (AuthenticationExecutionEntity exe : flow.getExecutions()) {
            if (!exe.getId().equals(model.getId())) continue;
            entity = exe;
        }
        if (entity == null) {
            return;
        }
        entity.setAuthenticatorFlow(model.isAutheticatorFlow());
        entity.setAuthenticator(model.getAuthenticator());
        entity.setPriority(model.getPriority());
        entity.setRequirement(model.getRequirement());
        entity.setUserSetupAllowed(model.isUserSetupAllowed());
        this.updateMongoEntity();
    }

    public void removeAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = null;
        AuthenticationFlowEntity flow = this.getFlowEntity(model.getParentFlow());
        for (AuthenticationExecutionEntity exe : flow.getExecutions()) {
            if (!exe.getId().equals(model.getId())) continue;
            entity = exe;
        }
        if (entity == null) {
            return;
        }
        flow.getExecutions().remove(entity);
        this.updateMongoEntity();
    }

    public List<AuthenticatorModel> getAuthenticators() {
        LinkedList<AuthenticatorModel> authenticators = new LinkedList<AuthenticatorModel>();
        for (AuthenticatorEntity entity : this.getMongoEntity().getAuthenticators()) {
            authenticators.add(this.entityToModel(entity));
        }
        return authenticators;
    }

    public AuthenticatorModel addAuthenticator(AuthenticatorModel model) {
        AuthenticatorEntity auth = new AuthenticatorEntity();
        auth.setId(KeycloakModelUtils.generateId());
        auth.setAlias(model.getAlias());
        auth.setProviderId(model.getProviderId());
        auth.setConfig(model.getConfig());
        this.realm.getAuthenticators().add(auth);
        model.setId(auth.getId());
        this.updateMongoEntity();
        return model;
    }

    public void removeAuthenticator(AuthenticatorModel model) {
        AuthenticatorEntity entity = this.getAuthenticatorEntity(model.getId());
        if (entity == null) {
            return;
        }
        this.getMongoEntity().getAuthenticators().remove(entity);
        this.updateMongoEntity();
    }

    public AuthenticatorModel getAuthenticatorById(String id) {
        AuthenticatorEntity entity = this.getAuthenticatorEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public AuthenticatorEntity getAuthenticatorEntity(String id) {
        AuthenticatorEntity entity = null;
        for (AuthenticatorEntity auth : this.getMongoEntity().getAuthenticators()) {
            if (!auth.getId().equals(id)) continue;
            entity = auth;
            break;
        }
        return entity;
    }

    public AuthenticatorModel entityToModel(AuthenticatorEntity entity) {
        AuthenticatorModel model = new AuthenticatorModel();
        model.setId(entity.getId());
        model.setProviderId(entity.getProviderId());
        model.setAlias(entity.getAlias());
        HashMap config = new HashMap();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        model.setConfig(config);
        return model;
    }

    public void updateAuthenticator(AuthenticatorModel model) {
        AuthenticatorEntity entity = this.getAuthenticatorEntity(model.getId());
        if (entity == null) {
            return;
        }
        entity.setAlias(model.getAlias());
        entity.setProviderId(model.getProviderId());
        if (entity.getConfig() == null) {
            entity.setConfig(model.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(model.getConfig());
        }
        this.updateMongoEntity();
    }

    public Set<UserFederationMapperModel> getUserFederationMappers() {
        HashSet<UserFederationMapperModel> mappers = new HashSet<UserFederationMapperModel>();
        for (UserFederationMapperEntity entity : this.getMongoEntity().getUserFederationMappers()) {
            UserFederationMapperModel mapper = this.entityToModel(entity);
            mappers.add(mapper);
        }
        return mappers;
    }

    public Set<UserFederationMapperModel> getUserFederationMappersByFederationProvider(String federationProviderId) {
        HashSet<UserFederationMapperModel> mappers = new HashSet<UserFederationMapperModel>();
        Set<UserFederationMapperEntity> mapperEntities = this.getUserFederationMapperEntitiesByFederationProvider(federationProviderId);
        for (UserFederationMapperEntity entity : mapperEntities) {
            mappers.add(this.entityToModel(entity));
        }
        return mappers;
    }

    public UserFederationMapperModel addUserFederationMapper(UserFederationMapperModel model) {
        if (this.getUserFederationMapperByName(model.getFederationProviderId(), model.getName()) != null) {
            throw new ModelDuplicateException("User federation mapper must be unique per federation provider. There is already: " + model.getName());
        }
        String id = KeycloakModelUtils.generateId();
        UserFederationMapperEntity entity = new UserFederationMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setFederationProviderId(model.getFederationProviderId());
        entity.setFederationMapperType(model.getFederationMapperType());
        entity.setConfig(model.getConfig());
        this.getMongoEntity().getUserFederationMappers().add(entity);
        this.updateMongoEntity();
        UserFederationMapperModel mapperModel = this.entityToModel(entity);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserFederationMapperEventImpl(mapperModel, (RealmModel)this, this.session));
        return mapperModel;
    }

    protected UserFederationMapperEntity getUserFederationMapperEntity(String id) {
        for (UserFederationMapperEntity entity : this.getMongoEntity().getUserFederationMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected UserFederationMapperEntity getUserFederationMapperEntityByName(String federationProviderId, String name) {
        for (UserFederationMapperEntity entity : this.getMongoEntity().getUserFederationMappers()) {
            if (!entity.getFederationProviderId().equals(federationProviderId) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    protected Set<UserFederationMapperEntity> getUserFederationMapperEntitiesByFederationProvider(String federationProviderId) {
        HashSet<UserFederationMapperEntity> mappers = new HashSet<UserFederationMapperEntity>();
        for (UserFederationMapperEntity entity : this.getMongoEntity().getUserFederationMappers()) {
            if (!federationProviderId.equals(entity.getFederationProviderId())) continue;
            mappers.add(entity);
        }
        return mappers;
    }

    public void removeUserFederationMapper(UserFederationMapperModel mapper) {
        UserFederationMapperEntity toDelete = this.getUserFederationMapperEntity(mapper.getId());
        if (toDelete != null) {
            this.realm.getUserFederationMappers().remove(toDelete);
            this.updateMongoEntity();
        }
    }

    public void updateUserFederationMapper(UserFederationMapperModel mapper) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntity(mapper.getId());
        entity.setFederationProviderId(mapper.getFederationProviderId());
        entity.setFederationMapperType(mapper.getFederationMapperType());
        if (entity.getConfig() == null) {
            entity.setConfig(mapper.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapper.getConfig());
        }
        this.updateMongoEntity();
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserFederationMapperEventImpl(mapper, (RealmModel)this, this.session));
    }

    public UserFederationMapperModel getUserFederationMapperById(String id) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public UserFederationMapperModel getUserFederationMapperByName(String federationProviderId, String name) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntityByName(federationProviderId, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected UserFederationMapperModel entityToModel(UserFederationMapperEntity entity) {
        UserFederationMapperModel mapper = new UserFederationMapperModel();
        mapper.setId(entity.getId());
        mapper.setName(entity.getName());
        mapper.setFederationProviderId(entity.getFederationProviderId());
        mapper.setFederationMapperType(entity.getFederationMapperType());
        HashMap config = new HashMap();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapper.setConfig(config);
        return mapper;
    }
}

