/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.broker.oidc.mappers.AbstractClaimMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.HardcodedRoleMapper;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;

public class ClaimToRoleMapper
extends AbstractClaimMapper {
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"keycloak-oidc", "oidc"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "oidc-role-idp-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Role Importer";
    }

    public String getDisplayType() {
        return "Claim to Role";
    }

    public void importNewUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String roleName = (String)mapperModel.getConfig().get("role");
        if (this.hasClaimValue(mapperModel, context)) {
            RoleModel role = HardcodedRoleMapper.getRoleFromString((RealmModel)realm, (String)roleName);
            if (role == null) {
                throw new IdentityBrokerException("Unable to find role: " + roleName);
            }
            user.grantRole(role);
        }
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String roleName = (String)mapperModel.getConfig().get("role");
        if (!this.hasClaimValue(mapperModel, context)) {
            RoleModel role = HardcodedRoleMapper.getRoleFromString((RealmModel)realm, (String)roleName);
            if (role == null) {
                throw new IdentityBrokerException("Unable to find role: " + roleName);
            }
            user.deleteRoleMapping(role);
        }
    }

    public String getHelpText() {
        return "If a claim exists, grant the user the specified realm or application role.";
    }

    static {
        ProviderConfigProperty property1 = new ProviderConfigProperty();
        property1.setName("claim");
        property1.setLabel("Claim");
        property1.setHelpText("Name of claim to search for in token.  You can reference nested claims using a '.', i.e. 'address.locality'.");
        property1.setType("String");
        configProperties.add(property1);
        property1 = new ProviderConfigProperty();
        property1.setName("claim.value");
        property1.setLabel("Claim Value");
        property1.setHelpText("Value the claim must have.  If the claim is an array, then the value must be contained in the array.");
        property1.setType("String");
        configProperties.add(property1);
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("role");
        property.setLabel("Role");
        property.setHelpText("Role to grant to user if claim is present.  To reference an application role the syntax is appname.approle, i.e. myapp.myrole");
        property.setType("String");
        configProperties.add(property);
    }
}

