/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntitiesDescriptorType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.saml.v2.util.SAMLMetadataUtil;
import org.keycloak.saml.processing.core.util.CoreConfigUtil;
import org.keycloak.services.resources.admin.RealmAuth;

public class EntityDescriptorImporterService {
    protected RealmModel realm;
    protected RealmAuth auth;

    public EntityDescriptorImporterService(RealmModel realm, RealmAuth auth) {
        this.realm = realm;
        this.auth = auth;
    }

    @POST
    @Path(value="upload")
    @Consumes(value={"multipart/form-data"})
    public void updateEntityDescriptor(@Context UriInfo uriInfo, MultipartFormDataInput input) throws IOException {
        this.auth.requireManage();
        Map uploadForm = input.getFormDataMap();
        List inputParts = (List)uploadForm.get("file");
        InputStream is = (InputStream)((InputPart)inputParts.get(0)).getBody(InputStream.class, null);
        EntityDescriptorImporterService.loadEntityDescriptors(is, this.realm);
    }

    public static void loadEntityDescriptors(InputStream is, RealmModel realm) {
        EntitiesDescriptorType entities;
        Object metadata = null;
        try {
            metadata = new SAMLParser().parse(is);
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
        if (EntitiesDescriptorType.class.isInstance(metadata)) {
            entities = (EntitiesDescriptorType)metadata;
        } else {
            entities = new EntitiesDescriptorType();
            entities.addEntityDescriptor(metadata);
        }
        for (Object o : entities.getEntityDescriptor()) {
            String assertionConsumerServiceRedirectBinding;
            String assertionConsumerServicePostBinding;
            String logoutPost;
            EntityDescriptorType entity = (EntityDescriptorType)o;
            String entityId = entity.getEntityID();
            ClientModel app = realm.addClient(entityId);
            app.setFullScopeAllowed(true);
            app.setProtocol("saml");
            app.setAttribute("saml.server.signature", "true");
            app.setAttribute("saml.signature.algorithm", SignatureAlgorithm.RSA_SHA256.toString());
            app.setAttribute("saml.authnstatement", "true");
            SPSSODescriptorType spDescriptorType = CoreConfigUtil.getSPDescriptor((EntityDescriptorType)entity);
            if (spDescriptorType.isWantAssertionsSigned().booleanValue()) {
                app.setAttribute("saml.assertion.signature", "true");
            }
            if ((logoutPost = EntityDescriptorImporterService.getLogoutLocation(spDescriptorType, JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get())) != null) {
                app.setAttribute("saml_single_logout_service_url_post", logoutPost);
            }
            String logoutRedirect = EntityDescriptorImporterService.getLogoutLocation(spDescriptorType, JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get());
            if (logoutPost != null) {
                app.setAttribute("saml_single_logout_service_url_redirect", logoutRedirect);
            }
            if ((assertionConsumerServicePostBinding = CoreConfigUtil.getServiceURL((SPSSODescriptorType)spDescriptorType, (String)JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get())) != null) {
                app.setAttribute("saml_assertion_consumer_url_post", assertionConsumerServicePostBinding);
                app.addRedirectUri(assertionConsumerServicePostBinding);
            }
            if ((assertionConsumerServiceRedirectBinding = CoreConfigUtil.getServiceURL((SPSSODescriptorType)spDescriptorType, (String)JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get())) != null) {
                app.setAttribute("saml_assertion_consumer_url_redirect", assertionConsumerServiceRedirectBinding);
                app.addRedirectUri(assertionConsumerServiceRedirectBinding);
            }
            for (KeyDescriptorType keyDescriptor : spDescriptorType.getKeyDescriptor()) {
                X509Certificate cert = null;
                try {
                    cert = SAMLMetadataUtil.getCertificate((KeyDescriptorType)keyDescriptor);
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException(e);
                }
                catch (ProcessingException e) {
                    throw new RuntimeException(e);
                }
                String certPem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)cert);
                if (keyDescriptor.getUse() == KeyTypes.SIGNING) {
                    app.setAttribute("saml.client.signature", "true");
                    app.setAttribute("saml.signing.certificate", certPem);
                    continue;
                }
                if (keyDescriptor.getUse() != KeyTypes.ENCRYPTION) continue;
                app.setAttribute("saml.encrypt", "true");
                app.setAttribute("saml.encryption.certificate", certPem);
            }
        }
    }

    public static String getLogoutLocation(SPSSODescriptorType idp, String bindingURI) {
        String logoutResponseLocation = null;
        List endpoints = idp.getSingleLogoutService();
        for (EndpointType endpoint : endpoints) {
            if (!endpoint.getBinding().toString().equals(bindingURI)) continue;
            if (endpoint.getLocation() != null) {
                logoutResponseLocation = endpoint.getLocation().toString();
                break;
            }
            logoutResponseLocation = null;
            break;
        }
        return logoutResponseLocation;
    }
}

