/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.keycloak.VerificationException;
import org.keycloak.models.ClientModel;
import org.keycloak.protocol.saml.SignatureAlgorithm;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.sig.SAML2Signature;
import org.keycloak.saml.processing.web.util.RedirectBindingUtil;
import org.keycloak.util.PemUtils;
import org.w3c.dom.Document;

public class SamlProtocolUtils {
    public static byte[] createRandomSecret(int size) {
        SecureRandom random = new SecureRandom();
        byte[] secret = new byte[size];
        random.nextBytes(secret);
        return secret;
    }

    public static void verifyDocumentSignature(ClientModel client, Document document) throws VerificationException {
        if (!"true".equals(client.getAttribute("saml.client.signature"))) {
            return;
        }
        PublicKey publicKey = SamlProtocolUtils.getSignatureValidationKey(client);
        SamlProtocolUtils.verifyDocumentSignature(document, publicKey);
    }

    public static void verifyDocumentSignature(Document document, PublicKey publicKey) throws VerificationException {
        SAML2Signature saml2Signature = new SAML2Signature();
        try {
            if (!saml2Signature.validate(document, publicKey)) {
                throw new VerificationException("Invalid signature on document");
            }
        }
        catch (ProcessingException e) {
            throw new VerificationException("Error validating signature", (Throwable)e);
        }
    }

    public static PublicKey getSignatureValidationKey(ClientModel client) throws VerificationException {
        return SamlProtocolUtils.getPublicKey(client, "saml.signing.certificate");
    }

    public static PublicKey getEncryptionValidationKey(ClientModel client) throws VerificationException {
        return SamlProtocolUtils.getPublicKey(client, "saml.encryption.certificate");
    }

    public static PublicKey getPublicKey(ClientModel client, String attribute) throws VerificationException {
        String certPem = client.getAttribute(attribute);
        if (certPem == null) {
            throw new VerificationException("Client does not have a public key.");
        }
        X509Certificate cert = null;
        try {
            cert = PemUtils.decodeCertificate((String)certPem);
        }
        catch (Exception e) {
            throw new VerificationException("Could not decode cert", (Throwable)e);
        }
        return cert.getPublicKey();
    }

    public static void verifyRedirectSignature(PublicKey publicKey, UriInfo uriInformation) throws VerificationException {
        MultivaluedMap encodedParams = uriInformation.getQueryParameters(false);
        String request = (String)encodedParams.getFirst((Object)"SAMLRequest");
        String algorithm = (String)encodedParams.getFirst((Object)"SigAlg");
        String signature = (String)encodedParams.getFirst((Object)"Signature");
        String decodedAlgorithm = (String)uriInformation.getQueryParameters(true).getFirst((Object)"SigAlg");
        if (request == null) {
            throw new VerificationException("SAMLRequest as null");
        }
        if (algorithm == null) {
            throw new VerificationException("SigAlg as null");
        }
        if (signature == null) {
            throw new VerificationException("Signature as null");
        }
        UriBuilder builder = UriBuilder.fromPath((String)"/").queryParam("SAMLRequest", new Object[]{request});
        if (encodedParams.containsKey((Object)"RelayState")) {
            builder.queryParam("RelayState", new Object[]{encodedParams.getFirst((Object)"RelayState")});
        }
        builder.queryParam("SigAlg", new Object[]{algorithm});
        String rawQuery = builder.build(new Object[0]).getRawQuery();
        try {
            byte[] decodedSignature = RedirectBindingUtil.urlBase64Decode((String)signature);
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getFromXmlMethod(decodedAlgorithm);
            Signature validator = signatureAlgorithm.createSignature();
            validator.initVerify(publicKey);
            validator.update(rawQuery.getBytes("UTF-8"));
            if (!validator.verify(decodedSignature)) {
                throw new VerificationException("Invalid query param signature");
            }
        }
        catch (Exception e) {
            throw new VerificationException((Throwable)e);
        }
    }
}

