/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import java.util.HashSet;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.federation.ldap.idm.query.Condition;
import org.keycloak.federation.ldap.idm.query.QueryParameter;
import org.keycloak.federation.ldap.idm.query.internal.EqualCondition;
import org.keycloak.federation.ldap.idm.query.internal.LDAPIdentityQuery;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapper;
import org.keycloak.federation.ldap.mappers.TxAwareLDAPUserModelDelegate;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserModel;

public class FullNameLDAPFederationMapper
extends AbstractLDAPFederationMapper {
    public static final String LDAP_FULL_NAME_ATTRIBUTE = "ldap.full.name.attribute";
    public static final String READ_ONLY = "read.only";

    @Override
    public void onImportUserFromLDAP(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        String ldapFullNameAttrName = this.getLdapFullNameAttrName(mapperModel);
        String fullName = ldapUser.getAttributeAsString(ldapFullNameAttrName);
        if ((fullName = fullName.trim()) != null && !fullName.trim().isEmpty()) {
            int lastSpaceIndex = fullName.lastIndexOf(" ");
            if (lastSpaceIndex == -1) {
                user.setLastName(fullName);
            } else {
                user.setFirstName(fullName.substring(0, lastSpaceIndex));
                user.setLastName(fullName.substring(lastSpaceIndex + 1));
            }
        }
    }

    @Override
    public void onRegisterUserToLDAP(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
        String ldapFullNameAttrName = this.getLdapFullNameAttrName(mapperModel);
        String fullName = this.getFullName(localUser.getFirstName(), localUser.getLastName());
        ldapUser.setAttribute(ldapFullNameAttrName, fullName);
        if (this.isReadOnly(mapperModel)) {
            ldapUser.addReadOnlyAttributeName(ldapFullNameAttrName);
        }
    }

    @Override
    public UserModel proxy(final UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, LDAPObject ldapUser, UserModel delegate, RealmModel realm) {
        if (ldapProvider.getEditMode() == UserFederationProvider.EditMode.WRITABLE && !this.isReadOnly(mapperModel)) {
            TxAwareLDAPUserModelDelegate txDelegate = new TxAwareLDAPUserModelDelegate(delegate, ldapProvider, ldapUser){

                public void setFirstName(String firstName) {
                    super.setFirstName(firstName);
                    this.setFullNameToLDAPObject();
                }

                public void setLastName(String lastName) {
                    super.setLastName(lastName);
                    this.setFullNameToLDAPObject();
                }

                private void setFullNameToLDAPObject() {
                    String fullName = FullNameLDAPFederationMapper.this.getFullName(this.getFirstName(), this.getLastName());
                    if (logger.isTraceEnabled()) {
                        logger.tracef("Pushing full name attribute to LDAP. Full name: %s", (Object)fullName);
                    }
                    this.ensureTransactionStarted();
                    String ldapFullNameAttrName = FullNameLDAPFederationMapper.this.getLdapFullNameAttrName(mapperModel);
                    this.ldapUser.setAttribute(ldapFullNameAttrName, fullName);
                }
            };
            return txDelegate;
        }
        return delegate;
    }

    @Override
    public void beforeLDAPQuery(UserFederationMapperModel mapperModel, LDAPIdentityQuery query) {
        String ldapFullNameAttrName = this.getLdapFullNameAttrName(mapperModel);
        query.addReturningLdapAttribute(ldapFullNameAttrName);
        EqualCondition firstNameCondition = null;
        EqualCondition lastNameCondition = null;
        HashSet<Condition> conditionsCopy = new HashSet<Condition>(query.getConditions());
        for (Condition condition : conditionsCopy) {
            QueryParameter param = condition.getParameter();
            if (param == null) continue;
            if (param.getName().equals("firstName")) {
                firstNameCondition = (EqualCondition)condition;
                query.getConditions().remove(condition);
                continue;
            }
            if (param.getName().equals("lastName")) {
                lastNameCondition = (EqualCondition)condition;
                query.getConditions().remove(condition);
                continue;
            }
            if (param.getName().equals("givenName")) {
                firstNameCondition = (EqualCondition)condition;
                continue;
            }
            if (!param.getName().equals("sn")) continue;
            lastNameCondition = (EqualCondition)condition;
        }
        String fullName = null;
        if (firstNameCondition != null && lastNameCondition != null) {
            fullName = firstNameCondition.getValue() + " " + lastNameCondition.getValue();
        } else if (firstNameCondition != null) {
            fullName = (String)firstNameCondition.getValue();
        } else if (lastNameCondition != null) {
            fullName = (String)lastNameCondition.getValue();
        } else {
            return;
        }
        EqualCondition fullNameCondition = new EqualCondition(new QueryParameter(ldapFullNameAttrName), fullName);
        query.getConditions().add(fullNameCondition);
    }

    protected String getLdapFullNameAttrName(UserFederationMapperModel mapperModel) {
        String ldapFullNameAttrName = (String)mapperModel.getConfig().get(LDAP_FULL_NAME_ATTRIBUTE);
        return ldapFullNameAttrName == null ? "cn" : ldapFullNameAttrName;
    }

    protected String getFullName(String firstName, String lastName) {
        if (firstName != null && lastName != null) {
            return firstName + " " + lastName;
        }
        if (firstName != null) {
            return firstName;
        }
        if (lastName != null) {
            return lastName;
        }
        return " ";
    }

    private boolean isReadOnly(UserFederationMapperModel mapperModel) {
        return this.parseBooleanParameter(mapperModel, READ_ONLY);
    }
}

