/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import java.lang.reflect.Method;
import java.util.Map;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.federation.ldap.idm.query.Condition;
import org.keycloak.federation.ldap.idm.query.QueryParameter;
import org.keycloak.federation.ldap.idm.query.internal.LDAPIdentityQuery;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapper;
import org.keycloak.federation.ldap.mappers.TxAwareLDAPUserModelDelegate;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.reflection.Property;
import org.keycloak.models.utils.reflection.PropertyCriteria;
import org.keycloak.models.utils.reflection.PropertyQueries;

public class UserAttributeLDAPFederationMapper
extends AbstractLDAPFederationMapper {
    private static final Map<String, Property<Object>> userModelProperties = PropertyQueries.createQuery(UserModel.class).addCriteria(new PropertyCriteria(){

        public boolean methodMatches(Method m) {
            return !m.getName().startsWith("get") && !m.getName().startsWith("is") || m.getParameterTypes().length <= 0;
        }
    }).getResultList();
    public static final String USER_MODEL_ATTRIBUTE = "user.model.attribute";
    public static final String LDAP_ATTRIBUTE = "ldap.attribute";
    public static final String READ_ONLY = "read.only";

    @Override
    public void onImportUserFromLDAP(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        String userModelAttrName = (String)mapperModel.getConfig().get(USER_MODEL_ATTRIBUTE);
        String ldapAttrName = (String)mapperModel.getConfig().get(LDAP_ATTRIBUTE);
        Object ldapAttrValue = ldapUser.getAttribute(ldapAttrName);
        if (ldapAttrValue != null && !ldapAttrValue.toString().trim().isEmpty()) {
            Property<Object> userModelProperty = userModelProperties.get(userModelAttrName);
            if (userModelProperty != null) {
                userModelProperty.setValue((Object)user, ldapAttrValue);
            } else {
                user.setAttribute(userModelAttrName, (String)ldapAttrValue);
            }
        }
    }

    @Override
    public void onRegisterUserToLDAP(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
        String userModelAttrName = (String)mapperModel.getConfig().get(USER_MODEL_ATTRIBUTE);
        String ldapAttrName = (String)mapperModel.getConfig().get(LDAP_ATTRIBUTE);
        Property<Object> userModelProperty = userModelProperties.get(userModelAttrName);
        Object attrValue = userModelProperty != null ? userModelProperty.getValue((Object)localUser) : localUser.getAttribute(userModelAttrName);
        ldapUser.setAttribute(ldapAttrName, attrValue);
        if (this.isReadOnly(mapperModel)) {
            ldapUser.addReadOnlyAttributeName(ldapAttrName);
        }
    }

    @Override
    public UserModel proxy(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, LDAPObject ldapUser, UserModel delegate, RealmModel realm) {
        if (ldapProvider.getEditMode() == UserFederationProvider.EditMode.WRITABLE && !this.isReadOnly(mapperModel)) {
            final String userModelAttrName = (String)mapperModel.getConfig().get(USER_MODEL_ATTRIBUTE);
            final String ldapAttrName = (String)mapperModel.getConfig().get(LDAP_ATTRIBUTE);
            TxAwareLDAPUserModelDelegate txDelegate = new TxAwareLDAPUserModelDelegate(delegate, ldapProvider, ldapUser){

                public void setAttribute(String name, String value) {
                    this.setLDAPAttribute(name, value);
                    super.setAttribute(name, value);
                }

                public void setEmail(String email) {
                    this.setLDAPAttribute("email", email);
                    super.setEmail(email);
                }

                public void setLastName(String lastName) {
                    this.setLDAPAttribute("lastName", lastName);
                    super.setLastName(lastName);
                }

                public void setFirstName(String firstName) {
                    this.setLDAPAttribute("firstName", firstName);
                    super.setFirstName(firstName);
                }

                protected void setLDAPAttribute(String modelAttrName, String value) {
                    if (modelAttrName.equalsIgnoreCase(userModelAttrName)) {
                        if (logger.isTraceEnabled()) {
                            logger.tracef("Pushing user attribute to LDAP. Model attribute name: %s, LDAP attribute name: %s, Attribute value: %s", (Object)modelAttrName, (Object)ldapAttrName, (Object)value);
                        }
                        this.ensureTransactionStarted();
                        this.ldapUser.setAttribute(ldapAttrName, value);
                    }
                }
            };
            return txDelegate;
        }
        return delegate;
    }

    @Override
    public void beforeLDAPQuery(UserFederationMapperModel mapperModel, LDAPIdentityQuery query) {
        String userModelAttrName = (String)mapperModel.getConfig().get(USER_MODEL_ATTRIBUTE);
        String ldapAttrName = (String)mapperModel.getConfig().get(LDAP_ATTRIBUTE);
        query.addReturningLdapAttribute(ldapAttrName);
        if (this.isReadOnly(mapperModel)) {
            query.addReturningReadOnlyLdapAttribute(ldapAttrName);
        }
        for (Condition condition : query.getConditions()) {
            QueryParameter param = condition.getParameter();
            if (param == null || !param.getName().equalsIgnoreCase(userModelAttrName)) continue;
            param.setName(ldapAttrName);
        }
    }

    private boolean isReadOnly(UserFederationMapperModel mapperModel) {
        return this.parseBooleanParameter(mapperModel, READ_ONLY);
    }
}

