/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators;

import java.util.LinkedList;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.AuthenticatorContext;
import org.keycloak.authentication.authenticators.LoginFormUsernameAuthenticator;
import org.keycloak.models.AuthenticatorModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;

public class LoginFormPasswordAuthenticator
extends LoginFormUsernameAuthenticator {
    public LoginFormPasswordAuthenticator(AuthenticatorModel model) {
        super(model);
    }

    @Override
    public void authenticate(AuthenticatorContext context) {
        if (!this.isActionUrl(context)) {
            context.failure(AuthenticationProcessor.Error.INTERNAL_ERROR);
            return;
        }
        this.validatePassword(context);
    }

    protected Response badPassword(AuthenticatorContext context) {
        return this.loginForm(context).setError("invalidUserMessage", new Object[0]).createLogin();
    }

    public void validatePassword(AuthenticatorContext context) {
        MultivaluedMap inputData = context.getHttpRequest().getFormParameters();
        LinkedList<UserCredentialModel> credentials = new LinkedList<UserCredentialModel>();
        String password = (String)inputData.getFirst((Object)"password");
        if (password == null) {
            Response challengeResponse = this.badPassword(context);
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_CREDENTIALS, challengeResponse);
            return;
        }
        credentials.add(UserCredentialModel.password((String)password));
        boolean valid = context.getSession().users().validCredentials(context.getRealm(), context.getUser(), credentials);
        if (!valid) {
            Response challengeResponse = this.badPassword(context);
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_CREDENTIALS, challengeResponse);
            return;
        }
        context.success();
    }

    @Override
    public boolean requiresUser() {
        return true;
    }

    @Override
    public boolean configuredFor(UserModel user) {
        return user.configuredForCredentialType("password");
    }

    @Override
    public String getRequiredAction() {
        return UserModel.RequiredAction.UPDATE_PASSWORD.name();
    }

    @Override
    public void close() {
    }
}

