/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators;

import java.net.URI;
import java.util.LinkedList;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorContext;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.AuthenticatorModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.LoginActionsService;

public class OTPFormAuthenticator
implements Authenticator {
    protected AuthenticatorModel model;

    public OTPFormAuthenticator(AuthenticatorModel model) {
        this.model = model;
    }

    @Override
    public void authenticate(AuthenticatorContext context) {
        URI expected = LoginActionsService.authenticationFormProcessor(context.getUriInfo()).build(new Object[]{context.getRealm().getName()});
        if (!expected.getPath().equals(context.getUriInfo().getPath())) {
            Response challengeResponse = this.challenge(context);
            context.challenge(challengeResponse);
            return;
        }
        this.validateOTP(context);
    }

    public void validateOTP(AuthenticatorContext context) {
        MultivaluedMap inputData = context.getHttpRequest().getFormParameters();
        LinkedList<UserCredentialModel> credentials = new LinkedList<UserCredentialModel>();
        String password = (String)inputData.getFirst((Object)"totp");
        if (password == null) {
            Response challengeResponse = this.challenge(context);
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_CREDENTIALS, challengeResponse);
            return;
        }
        credentials.add(UserCredentialModel.totp((String)password));
        boolean valid = context.getSession().users().validCredentials(context.getRealm(), context.getUser(), credentials);
        if (!valid) {
            Response challengeResponse = this.challenge(context);
            context.failureChallenge(AuthenticationProcessor.Error.INVALID_CREDENTIALS, challengeResponse);
            return;
        }
        context.success();
    }

    @Override
    public boolean requiresUser() {
        return true;
    }

    protected Response challenge(AuthenticatorContext context, MultivaluedMap<String, String> formData) {
        LoginFormsProvider forms = ((LoginFormsProvider)context.getSession().getProvider(LoginFormsProvider.class)).setClientSessionCode(new ClientSessionCode(context.getRealm(), context.getClientSession()).getCode());
        if (formData.size() > 0) {
            forms.setFormData(formData);
        }
        return forms.createLoginTotp();
    }

    public Response challenge(AuthenticatorContext context) {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        return this.challenge(context, (MultivaluedMap<String, String>)formData);
    }

    @Override
    public boolean configuredFor(UserModel user) {
        return user.configuredForCredentialType("totp");
    }

    @Override
    public String getRequiredAction() {
        return UserModel.RequiredAction.CONFIGURE_TOTP.name();
    }

    public void close() {
    }
}

