/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.file.adapter;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.file.InMemoryModel;
import org.keycloak.enums.SslRequired;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationMapperEventImpl;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderCreationEventImpl;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.entities.AuthenticationExecutionEntity;
import org.keycloak.models.entities.AuthenticationFlowEntity;
import org.keycloak.models.entities.AuthenticatorConfigEntity;
import org.keycloak.models.entities.ClientEntity;
import org.keycloak.models.entities.IdentityProviderMapperEntity;
import org.keycloak.models.entities.RealmEntity;
import org.keycloak.models.entities.RequiredActionProviderEntity;
import org.keycloak.models.entities.RequiredCredentialEntity;
import org.keycloak.models.entities.RoleEntity;
import org.keycloak.models.entities.UserFederationMapperEntity;
import org.keycloak.models.entities.UserFederationProviderEntity;
import org.keycloak.models.file.adapter.ClientAdapter;
import org.keycloak.models.file.adapter.RoleAdapter;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;

public class RealmAdapter
implements RealmModel {
    private final InMemoryModel inMemoryModel;
    private final RealmEntity realm;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    protected volatile transient X509Certificate certificate;
    protected volatile transient Key codeSecretKey;
    private volatile transient PasswordPolicy passwordPolicy;
    private volatile transient KeycloakSession session;
    private final Map<String, ClientModel> allApps = new HashMap<String, ClientModel>();
    private ClientModel masterAdminApp = null;
    private final Map<String, RoleAdapter> allRoles = new HashMap<String, RoleAdapter>();
    private final Map<String, IdentityProviderModel> allIdProviders = new HashMap<String, IdentityProviderModel>();

    public RealmAdapter(KeycloakSession session, RealmEntity realm, InMemoryModel inMemoryModel) {
        this.session = session;
        this.realm = realm;
        this.inMemoryModel = inMemoryModel;
    }

    public RealmEntity getRealmEnity() {
        return this.realm;
    }

    public String getId() {
        return this.realm.getId();
    }

    public String getName() {
        return this.realm.getName();
    }

    public void setName(String name) {
        if (this.getName() == null) {
            this.realm.setName(name);
            return;
        }
        if (this.getName().equals(name)) {
            return;
        }
        if (this.inMemoryModel.getRealmByName(name) != null) {
            throw new ModelDuplicateException("Realm " + name + " already exists.");
        }
        this.realm.setName(name);
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
    }

    public SslRequired getSslRequired() {
        return SslRequired.valueOf((String)this.realm.getSslRequired());
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.realm.setSslRequired(sslRequired.name());
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
    }

    public boolean isRegistrationEmailAsUsername() {
        return this.realm.isRegistrationEmailAsUsername();
    }

    public void setRegistrationEmailAsUsername(boolean registrationEmailAsUsername) {
        this.realm.setRegistrationEmailAsUsername(registrationEmailAsUsername);
    }

    public boolean isRememberMe() {
        return this.realm.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.realm.setRememberMe(rememberMe);
    }

    public boolean isBruteForceProtected() {
        return this.realm.isBruteForceProtected();
    }

    public void setBruteForceProtected(boolean value) {
        this.realm.setBruteForceProtected(value);
    }

    public int getMaxFailureWaitSeconds() {
        return this.realm.getMaxFailureWaitSeconds();
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.realm.setMaxFailureWaitSeconds(val);
    }

    public int getWaitIncrementSeconds() {
        return this.realm.getWaitIncrementSeconds();
    }

    public void setWaitIncrementSeconds(int val) {
        this.realm.setWaitIncrementSeconds(val);
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.realm.getQuickLoginCheckMilliSeconds();
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.realm.setQuickLoginCheckMilliSeconds(val);
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.realm.getMinimumQuickLoginWaitSeconds();
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.realm.setMinimumQuickLoginWaitSeconds(val);
    }

    public int getMaxDeltaTimeSeconds() {
        return this.realm.getMaxDeltaTimeSeconds();
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.realm.setMaxDeltaTimeSeconds(val);
    }

    public int getFailureFactor() {
        return this.realm.getFailureFactor();
    }

    public void setFailureFactor(int failureFactor) {
        this.realm.setFailureFactor(failureFactor);
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPassword) {
        this.realm.setResetPasswordAllowed(resetPassword);
    }

    public boolean isEditUsernameAllowed() {
        return this.realm.isEditUsernameAllowed();
    }

    public void setEditUsernameAllowed(boolean editUsernameAllowed) {
        this.realm.setEditUsernameAllowed(editUsernameAllowed);
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = new PasswordPolicy(this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
    }

    public int getNotBefore() {
        return this.realm.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.realm.setNotBefore(notBefore);
    }

    public int getSsoSessionIdleTimeout() {
        return this.realm.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.realm.setSsoSessionIdleTimeout(seconds);
    }

    public int getSsoSessionMaxLifespan() {
        return this.realm.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.realm.setSsoSessionMaxLifespan(seconds);
    }

    public int getAccessTokenLifespan() {
        return this.realm.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int tokenLifespan) {
        this.realm.setAccessTokenLifespan(tokenLifespan);
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
    }

    public String getPublicKeyPem() {
        return this.realm.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.realm.setPublicKeyPem(publicKeyPem);
        this.publicKey = null;
    }

    public X509Certificate getCertificate() {
        if (this.certificate != null) {
            return this.certificate;
        }
        this.certificate = KeycloakModelUtils.getCertificate((String)this.getCertificatePem());
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        String certificatePem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)certificate);
        this.setCertificatePem(certificatePem);
    }

    public String getCertificatePem() {
        return this.realm.getCertificatePem();
    }

    public void setCertificatePem(String certificate) {
        this.realm.setCertificatePem(certificate);
    }

    public String getPrivateKeyPem() {
        return this.realm.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.realm.setPrivateKeyPem(privateKeyPem);
        this.privateKey = null;
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = KeycloakModelUtils.getPublicKey((String)this.getPublicKeyPem());
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
        this.setPublicKeyPem(publicKeyPem);
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = KeycloakModelUtils.getPrivateKey((String)this.getPrivateKeyPem());
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
        this.setPrivateKeyPem(privateKeyPem);
    }

    public String getCodeSecret() {
        return this.realm.getCodeSecret();
    }

    public Key getCodeSecretKey() {
        if (this.codeSecretKey == null) {
            this.codeSecretKey = KeycloakModelUtils.getSecretKey((String)this.getCodeSecret());
        }
        return this.codeSecretKey;
    }

    public void setCodeSecret(String codeSecret) {
        this.realm.setCodeSecret(codeSecret);
    }

    public String getLoginTheme() {
        return this.realm.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.realm.setLoginTheme(name);
    }

    public String getAccountTheme() {
        return this.realm.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.realm.setAccountTheme(name);
    }

    public String getAdminTheme() {
        return this.realm.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.realm.setAdminTheme(name);
    }

    public String getEmailTheme() {
        return this.realm.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.realm.setEmailTheme(name);
    }

    public RoleAdapter getRole(String name) {
        for (RoleAdapter role : this.allRoles.values()) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public RoleModel addRole(String name) {
        return this.addRole(KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addRole(String id, String name) {
        if (id == null) {
            throw new NullPointerException("id == null");
        }
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.hasRoleWithName(name)) {
            throw new ModelDuplicateException("Realm already contains role with name " + name + ".");
        }
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setRealmId(this.getId());
        RoleAdapter roleModel = new RoleAdapter(this, roleEntity, (RoleContainerModel)this);
        this.allRoles.put(id, roleModel);
        return roleModel;
    }

    public boolean removeRole(RoleModel role) {
        return this.removeRoleById(role.getId());
    }

    public boolean removeRoleById(String id) {
        if (id == null) {
            throw new NullPointerException("id == null");
        }
        if (this.allRoles.remove(id) != null) {
            return true;
        }
        for (ClientModel app : this.getClients()) {
            for (RoleModel appRole : app.getRoles()) {
                if (!id.equals(appRole.getId())) continue;
                app.removeRole(appRole);
                return true;
            }
        }
        return false;
    }

    public Set<RoleModel> getRoles() {
        return new HashSet<RoleModel>(this.allRoles.values());
    }

    public RoleModel getRoleById(String id) {
        RoleModel found = this.allRoles.get(id);
        if (found != null) {
            return found;
        }
        for (ClientModel app : this.getClients()) {
            for (RoleModel appRole : app.getRoles()) {
                if (!appRole.getId().equals(id)) continue;
                return appRole;
            }
        }
        return null;
    }

    public List<String> getDefaultRoles() {
        return this.realm.getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        List<String> roleNames;
        RoleAdapter role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        if ((roleNames = this.getDefaultRoles()).contains(name)) {
            throw new IllegalArgumentException("Realm " + this.realm.getName() + " already contains default role named " + name);
        }
        roleNames.add(name);
        this.realm.setDefaultRoles(roleNames);
    }

    boolean hasRoleWithName(String name) {
        for (RoleModel roleModel : this.allRoles.values()) {
            if (!roleModel.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleName : defaultRoles) {
            RoleAdapter role = this.getRole(roleName);
            if (role == null) {
                this.addRole(roleName);
            }
            roleNames.add(roleName);
        }
        this.realm.setDefaultRoles(roleNames);
    }

    public ClientModel getClientById(String id) {
        return this.allApps.get(id);
    }

    public ClientModel getClientByClientId(String clientId) {
        for (ClientModel app : this.getClients()) {
            if (!app.getClientId().equals(clientId)) continue;
            return app;
        }
        return null;
    }

    public Map<String, ClientModel> getClientNameMap() {
        HashMap<String, ClientModel> resourceMap = new HashMap<String, ClientModel>();
        for (ClientModel resource : this.getClients()) {
            resourceMap.put(resource.getClientId(), resource);
        }
        return resourceMap;
    }

    public List<ClientModel> getClients() {
        return new ArrayList<ClientModel>(this.allApps.values());
    }

    public ClientModel addClient(String name) {
        return this.addClient(KeycloakModelUtils.generateId(), name);
    }

    public ClientModel addClient(String id, String clientId) {
        if (clientId == null) {
            throw new NullPointerException("name == null");
        }
        if (id == null) {
            throw new NullPointerException("id == null");
        }
        if (this.getClientNameMap().containsKey(clientId)) {
            throw new ModelDuplicateException("Application named '" + clientId + "' already exists.");
        }
        ClientEntity appEntity = new ClientEntity();
        appEntity.setId(id);
        appEntity.setClientId(clientId);
        appEntity.setRealmId(this.getId());
        appEntity.setEnabled(true);
        final ClientAdapter app = new ClientAdapter(this.session, this, appEntity, this.inMemoryModel);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.ClientCreationEvent(){

            public ClientModel getCreatedClient() {
                return app;
            }
        });
        this.allApps.put(id, app);
        return app;
    }

    public boolean removeClient(String id) {
        ClientModel appToBeRemoved = this.getClientById(id);
        if (appToBeRemoved == null) {
            return false;
        }
        for (RoleModel role : this.getRoles()) {
            RoleAdapter roleAdapter = (RoleAdapter)role;
            roleAdapter.removeApplicationComposites(id);
        }
        for (RoleModel role : appToBeRemoved.getRoles()) {
            appToBeRemoved.removeRole(role);
        }
        return this.allApps.remove(id) != null;
    }

    boolean hasUserWithEmail(String email) {
        for (UserModel user : this.inMemoryModel.getUsers(this.getId())) {
            if (user.getEmail() == null || !user.getEmail().equals(email)) continue;
            return true;
        }
        return false;
    }

    public void addRequiredCredential(String type) {
        if (type == null) {
            throw new NullPointerException("Credential type can not be null");
        }
        RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(type);
        List requiredCredList = this.realm.getRequiredCredentials();
        for (RequiredCredentialEntity cred : requiredCredList) {
            if (!type.equals(cred.getType())) continue;
            return;
        }
        this.addRequiredCredential(credentialModel, requiredCredList);
    }

    protected void addRequiredCredential(RequiredCredentialModel credentialModel, List<RequiredCredentialEntity> persistentCollection) {
        RequiredCredentialEntity credEntity = new RequiredCredentialEntity();
        credEntity.setType(credentialModel.getType());
        credEntity.setFormLabel(credentialModel.getFormLabel());
        credEntity.setInput(credentialModel.isInput());
        credEntity.setSecret(credentialModel.isSecret());
        persistentCollection.add(credEntity);
    }

    public void updateRequiredCredentials(Set<String> creds) {
        this.updateRequiredCredentials(creds, this.realm.getRequiredCredentials());
    }

    protected void updateRequiredCredentials(Set<String> creds, List<RequiredCredentialEntity> credsEntities) {
        HashSet<String> already = new HashSet<String>();
        HashSet<RequiredCredentialEntity> toRemove = new HashSet<RequiredCredentialEntity>();
        for (RequiredCredentialEntity entity : credsEntities) {
            if (!creds.contains(entity.getType())) {
                toRemove.add(entity);
                continue;
            }
            already.add(entity.getType());
        }
        for (RequiredCredentialEntity entity : toRemove) {
            credsEntities.remove(entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(cred);
            this.addRequiredCredential(credentialModel, credsEntities);
        }
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        return this.convertRequiredCredentialEntities(this.realm.getRequiredCredentials());
    }

    protected List<RequiredCredentialModel> convertRequiredCredentialEntities(Collection<RequiredCredentialEntity> credEntities) {
        ArrayList<RequiredCredentialModel> result = new ArrayList<RequiredCredentialModel>();
        for (RequiredCredentialEntity entity : credEntities) {
            RequiredCredentialModel credentialModel = new RequiredCredentialModel();
            credentialModel.setFormLabel(entity.getFormLabel());
            credentialModel.setInput(entity.isInput());
            credentialModel.setSecret(entity.isSecret());
            credentialModel.setType(entity.getType());
            result.add(credentialModel);
        }
        return result;
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel credentialModel = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (credentialModel == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return credentialModel;
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        return this.realm.getBrowserSecurityHeaders();
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        this.realm.setBrowserSecurityHeaders(headers);
    }

    public Map<String, String> getSmtpConfig() {
        return this.realm.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
    }

    public List<IdentityProviderModel> getIdentityProviders() {
        return new ArrayList<IdentityProviderModel>(this.allIdProviders.values());
    }

    public IdentityProviderModel getIdentityProviderByAlias(String alias) {
        for (IdentityProviderModel identityProviderModel : this.getIdentityProviders()) {
            if (!identityProviderModel.getAlias().equals(alias)) continue;
            return identityProviderModel;
        }
        return null;
    }

    public void addIdentityProvider(IdentityProviderModel identityProvider) {
        if (identityProvider.getAlias() == null) {
            throw new NullPointerException("identityProvider.getAlias() == null");
        }
        if (identityProvider.getInternalId() == null) {
            identityProvider.setInternalId(KeycloakModelUtils.generateId());
        }
        this.allIdProviders.put(identityProvider.getInternalId(), identityProvider);
    }

    public void removeIdentityProviderByAlias(String alias) {
        for (IdentityProviderModel provider : this.getIdentityProviders()) {
            if (!provider.getAlias().equals(alias)) continue;
            this.allIdProviders.remove(provider.getInternalId());
            break;
        }
    }

    public void updateIdentityProvider(IdentityProviderModel identityProvider) {
        this.removeIdentityProviderByAlias(identityProvider.getAlias());
        this.addIdentityProvider(identityProvider);
    }

    public UserFederationProviderModel addUserFederationProvider(String providerName, Map<String, String> config, int priority, String displayName, int fullSyncPeriod, int changedSyncPeriod, int lastSync) {
        KeycloakModelUtils.ensureUniqueDisplayName((String)displayName, null, this.getUserFederationProviders());
        UserFederationProviderEntity entity = new UserFederationProviderEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setPriority(priority);
        entity.setProviderName(providerName);
        entity.setConfig(config);
        if (displayName == null) {
            displayName = entity.getId();
        }
        entity.setDisplayName(displayName);
        entity.setFullSyncPeriod(fullSyncPeriod);
        entity.setChangedSyncPeriod(changedSyncPeriod);
        entity.setLastSync(lastSync);
        this.realm.getUserFederationProviders().add(entity);
        UserFederationProviderModel providerModel = new UserFederationProviderModel(entity.getId(), providerName, config, priority, displayName, fullSyncPeriod, changedSyncPeriod, lastSync);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserFederationProviderCreationEventImpl((RealmModel)this, providerModel));
        return providerModel;
    }

    public void removeUserFederationProvider(UserFederationProviderModel provider) {
        Iterator it = this.realm.getUserFederationProviders().iterator();
        while (it.hasNext()) {
            UserFederationProviderEntity entity = (UserFederationProviderEntity)it.next();
            if (!entity.getId().equals(provider.getId())) continue;
            this.session.users().preRemove((RealmModel)this, new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
            Set<UserFederationMapperEntity> mappers = this.getUserFederationMapperEntitiesByFederationProvider(provider.getId());
            for (UserFederationMapperEntity mapper : mappers) {
                this.realm.getUserFederationMappers().remove(mapper);
            }
            it.remove();
        }
    }

    public void updateUserFederationProvider(UserFederationProviderModel model) {
        KeycloakModelUtils.ensureUniqueDisplayName((String)model.getDisplayName(), (UserFederationProviderModel)model, this.getUserFederationProviders());
        for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
            if (!entity.getId().equals(model.getId())) continue;
            entity.setProviderName(model.getProviderName());
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            String displayName = model.getDisplayName();
            if (displayName != null) {
                entity.setDisplayName(model.getDisplayName());
            }
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
        }
    }

    public List<UserFederationProviderModel> getUserFederationProviders() {
        List entities = this.realm.getUserFederationProviders();
        LinkedList<UserFederationProviderEntity> copy = new LinkedList<UserFederationProviderEntity>();
        for (UserFederationProviderEntity entity : entities) {
            copy.add(entity);
        }
        Collections.sort(copy, new Comparator<UserFederationProviderEntity>(){

            @Override
            public int compare(UserFederationProviderEntity o1, UserFederationProviderEntity o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        LinkedList<UserFederationProviderModel> result = new LinkedList<UserFederationProviderModel>();
        for (UserFederationProviderEntity entity : copy) {
            result.add(new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
        }
        return result;
    }

    public void setUserFederationProviders(List<UserFederationProviderModel> providers) {
        for (UserFederationProviderModel currentProvider : providers) {
            KeycloakModelUtils.ensureUniqueDisplayName((String)currentProvider.getDisplayName(), (UserFederationProviderModel)currentProvider, providers);
        }
        LinkedList<UserFederationProviderEntity> entities = new LinkedList<UserFederationProviderEntity>();
        for (UserFederationProviderModel model : providers) {
            UserFederationProviderEntity entity = new UserFederationProviderEntity();
            if (model.getId() != null) {
                entity.setId(model.getId());
            } else {
                String id = KeycloakModelUtils.generateId();
                entity.setId(id);
                model.setId(id);
            }
            entity.setProviderName(model.getProviderName());
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            String displayName = model.getDisplayName();
            if (displayName == null) {
                entity.setDisplayName(entity.getId());
            }
            entity.setDisplayName(displayName);
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
            entities.add(entity);
            this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserFederationProviderCreationEventImpl((RealmModel)this, model));
        }
        this.realm.setUserFederationProviders(entities);
    }

    public boolean isEventsEnabled() {
        return this.realm.isEventsEnabled();
    }

    public void setEventsEnabled(boolean enabled) {
        this.realm.setEventsEnabled(enabled);
    }

    public long getEventsExpiration() {
        return this.realm.getEventsExpiration();
    }

    public void setEventsExpiration(long expiration) {
        this.realm.setEventsExpiration(expiration);
    }

    public Set<String> getEventsListeners() {
        return new HashSet<String>(this.realm.getEventsListeners());
    }

    public void setEventsListeners(Set<String> listeners) {
        if (listeners != null) {
            this.realm.setEventsListeners(new ArrayList<String>(listeners));
        } else {
            this.realm.setEventsListeners(Collections.EMPTY_LIST);
        }
    }

    public Set<String> getEnabledEventTypes() {
        return new HashSet<String>(this.realm.getEnabledEventTypes());
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        if (enabledEventTypes != null) {
            this.realm.setEnabledEventTypes(new ArrayList<String>(enabledEventTypes));
        } else {
            this.realm.setEnabledEventTypes(Collections.EMPTY_LIST);
        }
    }

    public boolean isAdminEventsEnabled() {
        return this.realm.isAdminEventsEnabled();
    }

    public void setAdminEventsEnabled(boolean enabled) {
        this.realm.setAdminEventsEnabled(enabled);
    }

    public boolean isAdminEventsDetailsEnabled() {
        return this.realm.isAdminEventsDetailsEnabled();
    }

    public void setAdminEventsDetailsEnabled(boolean enabled) {
        this.realm.setAdminEventsDetailsEnabled(enabled);
    }

    public ClientModel getMasterAdminClient() {
        return this.masterAdminApp;
    }

    public void setMasterAdminClient(ClientModel client) {
        if (client == null) {
            this.realm.setMasterAdminClient(null);
            this.masterAdminApp = null;
        } else {
            String appId = client.getId();
            if (appId == null) {
                throw new IllegalStateException("Master Admin app not initialized.");
            }
            this.realm.setMasterAdminClient(appId);
            this.masterAdminApp = client;
        }
    }

    public boolean isIdentityFederationEnabled() {
        return this.getIdentityProviders() != null && !this.getIdentityProviders().isEmpty();
    }

    public int getAccessCodeLifespanLogin() {
        return this.realm.getAccessCodeLifespanLogin();
    }

    public void setAccessCodeLifespanLogin(int accessCodeLifespanLogin) {
        this.realm.setAccessCodeLifespanLogin(accessCodeLifespanLogin);
    }

    public boolean isInternationalizationEnabled() {
        return this.realm.isInternationalizationEnabled();
    }

    public void setInternationalizationEnabled(boolean enabled) {
        this.realm.setInternationalizationEnabled(enabled);
    }

    public Set<String> getSupportedLocales() {
        return new HashSet<String>(this.realm.getSupportedLocales());
    }

    public void setSupportedLocales(Set<String> locales) {
        this.realm.setSupportedLocales(new ArrayList<String>(locales));
    }

    public String getDefaultLocale() {
        return this.realm.getDefaultLocale();
    }

    public void setDefaultLocale(String locale) {
        this.realm.setDefaultLocale(locale);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RealmModel)) {
            return false;
        }
        RealmModel that = (RealmModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Set<IdentityProviderMapperModel> getIdentityProviderMappers() {
        HashSet<IdentityProviderMapperModel> mappings = new HashSet<IdentityProviderMapperModel>();
        for (IdentityProviderMapperEntity entity : this.realm.getIdentityProviderMappers()) {
            IdentityProviderMapperModel mapping = this.entityToModel(entity);
            mappings.add(mapping);
        }
        return mappings;
    }

    public Set<IdentityProviderMapperModel> getIdentityProviderMappersByAlias(String brokerAlias) {
        HashSet<IdentityProviderMapperModel> mappings = new HashSet<IdentityProviderMapperModel>();
        for (IdentityProviderMapperEntity entity : this.realm.getIdentityProviderMappers()) {
            if (!entity.getIdentityProviderAlias().equals(brokerAlias)) continue;
            IdentityProviderMapperModel mapping = this.entityToModel(entity);
            mappings.add(mapping);
        }
        return mappings;
    }

    public IdentityProviderMapperModel addIdentityProviderMapper(IdentityProviderMapperModel model) {
        if (this.getIdentityProviderMapperByName(model.getIdentityProviderAlias(), model.getIdentityProviderMapper()) != null) {
            throw new RuntimeException("identity provider mapper name must be unique per identity provider");
        }
        String id = KeycloakModelUtils.generateId();
        IdentityProviderMapperEntity entity = new IdentityProviderMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setIdentityProviderAlias(model.getIdentityProviderAlias());
        entity.setIdentityProviderMapper(model.getIdentityProviderMapper());
        entity.setConfig(model.getConfig());
        this.realm.getIdentityProviderMappers().add(entity);
        return this.entityToModel(entity);
    }

    protected IdentityProviderMapperEntity getIdentityProviderMapperEntity(String id) {
        for (IdentityProviderMapperEntity entity : this.realm.getIdentityProviderMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected IdentityProviderMapperEntity getIdentityProviderMapperEntityByName(String alias, String name) {
        for (IdentityProviderMapperEntity entity : this.realm.getIdentityProviderMappers()) {
            if (!entity.getIdentityProviderAlias().equals(alias) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public void removeIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        IdentityProviderMapperEntity toDelete = this.getIdentityProviderMapperEntity(mapping.getId());
        if (toDelete != null) {
            this.realm.getIdentityProviderMappers().remove(toDelete);
        }
    }

    public void updateIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntity(mapping.getId());
        entity.setIdentityProviderAlias(mapping.getIdentityProviderAlias());
        entity.setIdentityProviderMapper(mapping.getIdentityProviderMapper());
        if (entity.getConfig() == null) {
            entity.setConfig(mapping.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        }
    }

    public IdentityProviderMapperModel getIdentityProviderMapperById(String id) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public IdentityProviderMapperModel getIdentityProviderMapperByName(String alias, String name) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntityByName(alias, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected IdentityProviderMapperModel entityToModel(IdentityProviderMapperEntity entity) {
        IdentityProviderMapperModel mapping = new IdentityProviderMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setIdentityProviderAlias(entity.getIdentityProviderAlias());
        mapping.setIdentityProviderMapper(entity.getIdentityProviderMapper());
        HashMap config = new HashMap();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }

    public List<AuthenticationFlowModel> getAuthenticationFlows() {
        List flows = this.realm.getAuthenticationFlows();
        if (flows.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<AuthenticationFlowModel> models = new LinkedList<AuthenticationFlowModel>();
        for (AuthenticationFlowEntity entity : flows) {
            AuthenticationFlowModel model = this.entityToModel(entity);
            models.add(model);
        }
        return models;
    }

    public AuthenticationFlowModel getFlowByAlias(String alias) {
        for (AuthenticationFlowModel flow : this.getAuthenticationFlows()) {
            if (!flow.getAlias().equals(alias)) continue;
            return flow;
        }
        return null;
    }

    protected AuthenticationFlowModel entityToModel(AuthenticationFlowEntity entity) {
        AuthenticationFlowModel model = new AuthenticationFlowModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        model.setDescription(entity.getDescription());
        model.setProviderId(entity.getProviderId());
        model.setBuiltIn(entity.isBuiltIn());
        model.setTopLevel(entity.isTopLevel());
        return model;
    }

    public AuthenticationFlowModel getAuthenticationFlowById(String id) {
        for (AuthenticationFlowModel model : this.getAuthenticationFlows()) {
            if (!model.getId().equals(id)) continue;
            return model;
        }
        return null;
    }

    protected AuthenticationFlowEntity getFlowEntity(String id) {
        List flows = this.realm.getAuthenticationFlows();
        for (AuthenticationFlowEntity entity : flows) {
            if (!id.equals(entity.getId())) continue;
            return entity;
        }
        return null;
    }

    public void removeAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity toDelete = this.getFlowEntity(model.getId());
        if (toDelete == null) {
            return;
        }
        this.realm.getAuthenticationFlows().remove(toDelete);
    }

    public void updateAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity toUpdate = this.getFlowEntity(model.getId());
        if (toUpdate == null) {
            return;
        }
        toUpdate.setAlias(model.getAlias());
        toUpdate.setDescription(model.getDescription());
        toUpdate.setProviderId(model.getProviderId());
        toUpdate.setBuiltIn(model.isBuiltIn());
        toUpdate.setTopLevel(model.isTopLevel());
    }

    public AuthenticationFlowModel addAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity entity = new AuthenticationFlowEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAlias(model.getAlias());
        entity.setDescription(model.getDescription());
        entity.setProviderId(model.getProviderId());
        entity.setBuiltIn(model.isBuiltIn());
        entity.setTopLevel(model.isTopLevel());
        this.realm.getAuthenticationFlows().add(entity);
        model.setId(entity.getId());
        return model;
    }

    public List<AuthenticationExecutionModel> getAuthenticationExecutions(String flowId) {
        AuthenticationFlowEntity flow = this.getFlowEntity(flowId);
        if (flow == null) {
            return Collections.EMPTY_LIST;
        }
        List queryResult = flow.getExecutions();
        LinkedList<AuthenticationExecutionModel> executions = new LinkedList<AuthenticationExecutionModel>();
        for (AuthenticationExecutionEntity entity : queryResult) {
            AuthenticationExecutionModel model = this.entityToModel(entity);
            executions.add(model);
        }
        Collections.sort(executions, AuthenticationExecutionModel.ExecutionComparator.SINGLETON);
        return executions;
    }

    public AuthenticationExecutionModel entityToModel(AuthenticationExecutionEntity entity) {
        AuthenticationExecutionModel model = new AuthenticationExecutionModel();
        model.setId(entity.getId());
        model.setUserSetupAllowed(entity.isUserSetupAllowed());
        model.setRequirement(entity.getRequirement());
        model.setPriority(entity.getPriority());
        model.setAuthenticator(entity.getAuthenticator());
        model.setParentFlow(entity.getParentFlow());
        model.setFlowId(entity.getFlowId());
        model.setAutheticatorFlow(entity.isAuthenticatorFlow());
        model.setAuthenticatorConfig(entity.getAuthenticatorConfig());
        return model;
    }

    public AuthenticationExecutionModel getAuthenticationExecutionById(String id) {
        AuthenticationExecutionEntity execution = this.getAuthenticationExecutionEntity(id);
        return this.entityToModel(execution);
    }

    public AuthenticationExecutionEntity getAuthenticationExecutionEntity(String id) {
        List flows = this.realm.getAuthenticationFlows();
        for (AuthenticationFlowEntity entity : flows) {
            for (AuthenticationExecutionEntity exe : entity.getExecutions()) {
                if (!exe.getId().equals(id)) continue;
                return exe;
            }
        }
        return null;
    }

    public AuthenticationExecutionModel addAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = new AuthenticationExecutionEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAuthenticator(model.getAuthenticator());
        entity.setPriority(model.getPriority());
        entity.setRequirement(model.getRequirement());
        entity.setUserSetupAllowed(model.isUserSetupAllowed());
        entity.setAuthenticatorFlow(model.isAutheticatorFlow());
        entity.setFlowId(model.getFlowId());
        entity.setAuthenticatorConfig(model.getAuthenticatorConfig());
        AuthenticationFlowEntity flow = this.getFlowEntity(model.getId());
        flow.getExecutions().add(entity);
        model.setId(entity.getId());
        return model;
    }

    public void updateAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = null;
        AuthenticationFlowEntity flow = this.getFlowEntity(model.getParentFlow());
        for (AuthenticationExecutionEntity exe : flow.getExecutions()) {
            if (!exe.getId().equals(model.getId())) continue;
            entity = exe;
        }
        if (entity == null) {
            return;
        }
        entity.setAuthenticatorFlow(model.isAutheticatorFlow());
        entity.setAuthenticator(model.getAuthenticator());
        entity.setPriority(model.getPriority());
        entity.setRequirement(model.getRequirement());
        entity.setFlowId(model.getFlowId());
        entity.setUserSetupAllowed(model.isUserSetupAllowed());
        entity.setAuthenticatorConfig(model.getAuthenticatorConfig());
    }

    public void removeAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = null;
        AuthenticationFlowEntity flow = this.getFlowEntity(model.getParentFlow());
        for (AuthenticationExecutionEntity exe : flow.getExecutions()) {
            if (!exe.getId().equals(model.getId())) continue;
            entity = exe;
        }
        if (entity == null) {
            return;
        }
        flow.getExecutions().remove(entity);
    }

    public List<AuthenticatorConfigModel> getAuthenticatorConfigs() {
        LinkedList<AuthenticatorConfigModel> authenticators = new LinkedList<AuthenticatorConfigModel>();
        for (AuthenticatorConfigEntity entity : this.realm.getAuthenticatorConfigs()) {
            authenticators.add(this.entityToModel(entity));
        }
        return authenticators;
    }

    public AuthenticatorConfigModel getAuthenticatorConfigByAlias(String alias) {
        for (AuthenticatorConfigModel config : this.getAuthenticatorConfigs()) {
            if (!config.getAlias().equals(alias)) continue;
            return config;
        }
        return null;
    }

    public AuthenticatorConfigModel addAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity auth = new AuthenticatorConfigEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        auth.setId(id);
        auth.setAlias(model.getAlias());
        auth.setConfig(model.getConfig());
        this.realm.getAuthenticatorConfigs().add(auth);
        model.setId(auth.getId());
        return model;
    }

    public void removeAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity entity = this.getAuthenticatorEntity(model.getId());
        if (entity == null) {
            return;
        }
        this.realm.getAuthenticatorConfigs().remove(entity);
    }

    public AuthenticatorConfigModel getAuthenticatorConfigById(String id) {
        AuthenticatorConfigEntity entity = this.getAuthenticatorEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public AuthenticatorConfigEntity getAuthenticatorEntity(String id) {
        AuthenticatorConfigEntity entity = null;
        for (AuthenticatorConfigEntity auth : this.realm.getAuthenticatorConfigs()) {
            if (!auth.getId().equals(id)) continue;
            entity = auth;
            break;
        }
        return entity;
    }

    public AuthenticatorConfigModel entityToModel(AuthenticatorConfigEntity entity) {
        AuthenticatorConfigModel model = new AuthenticatorConfigModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        HashMap config = new HashMap();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        model.setConfig(config);
        return model;
    }

    public void updateAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity entity = this.getAuthenticatorEntity(model.getId());
        if (entity == null) {
            return;
        }
        entity.setAlias(model.getAlias());
        if (entity.getConfig() == null) {
            entity.setConfig(model.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(model.getConfig());
        }
    }

    public RequiredActionProviderModel addRequiredActionProvider(RequiredActionProviderModel model) {
        RequiredActionProviderEntity auth = new RequiredActionProviderEntity();
        auth.setId(KeycloakModelUtils.generateId());
        auth.setAlias(model.getAlias());
        auth.setName(model.getName());
        auth.setProviderId(model.getProviderId());
        auth.setConfig(model.getConfig());
        auth.setEnabled(model.isEnabled());
        auth.setDefaultAction(model.isDefaultAction());
        this.realm.getRequiredActionProviders().add(auth);
        model.setId(auth.getId());
        return model;
    }

    public void removeRequiredActionProvider(RequiredActionProviderModel model) {
        RequiredActionProviderEntity entity = this.getRequiredActionProviderEntity(model.getId());
        if (entity == null) {
            return;
        }
        this.realm.getRequiredActionProviders().remove(entity);
    }

    public RequiredActionProviderModel getRequiredActionProviderById(String id) {
        RequiredActionProviderEntity entity = this.getRequiredActionProviderEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public RequiredActionProviderModel entityToModel(RequiredActionProviderEntity entity) {
        RequiredActionProviderModel model = new RequiredActionProviderModel();
        model.setId(entity.getId());
        model.setProviderId(entity.getProviderId());
        model.setAlias(entity.getAlias());
        model.setName(entity.getName());
        model.setEnabled(entity.isEnabled());
        model.setDefaultAction(entity.isDefaultAction());
        HashMap config = new HashMap();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        model.setConfig(config);
        return model;
    }

    public void updateRequiredActionProvider(RequiredActionProviderModel model) {
        RequiredActionProviderEntity entity = this.getRequiredActionProviderEntity(model.getId());
        if (entity == null) {
            return;
        }
        entity.setAlias(model.getAlias());
        entity.setProviderId(model.getProviderId());
        entity.setEnabled(model.isEnabled());
        entity.setName(model.getName());
        entity.setDefaultAction(model.isDefaultAction());
        if (entity.getConfig() == null) {
            entity.setConfig(model.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(model.getConfig());
        }
    }

    public List<RequiredActionProviderModel> getRequiredActionProviders() {
        LinkedList<RequiredActionProviderModel> actions = new LinkedList<RequiredActionProviderModel>();
        for (RequiredActionProviderEntity entity : this.realm.getRequiredActionProviders()) {
            actions.add(this.entityToModel(entity));
        }
        return actions;
    }

    public RequiredActionProviderEntity getRequiredActionProviderEntity(String id) {
        RequiredActionProviderEntity entity = null;
        for (RequiredActionProviderEntity auth : this.realm.getRequiredActionProviders()) {
            if (!auth.getId().equals(id)) continue;
            entity = auth;
            break;
        }
        return entity;
    }

    public RequiredActionProviderModel getRequiredActionProviderByAlias(String alias) {
        for (RequiredActionProviderModel action : this.getRequiredActionProviders()) {
            if (!action.getAlias().equals(alias)) continue;
            return action;
        }
        return null;
    }

    public Set<UserFederationMapperModel> getUserFederationMappers() {
        HashSet<UserFederationMapperModel> mappers = new HashSet<UserFederationMapperModel>();
        for (UserFederationMapperEntity entity : this.realm.getUserFederationMappers()) {
            UserFederationMapperModel mapper = this.entityToModel(entity);
            mappers.add(mapper);
        }
        return mappers;
    }

    public Set<UserFederationMapperModel> getUserFederationMappersByFederationProvider(String federationProviderId) {
        HashSet<UserFederationMapperModel> mappers = new HashSet<UserFederationMapperModel>();
        Set<UserFederationMapperEntity> mapperEntities = this.getUserFederationMapperEntitiesByFederationProvider(federationProviderId);
        for (UserFederationMapperEntity entity : mapperEntities) {
            mappers.add(this.entityToModel(entity));
        }
        return mappers;
    }

    public UserFederationMapperModel addUserFederationMapper(UserFederationMapperModel model) {
        if (this.getUserFederationMapperByName(model.getFederationProviderId(), model.getName()) != null) {
            throw new ModelDuplicateException("User federation mapper must be unique per federation provider. There is already: " + model.getName());
        }
        String id = KeycloakModelUtils.generateId();
        UserFederationMapperEntity entity = new UserFederationMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setFederationProviderId(model.getFederationProviderId());
        entity.setFederationMapperType(model.getFederationMapperType());
        entity.setConfig(model.getConfig());
        this.realm.getUserFederationMappers().add(entity);
        UserFederationMapperModel mapperModel = this.entityToModel(entity);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserFederationMapperEventImpl(mapperModel, (RealmModel)this, this.session));
        return mapperModel;
    }

    protected UserFederationMapperEntity getUserFederationMapperEntity(String id) {
        for (UserFederationMapperEntity entity : this.realm.getUserFederationMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected UserFederationMapperEntity getUserFederationMapperEntityByName(String federationProviderId, String name) {
        for (UserFederationMapperEntity entity : this.realm.getUserFederationMappers()) {
            if (!entity.getFederationProviderId().equals(federationProviderId) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    protected Set<UserFederationMapperEntity> getUserFederationMapperEntitiesByFederationProvider(String federationProviderId) {
        HashSet<UserFederationMapperEntity> mappers = new HashSet<UserFederationMapperEntity>();
        for (UserFederationMapperEntity entity : this.realm.getUserFederationMappers()) {
            if (!federationProviderId.equals(entity.getFederationProviderId())) continue;
            mappers.add(entity);
        }
        return mappers;
    }

    public void removeUserFederationMapper(UserFederationMapperModel mapper) {
        UserFederationMapperEntity toDelete = this.getUserFederationMapperEntity(mapper.getId());
        if (toDelete != null) {
            this.realm.getUserFederationMappers().remove(toDelete);
        }
    }

    public void updateUserFederationMapper(UserFederationMapperModel mapper) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntity(mapper.getId());
        entity.setFederationProviderId(mapper.getFederationProviderId());
        entity.setFederationMapperType(mapper.getFederationMapperType());
        if (entity.getConfig() == null) {
            entity.setConfig(mapper.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapper.getConfig());
        }
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserFederationMapperEventImpl(mapper, (RealmModel)this, this.session));
    }

    public UserFederationMapperModel getUserFederationMapperById(String id) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public UserFederationMapperModel getUserFederationMapperByName(String federationProviderId, String name) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntityByName(federationProviderId, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected UserFederationMapperModel entityToModel(UserFederationMapperEntity entity) {
        UserFederationMapperModel mapper = new UserFederationMapperModel();
        mapper.setId(entity.getId());
        mapper.setName(entity.getName());
        mapper.setFederationProviderId(entity.getFederationProviderId());
        mapper.setFederationMapperType(entity.getFederationMapperType());
        HashMap config = new HashMap();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapper.setConfig(config);
        return mapper;
    }
}

