/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.utils.CredentialHelper;

public class AuthenticationManagementResource {
    private final RealmModel realm;
    private final KeycloakSession session;
    private RealmAuth auth;
    private AdminEventBuilder adminEvent;
    @Context
    private UriInfo uriInfo;
    private static Logger logger = Logger.getLogger(AuthenticationManagementResource.class);

    public AuthenticationManagementResource(RealmModel realm, KeycloakSession session, RealmAuth auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
        this.auth.init(RealmAuth.Resource.REALM);
        this.adminEvent = adminEvent;
    }

    @Path(value="/flows")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<AuthenticationFlowModel> getFlows() {
        this.auth.requireView();
        LinkedList<AuthenticationFlowModel> flows = new LinkedList<AuthenticationFlowModel>();
        for (AuthenticationFlowModel flow : this.realm.getAuthenticationFlows()) {
            if (!flow.isTopLevel()) continue;
            flows.add(flow);
        }
        return flows;
    }

    @Path(value="/flows/{flowAlias}/executions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response getExecutions(@PathParam(value="flowAlias") String flowAlias) {
        this.auth.requireView();
        AuthenticationFlowModel flow = this.realm.getFlowByAlias(flowAlias);
        if (flow == null) {
            logger.debug((Object)("flow not found: " + flowAlias));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        LinkedList<AuthenticationExecutionRepresentation> result = new LinkedList<AuthenticationExecutionRepresentation>();
        List<AuthenticationExecutionModel> executions = AuthenticatorUtil.getEnabledExecutionsRecursively(this.realm, flow.getId());
        for (AuthenticationExecutionModel execution : executions) {
            AuthenticationExecutionRepresentation rep = new AuthenticationExecutionRepresentation();
            rep.setSubFlow(false);
            rep.setRequirementChoices(new LinkedList<String>());
            if (execution.isAutheticatorFlow()) {
                AuthenticationFlowModel flowRef = this.realm.getAuthenticationFlowById(execution.getFlowId());
                if ("basic-flow".equals(flowRef.getProviderId())) {
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.ALTERNATIVE.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.REQUIRED.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.DISABLED.name());
                } else if ("form-flow".equals(flowRef.getProviderId())) {
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.REQUIRED.name());
                    rep.getRequirementChoices().add(AuthenticationExecutionModel.Requirement.DISABLED.name());
                    rep.setProviderId(execution.getAuthenticator());
                    rep.setAuthenticationConfig(execution.getAuthenticatorConfig());
                }
                rep.setReferenceType(flowRef.getAlias());
                rep.setConfigurable(false);
                rep.setId(execution.getId());
                rep.setRequirement(execution.getRequirement().name());
                result.add(rep);
                continue;
            }
            if (!flow.getId().equals(execution.getParentFlow())) {
                rep.setSubFlow(true);
            }
            String providerId = execution.getAuthenticator();
            ConfigurableAuthenticatorFactory factory = CredentialHelper.getConfigurableAuthenticatorFactory(this.session, providerId);
            rep.setReferenceType(factory.getDisplayType());
            rep.setConfigurable(factory.isConfigurable());
            for (AuthenticationExecutionModel.Requirement choice : factory.getRequirementChoices()) {
                rep.getRequirementChoices().add(choice.name());
            }
            rep.setId(execution.getId());
            rep.setRequirement(execution.getRequirement().name());
            rep.setProviderId(execution.getAuthenticator());
            rep.setAuthenticationConfig(execution.getAuthenticatorConfig());
            result.add(rep);
        }
        return Response.ok(result).build();
    }

    @Path(value="/flows/{flowAlias}/executions")
    @PUT
    @NoCache
    @Consumes(value={"application/json"})
    public void updateExecutions(@PathParam(value="flowAlias") String flowAlias, AuthenticationExecutionRepresentation rep) {
        this.auth.requireManage();
        AuthenticationFlowModel flow = this.realm.getFlowByAlias(flowAlias);
        if (flow == null) {
            logger.debug((Object)("flow not found: " + flowAlias));
            throw new NotFoundException("flow not found");
        }
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(rep.getId());
        if (model == null) {
            this.session.getTransaction().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        if (!model.getRequirement().name().equals(rep.getRequirement())) {
            model.setRequirement(AuthenticationExecutionModel.Requirement.valueOf((String)rep.getRequirement()));
            this.realm.updateAuthenticatorExecution(model);
        }
    }

    @Path(value="/executions/{executionId}/config")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response newExecutionConfig(@PathParam(value="executionId") String execution, AuthenticatorConfigModel config) {
        this.auth.requireManage();
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            this.session.getTransaction().setRollbackOnly();
            throw new NotFoundException("Illegal execution");
        }
        config = this.realm.addAuthenticatorConfig(config);
        model.setAuthenticatorConfig(config.getId());
        this.realm.updateAuthenticatorExecution(model);
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(config.getId()).build(new Object[0])).build();
    }

    @Path(value="/executions/{executionId}/config/{id}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public AuthenticatorConfigModel getAuthenticatorConfig(@PathParam(value="executionId") String execution, @PathParam(value="id") String id) {
        this.auth.requireView();
        AuthenticatorConfigModel config = this.realm.getAuthenticatorConfigById(id);
        if (config == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        return config;
    }

    @Path(value="required-actions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RequiredActionProviderRepresentation> getRequiredActions() {
        LinkedList<RequiredActionProviderRepresentation> list = new LinkedList<RequiredActionProviderRepresentation>();
        for (RequiredActionProviderModel model : this.realm.getRequiredActionProviders()) {
            RequiredActionProviderRepresentation rep = AuthenticationManagementResource.toRepresentation(model);
            list.add(rep);
        }
        return list;
    }

    public static RequiredActionProviderRepresentation toRepresentation(RequiredActionProviderModel model) {
        RequiredActionProviderRepresentation rep = new RequiredActionProviderRepresentation();
        rep.setAlias(model.getAlias());
        rep.setName(model.getName());
        rep.setDefaultAction(model.isDefaultAction());
        rep.setEnabled(model.isEnabled());
        rep.setConfig(model.getConfig());
        return rep;
    }

    @Path(value="required-actions/{alias}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public RequiredActionProviderRepresentation getRequiredAction(@PathParam(value="alias") String alias) {
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action: " + alias);
        }
        return AuthenticationManagementResource.toRepresentation(model);
    }

    @Path(value="required-actions/{alias}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateRequiredAction(@PathParam(value="alias") String alias, RequiredActionProviderRepresentation rep) {
        this.auth.requireManage();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action: " + alias);
        }
        RequiredActionProviderModel update = new RequiredActionProviderModel();
        update.setId(model.getId());
        update.setName(rep.getName());
        update.setAlias(rep.getAlias());
        update.setProviderId(model.getProviderId());
        update.setDefaultAction(rep.isDefaultAction());
        update.setEnabled(rep.isEnabled());
        update.setConfig(rep.getConfig());
        this.realm.updateRequiredActionProvider(update);
    }

    @Path(value="required-actions/{alias}")
    @DELETE
    public void updateRequiredAction(@PathParam(value="alias") String alias) {
        this.auth.requireManage();
        RequiredActionProviderModel model = this.realm.getRequiredActionProviderByAlias(alias);
        if (model == null) {
            throw new NotFoundException("Failed to find required action: " + alias);
        }
        this.realm.removeRequiredActionProvider(model);
    }

    @Path(value="config-description/{providerId}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public AuthenticatorConfigDescription getAuthenticatorConfigDescription(@PathParam(value="providerId") String providerId) {
        this.auth.requireView();
        ConfigurableAuthenticatorFactory factory = CredentialHelper.getConfigurableAuthenticatorFactory(this.session, providerId);
        if (factory == null) {
            throw new NotFoundException("Could not find authenticator provider");
        }
        AuthenticatorConfigDescription rep = new AuthenticatorConfigDescription();
        rep.setProviderId(providerId);
        rep.setName(factory.getDisplayType());
        rep.setHelpText(factory.getHelpText());
        rep.setProperties(new LinkedList<ConfigPropertyRepresentation>());
        List configProperties = factory.getConfigProperties();
        for (ProviderConfigProperty prop : configProperties) {
            ConfigPropertyRepresentation propRep = new ConfigPropertyRepresentation();
            propRep.setName(prop.getName());
            propRep.setLabel(prop.getLabel());
            propRep.setType(prop.getType());
            propRep.setDefaultValue(prop.getDefaultValue());
            propRep.setHelpText(prop.getHelpText());
            rep.getProperties().add(propRep);
        }
        return rep;
    }

    @Path(value="config")
    @POST
    @NoCache
    public Response createAuthenticatorConfig(AuthenticatorConfigModel config) {
        this.auth.requireManage();
        config = this.realm.addAuthenticatorConfig(config);
        return Response.created((URI)this.uriInfo.getAbsolutePathBuilder().path(config.getId()).build(new Object[0])).build();
    }

    @Path(value="config/{id}")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public AuthenticatorConfigModel getAuthenticatorConfig(@PathParam(value="id") String id) {
        this.auth.requireView();
        AuthenticatorConfigModel config = this.realm.getAuthenticatorConfigById(id);
        if (config == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        return config;
    }

    @Path(value="config/{id}")
    @DELETE
    @NoCache
    public void removeAuthenticatorConfig(@PathParam(value="id") String id) {
        this.auth.requireManage();
        AuthenticatorConfigModel config = this.realm.getAuthenticatorConfigById(id);
        if (config == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        LinkedList flows = new LinkedList();
        for (AuthenticationFlowModel flow : this.realm.getAuthenticationFlows()) {
            for (AuthenticationExecutionModel exe : this.realm.getAuthenticationExecutions(flow.getId())) {
                if (!id.equals(exe.getAuthenticatorConfig())) continue;
                exe.setAuthenticatorConfig(null);
                this.realm.updateAuthenticatorExecution(exe);
            }
        }
        this.realm.removeAuthenticatorConfig(config);
    }

    @Path(value="config/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @NoCache
    public void updateAuthenticatorConfig(@PathParam(value="id") String id, AuthenticatorConfigModel config) {
        this.auth.requireManage();
        AuthenticatorConfigModel exists = this.realm.getAuthenticatorConfigById(id);
        if (exists == null) {
            throw new NotFoundException("Could not find authenticator config");
        }
        exists.setAlias(config.getAlias());
        exists.setConfig(config.getConfig());
        this.realm.updateAuthenticatorConfig(exists);
    }

    public class AuthenticatorConfigDescription {
        protected String name;
        protected String providerId;
        protected String helpText;
        protected List<ConfigPropertyRepresentation> properties;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getHelpText() {
            return this.helpText;
        }

        public String getProviderId() {
            return this.providerId;
        }

        public void setProviderId(String providerId) {
            this.providerId = providerId;
        }

        public void setHelpText(String helpText) {
            this.helpText = helpText;
        }

        public List<ConfigPropertyRepresentation> getProperties() {
            return this.properties;
        }

        public void setProperties(List<ConfigPropertyRepresentation> properties) {
            this.properties = properties;
        }
    }

    public static class RequiredActionProviderRepresentation {
        private String alias;
        private String name;
        private boolean enabled;
        private boolean defaultAction;
        private Map<String, String> config = new HashMap<String, String>();

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isDefaultAction() {
            return this.defaultAction;
        }

        public void setDefaultAction(boolean defaultAction) {
            this.defaultAction = defaultAction;
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        public void setConfig(Map<String, String> config) {
            this.config = config;
        }
    }

    public static class AuthenticationExecutionRepresentation {
        protected String id;
        protected String referenceType;
        protected String requirement;
        protected List<String> requirementChoices;
        protected Boolean configurable;
        protected Boolean subFlow;
        protected String providerId;
        protected String authenticationConfig;

        public String getId() {
            return this.id;
        }

        public void setId(String execution) {
            this.id = execution;
        }

        public String getReferenceType() {
            return this.referenceType;
        }

        public void setReferenceType(String referenceType) {
            this.referenceType = referenceType;
        }

        public String getRequirement() {
            return this.requirement;
        }

        public void setRequirement(String requirement) {
            this.requirement = requirement;
        }

        public List<String> getRequirementChoices() {
            return this.requirementChoices;
        }

        public void setRequirementChoices(List<String> requirementChoices) {
            this.requirementChoices = requirementChoices;
        }

        public Boolean getConfigurable() {
            return this.configurable;
        }

        public void setConfigurable(Boolean configurable) {
            this.configurable = configurable;
        }

        public Boolean getSubFlow() {
            return this.subFlow;
        }

        public void setSubFlow(Boolean subFlow) {
            this.subFlow = subFlow;
        }

        public String getProviderId() {
            return this.providerId;
        }

        public void setProviderId(String providerId) {
            this.providerId = providerId;
        }

        public String getAuthenticationConfig() {
            return this.authenticationConfig;
        }

        public void setAuthenticationConfig(String authenticationConfig) {
            this.authenticationConfig = authenticationConfig;
        }
    }
}

