/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.cache.CacheUserProvider;

public class NoCacheUserProvider
implements CacheUserProvider {
    protected KeycloakSession session;
    protected UserProvider delegate;

    public NoCacheUserProvider(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public UserProvider getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        this.delegate = (UserProvider)this.session.getProvider(UserProvider.class);
        return this.delegate;
    }

    @Override
    public void registerUserInvalidation(RealmModel realm, String id) {
    }

    public UserModel getUserById(String id, RealmModel realm) {
        return this.getDelegate().getUserById(id, realm);
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        return this.getDelegate().getUserByUsername(username, realm);
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        return this.getDelegate().getUserByEmail(email, realm);
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public UserModel getUserByFederatedIdentity(FederatedIdentityModel socialLink, RealmModel realm) {
        return this.getDelegate().getUserByFederatedIdentity(socialLink, realm);
    }

    public UserModel getUserByServiceAccountClient(ClientModel client) {
        return this.getDelegate().getUserByServiceAccountClient(client);
    }

    public List<UserModel> getUsers(RealmModel realm, boolean includeServiceAccounts) {
        return this.getDelegate().getUsers(realm, includeServiceAccounts);
    }

    public int getUsersCount(RealmModel realm) {
        return this.getDelegate().getUsersCount(realm);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults, boolean includeServiceAccounts) {
        return this.getDelegate().getUsers(realm, firstResult, maxResults, includeServiceAccounts);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.getDelegate().searchForUser(search, realm);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        return this.getDelegate().searchForUser(search, realm, firstResult, maxResults);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        return this.getDelegate().searchForUserByAttributes(attributes, realm);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        return this.getDelegate().searchForUserByAttributes(attributes, realm, firstResult, maxResults);
    }

    public List<UserModel> searchForUserByUserAttributes(Map<String, String> attributes, RealmModel realm) {
        return this.getDelegate().searchForUserByUserAttributes(attributes, realm);
    }

    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel user, RealmModel realm) {
        return this.getDelegate().getFederatedIdentities(user, realm);
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel user, String socialProvider, RealmModel realm) {
        return this.getDelegate().getFederatedIdentity(user, socialProvider, realm);
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        return this.getDelegate().addUser(realm, id, username, addDefaultRoles, addDefaultRequiredActions);
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.getDelegate().addUser(realm, username);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        return this.getDelegate().removeUser(realm, user);
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel socialLink) {
        this.getDelegate().addFederatedIdentity(realm, user, socialLink);
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        this.getDelegate().updateFederatedIdentity(realm, federatedUser, federatedIdentityModel);
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        return this.getDelegate().removeFederatedIdentity(realm, user, socialProvider);
    }

    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        return this.getDelegate().validCredentials(realm, user, input);
    }

    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return this.getDelegate().validCredentials(realm, user, input);
    }

    public CredentialValidationOutput validCredentials(RealmModel realm, UserCredentialModel ... input) {
        return this.getDelegate().validCredentials(realm, input);
    }

    public void preRemove(RealmModel realm) {
        this.getDelegate().preRemove(realm);
    }

    public void preRemove(RealmModel realm, UserFederationProviderModel link) {
        this.getDelegate().preRemove(realm, link);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.getDelegate().preRemove(realm, role);
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        this.getDelegate().preRemove(realm, client);
    }

    public void preRemove(ClientModel client, ProtocolMapperModel protocolMapper) {
        this.getDelegate().preRemove(client, protocolMapper);
    }
}

