/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import java.lang.reflect.Method;
import org.keycloak.models.UserModel;

public class ProtocolMapperUtils {
    public static final String USER_ATTRIBUTE = "user.attribute";
    public static final String USER_SESSION_NOTE = "user.session.note";
    public static final String MULTIVALUED = "multivalued";
    public static final String USER_MODEL_PROPERTY_LABEL = "User Property";
    public static final String USER_MODEL_PROPERTY_HELP_TEXT = "Name of the property method in the UserModel interface.  For example, a value of 'email' would reference the UserModel.getEmail() method.";
    public static final String USER_MODEL_ATTRIBUTE_LABEL = "User Attribute";
    public static final String USER_MODEL_ATTRIBUTE_HELP_TEXT = "Name of stored user attribute which is the name of an attribute within the UserModel.attribute map.";
    public static final String USER_SESSION_MODEL_NOTE_LABEL = "User Session Note";
    public static final String USER_SESSION_MODEL_NOTE_HELP_TEXT = "Name of stored user session note within the UserSessionModel.note map.";
    public static final String MULTIVALUED_LABEL = "Multivalued";
    public static final String MULTIVALUED_HELP_TEXT = "Indicates if attribute supports multiple values. If true, then the list of all values of this attribute will be set as claim. If false, then just first value will be set as claim";

    public static String getUserModelValue(UserModel user, String propertyName) {
        Object val;
        Method method;
        String methodName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            method = UserModel.class.getMethod(methodName, new Class[0]);
            val = method.invoke((Object)user, new Object[0]);
            if (val != null) {
                return val.toString();
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        methodName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            method = UserModel.class.getMethod(methodName, new Class[0]);
            val = method.invoke((Object)user, new Object[0]);
            if (val != null) {
                return val.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String[] parseRole(String role) {
        int scopeIndex = role.lastIndexOf(46);
        if (scopeIndex > -1) {
            String appName = role.substring(0, scopeIndex);
            role = role.substring(scopeIndex + 1);
            String[] rtn = new String[]{appName, role};
            return rtn;
        }
        String[] rtn = new String[]{null, role};
        return rtn;
    }
}

