/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;

public abstract class TxAwareLDAPUserModelDelegate
extends UserModelDelegate {
    public static final Logger logger = Logger.getLogger(TxAwareLDAPUserModelDelegate.class);
    protected LDAPFederationProvider provider;
    protected LDAPObject ldapUser;
    private final LDAPTransaction transaction;

    public TxAwareLDAPUserModelDelegate(UserModel delegate, LDAPFederationProvider provider, LDAPObject ldapUser) {
        super(delegate);
        this.provider = provider;
        this.ldapUser = ldapUser;
        this.transaction = this.findOrCreateTransaction();
    }

    public LDAPTransaction getTransaction() {
        return this.transaction;
    }

    private LDAPTransaction findOrCreateTransaction() {
        UserModel deleg;
        TxAwareLDAPUserModelDelegate delegate = this;
        do {
            if ((deleg = delegate.getDelegate()) instanceof UserModelDelegate) continue;
            return new LDAPTransaction();
        } while (!((delegate = (UserModelDelegate)deleg) instanceof TxAwareLDAPUserModelDelegate));
        TxAwareLDAPUserModelDelegate txDelegate = delegate;
        return txDelegate.getTransaction();
    }

    protected void ensureTransactionStarted() {
        if (this.transaction.state == TransactionState.NOT_STARTED) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Starting and enlisting transaction for object " + this.ldapUser.getDn().toString()));
            }
            this.provider.getSession().getTransaction().enlistAfterCompletion((KeycloakTransaction)this.transaction);
        }
    }

    protected static enum TransactionState {
        NOT_STARTED,
        STARTED,
        ROLLBACK_ONLY,
        FINISHED;

    }

    protected class LDAPTransaction
    implements KeycloakTransaction {
        protected TransactionState state = TransactionState.NOT_STARTED;

        protected LDAPTransaction() {
        }

        public void begin() {
            if (this.state != TransactionState.NOT_STARTED) {
                throw new IllegalStateException("Transaction already started");
            }
            this.state = TransactionState.STARTED;
        }

        public void commit() {
            if (this.state != TransactionState.STARTED) {
                throw new IllegalStateException("Transaction in illegal state for commit: " + (Object)((Object)this.state));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Transaction commit! Updating LDAP attributes for object " + TxAwareLDAPUserModelDelegate.this.ldapUser.getDn().toString() + ", attributes: " + TxAwareLDAPUserModelDelegate.this.ldapUser.getAttributes()));
            }
            TxAwareLDAPUserModelDelegate.this.provider.getLdapIdentityStore().update(TxAwareLDAPUserModelDelegate.this.ldapUser);
            this.state = TransactionState.FINISHED;
        }

        public void rollback() {
            if (this.state != TransactionState.STARTED && this.state != TransactionState.ROLLBACK_ONLY) {
                throw new IllegalStateException("Transaction in illegal state for rollback: " + (Object)((Object)this.state));
            }
            logger.warn((Object)("Transaction rollback! Ignoring LDAP updates for object " + TxAwareLDAPUserModelDelegate.this.ldapUser.getDn().toString()));
            this.state = TransactionState.FINISHED;
        }

        public void setRollbackOnly() {
            this.state = TransactionState.ROLLBACK_ONLY;
        }

        public boolean getRollbackOnly() {
            return this.state == TransactionState.ROLLBACK_ONLY;
        }

        public boolean isActive() {
            return this.state == TransactionState.STARTED || this.state == TransactionState.ROLLBACK_ONLY;
        }
    }
}

