/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.kerberos.impl;

import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.keycloak.federation.kerberos.CommonKerberosConfig;

public class KerberosServerSubjectAuthenticator {
    private static final Logger logger = Logger.getLogger(KerberosServerSubjectAuthenticator.class);
    private final CommonKerberosConfig config;
    private LoginContext loginContext;

    public KerberosServerSubjectAuthenticator(CommonKerberosConfig config) {
        this.config = config;
    }

    public Subject authenticateServerSubject() throws LoginException {
        Configuration config = this.createJaasConfiguration();
        this.loginContext = new LoginContext("does-not-matter", null, null, config);
        this.loginContext.login();
        return this.loginContext.getSubject();
    }

    public void logoutServerSubject() {
        if (this.loginContext != null) {
            try {
                this.loginContext.logout();
            }
            catch (LoginException le) {
                logger.error((Object)("Failed to logout kerberos server subject: " + this.config.getServerPrincipal()), (Throwable)le);
            }
        }
    }

    protected Configuration createJaasConfiguration() {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("storeKey", "true");
                options.put("doNotPrompt", "true");
                options.put("isInitiator", "false");
                options.put("useKeyTab", "true");
                options.put("keyTab", KerberosServerSubjectAuthenticator.this.config.getKeyTab());
                options.put("principal", KerberosServerSubjectAuthenticator.this.config.getServerPrincipal());
                options.put("debug", String.valueOf(KerberosServerSubjectAuthenticator.this.config.getDebug()));
                AppConfigurationEntry kerberosLMConfiguration = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                return new AppConfigurationEntry[]{kerberosLMConfiguration};
            }
        };
    }
}

