/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.idm.model;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;

public class LDAPDn {
    private final Deque<Entry> entries = new LinkedList<Entry>();

    public static LDAPDn fromString(String dnString) {
        String[] rdns;
        LDAPDn dn = new LDAPDn();
        for (String entryStr : rdns = dnString.split("(?<!\\\\),")) {
            String[] rdn = entryStr.split("(?<!\\\\)=");
            dn.addLast(rdn[0].trim(), rdn[1].trim());
        }
        return dn;
    }

    public String toString() {
        return LDAPDn.toString(this.entries);
    }

    private static String toString(Collection<Entry> entries) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Entry rdn : entries) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(rdn.attrName).append("=").append(rdn.attrValue);
        }
        return builder.toString();
    }

    public String getFirstRdn() {
        Entry firstEntry = this.entries.getFirst();
        return firstEntry.attrName + "=" + firstEntry.attrValue;
    }

    public String getFirstRdnAttrName() {
        Entry firstEntry = this.entries.getFirst();
        return firstEntry.attrName;
    }

    public String getParentDn() {
        LinkedList<Entry> parentDnEntries = new LinkedList<Entry>(this.entries);
        parentDnEntries.remove();
        return LDAPDn.toString(parentDnEntries);
    }

    public void addFirst(String rdnName, String rdnValue) {
        rdnValue = this.escape(rdnValue);
        this.entries.addFirst(new Entry(rdnName, rdnValue));
    }

    private void addLast(String rdnName, String rdnValue) {
        this.entries.addLast(new Entry(rdnName, rdnValue));
    }

    private String escape(String rdnValue) {
        if (rdnValue.contains(",")) {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (String split : rdnValue.split(",")) {
                if (!first) {
                    result.append("\\,");
                } else {
                    first = false;
                }
                result.append(split);
            }
            return result.toString();
        }
        return rdnValue;
    }

    private static class Entry {
        private final String attrName;
        private final String attrValue;

        private Entry(String attrName, String attrValue) {
            this.attrName = attrName;
            this.attrValue = attrValue;
        }
    }
}

