/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.freemarker.beans;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.models.RealmModel;

public class LocaleBean {
    private String current;
    private List<Locale> supported;

    public LocaleBean(RealmModel realm, java.util.Locale current, UriBuilder uriBuilder, Properties messages) {
        this.current = messages.getProperty("locale_" + current.toLanguageTag(), current.toLanguageTag());
        this.supported = new LinkedList<Locale>();
        for (String l : realm.getSupportedLocales()) {
            String label = messages.getProperty("locale_" + l, l);
            String url = uriBuilder.replaceQueryParam("kc_locale", new Object[]{l}).build(new Object[0]).toString();
            this.supported.add(new Locale(label, url));
        }
    }

    public String getCurrent() {
        return this.current;
    }

    public List<Locale> getSupported() {
        return this.supported;
    }

    public static class Locale {
        private String label;
        private String url;

        public Locale(String label, String url) {
            this.label = label;
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

