/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.cache.CacheUserProvider;
import org.keycloak.models.cache.CacheUserProviderFactory;
import org.keycloak.models.cache.entities.CachedUser;
import org.keycloak.models.cache.infinispan.DefaultCacheUserProvider;
import org.keycloak.models.cache.infinispan.InfinispanUserCache;

public class InfinispanCacheUserProviderFactory
implements CacheUserProviderFactory {
    protected InfinispanUserCache userCache;
    protected final RealmLookup usernameLookup = new RealmLookup();
    protected final RealmLookup emailLookup = new RealmLookup();
    private boolean isNewInfinispan;

    public CacheUserProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new DefaultCacheUserProvider(this.userCache, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.userCache == null) {
            InfinispanCacheUserProviderFactory infinispanCacheUserProviderFactory = this;
            synchronized (infinispanCacheUserProviderFactory) {
                if (this.userCache == null) {
                    this.checkIspnVersion();
                    Cache cache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("users");
                    cache.addListener((Object)new CacheListener());
                    this.userCache = new InfinispanUserCache((Cache<String, CachedUser>)cache, this.usernameLookup, this.emailLookup);
                }
            }
        }
    }

    protected void checkIspnVersion() {
        try {
            CacheEntryCreatedEvent.class.getMethod("getValue", new Class[0]);
            this.isNewInfinispan = true;
        }
        catch (NoSuchMethodException nsme) {
            this.isNewInfinispan = false;
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }

    static class RealmLookup {
        protected final ConcurrentHashMap<String, ConcurrentHashMap<String, String>> lookup = new ConcurrentHashMap();

        RealmLookup() {
        }

        public void put(String realm, String key, String value) {
            ConcurrentHashMap<String, String> p;
            ConcurrentHashMap<String, String> map = this.lookup.get(realm);
            if (map == null && (p = this.lookup.putIfAbsent(realm, map = new ConcurrentHashMap())) != null) {
                map = p;
            }
            map.put(key, value);
        }

        public String get(String realm, String key) {
            ConcurrentHashMap<String, String> map = this.lookup.get(realm);
            return map != null ? map.get(key) : null;
        }

        public void remove(String realm, String key) {
            ConcurrentHashMap<String, String> map = this.lookup.get(realm);
            if (map != null) {
                map.remove(key);
                if (map.isEmpty()) {
                    this.lookup.remove(realm);
                }
            }
        }
    }

    @Listener
    public class CacheListener {
        @CacheEntryCreated
        public void userCreated(CacheEntryCreatedEvent<String, CachedUser> event) {
            if (!event.isPre()) {
                CachedUser cachedUser;
                if (InfinispanCacheUserProviderFactory.this.isNewInfinispan) {
                    cachedUser = (CachedUser)event.getValue();
                } else {
                    String userId = (String)event.getKey();
                    cachedUser = (CachedUser)event.getCache().get((Object)userId);
                }
                if (cachedUser != null) {
                    String realm = cachedUser.getRealm();
                    InfinispanCacheUserProviderFactory.this.usernameLookup.put(realm, cachedUser.getUsername(), cachedUser.getId());
                    if (cachedUser.getEmail() != null) {
                        InfinispanCacheUserProviderFactory.this.emailLookup.put(realm, cachedUser.getEmail(), cachedUser.getId());
                    }
                }
            }
        }

        @CacheEntryRemoved
        public void userRemoved(CacheEntryRemovedEvent<String, CachedUser> event) {
            if (event.isPre() && event.getValue() != null) {
                CachedUser cachedUser = (CachedUser)event.getValue();
                String realm = cachedUser.getRealm();
                InfinispanCacheUserProviderFactory.this.usernameLookup.remove(realm, cachedUser.getUsername());
                if (cachedUser.getEmail() != null) {
                    InfinispanCacheUserProviderFactory.this.emailLookup.remove(realm, cachedUser.getEmail());
                }
            }
        }
    }
}

