/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import org.infinispan.Cache;
import org.infinispan.Version;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UserSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.compat.MemUserSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class InfinispanUserSessionProviderFactory
implements UserSessionProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProviderFactory.class);
    private Boolean compatMode;
    private MemUserSessionProviderFactory compatProviderFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserSessionProvider create(KeycloakSession session) {
        if (this.compatMode == null) {
            InfinispanUserSessionProviderFactory infinispanUserSessionProviderFactory = this;
            synchronized (infinispanUserSessionProviderFactory) {
                if (this.compatMode == null) {
                    this.compatMode = InfinispanUserSessionProviderFactory.isCompatMode(session);
                    if (this.compatMode.booleanValue()) {
                        this.compatProviderFactory = new MemUserSessionProviderFactory();
                        log.info((Object)"Infinispan version doesn't support map reduce for local cache. Falling back to deprecated mem user session provider.");
                    }
                }
            }
        }
        if (!this.compatMode.booleanValue()) {
            InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
            Cache cache = connections.getCache("sessions");
            Cache loginFailures = connections.getCache("loginFailures");
            return new InfinispanUserSessionProvider(session, (Cache<String, SessionEntity>)cache, (Cache<LoginFailureKey, LoginFailureEntity>)loginFailures);
        }
        return this.compatProviderFactory.create(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        if (this.compatProviderFactory != null) {
            this.compatProviderFactory.close();
        }
    }

    public String getId() {
        return "infinispan";
    }

    private static boolean isCompatMode(KeycloakSession session) {
        InfinispanConnectionProvider connections;
        Cache cache;
        return Version.getVersionShort() < Version.getVersionShort((String)"5.3.0.Final") && (cache = (connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("sessions")).getAdvancedCache().getRpcManager() == null;
    }
}

