/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;

public class HardcodedClaim
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String CLAIM_VALUE = "claim.value";
    public static final String PROVIDER_ID = "oidc-hardcoded-claim-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public String getDisplayType() {
        return "Hardcoded claim";
    }

    @Override
    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Hardcode a claim into the token.";
    }

    @Override
    public AccessToken transformAccessToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        if (!OIDCAttributeMapperHelper.includeInAccessToken(mappingModel)) {
            return token;
        }
        this.setClaim((IDToken)token, mappingModel, userSession);
        return token;
    }

    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession) {
        String attributeValue = (String)mappingModel.getConfig().get(CLAIM_VALUE);
        if (attributeValue == null) {
            return;
        }
        OIDCAttributeMapperHelper.mapClaim(token, mappingModel, attributeValue);
    }

    @Override
    public IDToken transformIDToken(IDToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession) {
        if (!OIDCAttributeMapperHelper.includeInIDToken(mappingModel)) {
            return token;
        }
        this.setClaim(token, mappingModel, userSession);
        return token;
    }

    public static ProtocolMapperModel create(String name, String hardcodedName, String hardcodedValue, String claimType, boolean consentRequired, String consentText, boolean accessToken, boolean idToken) {
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(PROVIDER_ID);
        mapper.setProtocol("openid-connect");
        mapper.setConsentRequired(consentRequired);
        mapper.setConsentText(consentText);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("claim.name", hardcodedName);
        config.put(CLAIM_VALUE, hardcodedValue);
        config.put("Claim JSON Type", claimType);
        if (accessToken) {
            config.put("access.token.claim", "true");
        }
        if (idToken) {
            config.put("id.token.claim", "true");
        }
        mapper.setConfig(config);
        return mapper;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("claim.name");
        property.setLabel("Token Claim Name");
        property.setType("String");
        property.setHelpText("Claim name you want to hard code into the token.  This can be a fully qualified name like 'address.street'.  In this case, a nested json object will be created.");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(CLAIM_VALUE);
        property.setLabel("Claim value");
        property.setType("String");
        property.setHelpText("Value of the claim you want to hard code.  'true' and 'false can be used for boolean values.");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName("Claim JSON Type");
        property.setLabel("Claim JSON Type");
        ArrayList<String> types = new ArrayList<String>(3);
        types.add("String");
        types.add("long");
        types.add("int");
        types.add("boolean");
        property.setType("List");
        property.setDefaultValue(types);
        property.setHelpText("JSON type that should be used for the value of the claim.  long, int, boolean, and String are valid values.");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName("id.token.claim");
        property.setLabel("Add to ID token");
        property.setType("boolean");
        property.setDefaultValue((Object)"true");
        property.setHelpText("Should the claim be added to the ID token?");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName("access.token.claim");
        property.setLabel("Add to access token");
        property.setType("boolean");
        property.setDefaultValue((Object)"true");
        property.setHelpText("Should the claim be added to the access token?");
        configProperties.add(property);
    }
}

