/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.updater.impl.updates;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import org.keycloak.connections.mongo.updater.impl.updates.Update;
import org.keycloak.models.KeycloakSession;

public class Update1_3_0
extends Update {
    @Override
    public String getId() {
        return "1.3.0";
    }

    @Override
    public void update(KeycloakSession session) {
        this.deleteEntries("clientSessions");
        this.deleteEntries("sessions");
        this.removeField("realms", "passwordCredentialGrantAllowed");
        this.updateIdentityProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIdentityProviders() {
        DBCollection realms = this.db.getCollection("realms");
        try (DBCursor realmsCursor = realms.find();){
            while (realmsCursor.hasNext()) {
                BasicDBObject realm = (BasicDBObject)realmsCursor.next();
                BasicDBList identityProviders = (BasicDBList)realm.get("identityProviders");
                if (identityProviders != null) {
                    for (Object ipObj : identityProviders) {
                        BasicDBObject identityProvider = (BasicDBObject)ipObj;
                        boolean updateProfileFirstLogin = identityProvider.getBoolean("updateProfileFirstLogin");
                        String upflMode = updateProfileFirstLogin ? "on" : "off";
                        identityProvider.put("updateProfileFirstLoginMode", (Object)upflMode);
                        identityProvider.removeField("updateProfileFirstLogin");
                        identityProvider.put("trustEmail", (Object)false);
                    }
                }
                realms.save((DBObject)realm);
            }
        }
    }
}

