/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.account.freemarker;

import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.account.AccountPages;
import org.keycloak.account.AccountProvider;
import org.keycloak.account.freemarker.Templates;
import org.keycloak.account.freemarker.model.AccountBean;
import org.keycloak.account.freemarker.model.AccountFederatedIdentityBean;
import org.keycloak.account.freemarker.model.ApplicationsBean;
import org.keycloak.account.freemarker.model.FeaturesBean;
import org.keycloak.account.freemarker.model.LogBean;
import org.keycloak.account.freemarker.model.PasswordBean;
import org.keycloak.account.freemarker.model.RealmBean;
import org.keycloak.account.freemarker.model.ReferrerBean;
import org.keycloak.account.freemarker.model.SessionsBean;
import org.keycloak.account.freemarker.model.TotpBean;
import org.keycloak.account.freemarker.model.UrlBean;
import org.keycloak.events.Event;
import org.keycloak.freemarker.BrowserSecurityHeaderSetup;
import org.keycloak.freemarker.FreeMarkerException;
import org.keycloak.freemarker.FreeMarkerUtil;
import org.keycloak.freemarker.LocaleHelper;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.freemarker.beans.AdvancedMessageFormatterMethod;
import org.keycloak.freemarker.beans.LocaleBean;
import org.keycloak.freemarker.beans.MessageBean;
import org.keycloak.freemarker.beans.MessageFormatterMethod;
import org.keycloak.freemarker.beans.MessageType;
import org.keycloak.freemarker.beans.MessagesPerFieldBean;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.Urls;

public class FreeMarkerAccountProvider
implements AccountProvider {
    private static final Logger logger = Logger.getLogger(FreeMarkerAccountProvider.class);
    private UserModel user;
    private MultivaluedMap<String, String> profileFormData;
    private Response.Status status = Response.Status.OK;
    private RealmModel realm;
    private String[] referrer;
    private List<Event> events;
    private String stateChecker;
    private List<UserSessionModel> sessions;
    private boolean identityProviderEnabled;
    private boolean eventsEnabled;
    private boolean passwordUpdateSupported;
    private boolean passwordSet;
    private KeycloakSession session;
    private FreeMarkerUtil freeMarker;
    private HttpHeaders headers;
    private UriInfo uriInfo;
    private List<FormMessage> messages = null;
    private MessageType messageType = MessageType.ERROR;

    public FreeMarkerAccountProvider(KeycloakSession session, FreeMarkerUtil freeMarker) {
        this.session = session;
        this.freeMarker = freeMarker;
    }

    public AccountProvider setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public AccountProvider setHttpHeaders(HttpHeaders httpHeaders) {
        this.headers = httpHeaders;
        return this;
    }

    public Response createResponse(AccountPages page) {
        Properties messagesBundle;
        Theme theme;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        ThemeProvider themeProvider = (ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending");
        try {
            theme = themeProvider.getTheme(this.realm.getAccountTheme(), Theme.Type.ACCOUNT);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to create theme", (Throwable)e);
            return Response.serverError().build();
        }
        try {
            attributes.put("properties", theme.getProperties());
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load properties", (Throwable)e);
        }
        Locale locale = LocaleHelper.getLocale((RealmModel)this.realm, (UserModel)this.user, (UriInfo)this.uriInfo, (HttpHeaders)this.headers);
        try {
            messagesBundle = theme.getMessages(locale);
            attributes.put("msg", new MessageFormatterMethod(locale, messagesBundle));
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load messages", (Throwable)e);
            messagesBundle = new Properties();
        }
        URI baseUri = this.uriInfo.getBaseUri();
        UriBuilder baseUriBuilder = this.uriInfo.getBaseUriBuilder();
        for (Map.Entry e : this.uriInfo.getQueryParameters().entrySet()) {
            baseUriBuilder.queryParam((String)e.getKey(), ((List)e.getValue()).toArray());
        }
        URI baseQueryUri = baseUriBuilder.build(new Object[0]);
        if (this.stateChecker != null) {
            attributes.put("stateChecker", this.stateChecker);
        }
        MessagesPerFieldBean messagesPerField = new MessagesPerFieldBean();
        if (this.messages != null) {
            MessageBean wholeMessage = new MessageBean(null, this.messageType);
            for (FormMessage message : this.messages) {
                String formattedMessageText = this.formatMessage(message, messagesBundle, locale);
                if (formattedMessageText == null) continue;
                wholeMessage.appendSummaryLine(formattedMessageText);
                messagesPerField.addMessage(message.getField(), formattedMessageText, this.messageType);
            }
            attributes.put("message", wholeMessage);
        }
        attributes.put("messagesPerField", messagesPerField);
        if (this.referrer != null) {
            attributes.put("referrer", new ReferrerBean(this.referrer));
        }
        if (this.realm != null) {
            attributes.put("realm", new RealmBean(this.realm));
        }
        attributes.put("url", new UrlBean(this.realm, theme, baseUri, baseQueryUri, this.uriInfo.getRequestUri(), this.stateChecker));
        if (this.realm.isInternationalizationEnabled()) {
            switch (page) {
                default: 
            }
            UriBuilder b = UriBuilder.fromUri((URI)baseQueryUri).path(this.uriInfo.getPath());
            attributes.put("locale", new LocaleBean(this.realm, locale, b, messagesBundle));
        }
        attributes.put("features", new FeaturesBean(this.identityProviderEnabled, this.eventsEnabled, this.passwordUpdateSupported));
        attributes.put("account", new AccountBean(this.user, this.profileFormData));
        switch (page) {
            case TOTP: {
                attributes.put("totp", new TotpBean(this.session, this.realm, this.user, baseUri));
                break;
            }
            case FEDERATED_IDENTITY: {
                attributes.put("federatedIdentity", new AccountFederatedIdentityBean(this.session, this.realm, this.user, this.uriInfo.getBaseUri(), this.stateChecker));
                break;
            }
            case LOG: {
                attributes.put("log", new LogBean(this.events));
                break;
            }
            case SESSIONS: {
                attributes.put("sessions", new SessionsBean(this.realm, this.sessions));
                break;
            }
            case APPLICATIONS: {
                attributes.put("applications", new ApplicationsBean(this.realm, this.user));
                attributes.put("advancedMsg", new AdvancedMessageFormatterMethod(locale, messagesBundle));
                break;
            }
            case PASSWORD: {
                attributes.put("password", new PasswordBean(this.passwordSet));
            }
        }
        try {
            String result = this.freeMarker.processTemplate(attributes, Templates.getTemplate(page), theme);
            Response.ResponseBuilder builder = Response.status((Response.Status)this.status).type("text/html").entity((Object)result);
            BrowserSecurityHeaderSetup.headers((Response.ResponseBuilder)builder, (RealmModel)this.realm);
            LocaleHelper.updateLocaleCookie((Response.ResponseBuilder)builder, (Locale)locale, (RealmModel)this.realm, (UriInfo)this.uriInfo, (String)Urls.localeCookiePath((URI)baseUri, (String)this.realm.getName()));
            return builder.build();
        }
        catch (FreeMarkerException e) {
            logger.error((Object)"Failed to process template", (Throwable)e);
            return Response.serverError().build();
        }
    }

    public AccountProvider setPasswordSet(boolean passwordSet) {
        this.passwordSet = passwordSet;
        return this;
    }

    protected void setMessage(MessageType type, String message, Object ... parameters) {
        this.messageType = type;
        this.messages = new ArrayList<FormMessage>();
        this.messages.add(new FormMessage(null, message, parameters));
    }

    protected String formatMessage(FormMessage message, Properties messagesBundle, Locale locale) {
        if (message == null) {
            return null;
        }
        if (messagesBundle.containsKey(message.getMessage())) {
            return new MessageFormat(messagesBundle.getProperty(message.getMessage()), locale).format(message.getParameters());
        }
        return message.getMessage();
    }

    public AccountProvider setErrors(List<FormMessage> messages) {
        this.messageType = MessageType.ERROR;
        this.messages = new ArrayList<FormMessage>(messages);
        return this;
    }

    public AccountProvider setError(String message, Object ... parameters) {
        this.setMessage(MessageType.ERROR, message, parameters);
        return this;
    }

    public AccountProvider setSuccess(String message, Object ... parameters) {
        this.setMessage(MessageType.SUCCESS, message, parameters);
        return this;
    }

    public AccountProvider setWarning(String message, Object ... parameters) {
        this.setMessage(MessageType.WARNING, message, parameters);
        return this;
    }

    public AccountProvider setUser(UserModel user) {
        this.user = user;
        return this;
    }

    public AccountProvider setProfileFormData(MultivaluedMap<String, String> formData) {
        this.profileFormData = formData;
        return this;
    }

    public AccountProvider setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public AccountProvider setStatus(Response.Status status) {
        this.status = status;
        return this;
    }

    public AccountProvider setReferrer(String[] referrer) {
        this.referrer = referrer;
        return this;
    }

    public AccountProvider setEvents(List<Event> events) {
        this.events = events;
        return this;
    }

    public AccountProvider setSessions(List<UserSessionModel> sessions) {
        this.sessions = sessions;
        return this;
    }

    public AccountProvider setStateChecker(String stateChecker) {
        this.stateChecker = stateChecker;
        return this;
    }

    public AccountProvider setFeatures(boolean identityProviderEnabled, boolean eventsEnabled, boolean passwordUpdateSupported) {
        this.identityProviderEnabled = identityProviderEnabled;
        this.eventsEnabled = eventsEnabled;
        this.passwordUpdateSupported = passwordUpdateSupported;
        return this;
    }

    public void close() {
    }
}

