/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.OAuthErrorException;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.Cors;

public class LogoutEndpoint {
    protected static Logger logger = Logger.getLogger(LogoutEndpoint.class);
    @Context
    private KeycloakSession session;
    @Context
    private ClientConnection clientConnection;
    @Context
    private HttpRequest request;
    @Context
    private HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    private TokenManager tokenManager;
    private AuthenticationManager authManager;
    private RealmModel realm;
    private EventBuilder event;

    public LogoutEndpoint(TokenManager tokenManager, AuthenticationManager authManager, RealmModel realm, EventBuilder event) {
        this.tokenManager = tokenManager;
        this.authManager = authManager;
        this.realm = realm;
        this.event = event;
    }

    @GET
    @NoCache
    public Response logout(@QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="id_token_hint") String encodedIdToken, @QueryParam(value="post_logout_redirect_uri") String postLogoutRedirectUri, @QueryParam(value="state") String state) {
        AuthenticationManager.AuthResult authResult;
        String redirect;
        String string = redirect = postLogoutRedirectUri != null ? postLogoutRedirectUri : redirectUri;
        if (redirect != null) {
            String validatedUri = RedirectUtils.verifyRealmRedirectUri(this.uriInfo, redirect, this.realm);
            if (validatedUri == null) {
                this.event.event(EventType.LOGOUT);
                this.event.detail("redirect_uri", redirect);
                this.event.error("invalid_redirect_uri");
                return ErrorPage.error(this.session, "invalidRedirectUriMessage", new Object[0]);
            }
            redirect = validatedUri;
        }
        UserSessionModel userSession = null;
        boolean error = false;
        if (encodedIdToken != null) {
            try {
                IDToken idToken = this.tokenManager.verifyIDToken(this.realm, encodedIdToken);
                userSession = this.session.sessions().getUserSession(this.realm, idToken.getSessionState());
                if (userSession == null) {
                    error = true;
                }
            }
            catch (OAuthErrorException e) {
                error = true;
            }
            if (error) {
                this.event.event(EventType.LOGOUT);
                this.event.error("invalid_token");
                return ErrorPage.error(this.session, "sessionNotActiveMessage", new Object[0]);
            }
        }
        if ((authResult = AuthenticationManager.authenticateIdentityCookie(this.session, this.realm, false)) != null) {
            UserSessionModel userSessionModel = userSession = userSession != null ? userSession : authResult.getSession();
            if (redirect != null) {
                userSession.setNote("OIDC_LOGOUT_REDIRECT_URI", redirect);
            }
            if (state != null) {
                userSession.setNote("OIDC_LOGOUT_STATE_PARAM", state);
            }
            userSession.setNote("KEYCLOAK_LOGOUT_PROTOCOL", "openid-connect");
            logger.debug((Object)"Initiating OIDC browser logout");
            Response response = AuthenticationManager.browserLogout(this.session, this.realm, authResult.getSession(), this.uriInfo, this.clientConnection, this.headers);
            logger.debug((Object)"finishing OIDC browser logout");
            return response;
        }
        if (userSession != null) {
            this.event.event(EventType.LOGOUT);
            AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, this.uriInfo, this.clientConnection, this.headers, true);
            this.event.user(userSession.getUser()).session(userSession).success();
        }
        if (redirect != null) {
            UriBuilder uriBuilder = UriBuilder.fromUri((String)redirect);
            if (state != null) {
                uriBuilder.queryParam("state", new Object[]{state});
            }
            return Response.status((int)302).location(uriBuilder.build(new Object[0])).build();
        }
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response logoutToken(@HeaderParam(value="Authorization") String authorizationHeader) {
        MultivaluedMap form = this.request.getDecodedFormParameters();
        this.checkSsl();
        this.event.event(EventType.LOGOUT);
        ClientModel client = this.authorizeClient();
        String refreshToken = (String)form.getFirst((Object)"refresh_token");
        if (refreshToken == null) {
            this.event.error("invalid_token");
            throw new ErrorResponseException("invalid_request", "No refresh token", Response.Status.BAD_REQUEST);
        }
        try {
            RefreshToken token = this.tokenManager.verifyRefreshToken(this.realm, refreshToken);
            UserSessionModel userSessionModel = this.session.sessions().getUserSession(this.realm, token.getSessionState());
            if (userSessionModel != null) {
                this.logout(userSessionModel);
            }
        }
        catch (OAuthErrorException e) {
            this.event.error("invalid_token");
            throw new ErrorResponseException(e.getError(), e.getDescription(), Response.Status.BAD_REQUEST);
        }
        return Cors.add(this.request, Response.noContent()).auth().allowedOrigins(client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    private void logout(UserSessionModel userSession) {
        AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, this.uriInfo, this.clientConnection, this.headers, true);
        this.event.user(userSession.getUser()).session(userSession).success();
    }

    private ClientModel authorizeClient() {
        ClientModel client = AuthorizeClientUtil.authorizeClient(this.session, this.event, this.realm).getClient();
        if (client.isBearerOnly()) {
            throw new ErrorResponseException("invalid_client", "Bearer-only not allowed", Response.Status.BAD_REQUEST);
        }
        return client;
    }

    private void checkSsl() {
        if (!this.uriInfo.getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new ErrorResponseException("invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }
}

