/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.impl.types;

import com.mongodb.BasicDBObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.types.Mapper;
import org.keycloak.connections.mongo.api.types.MapperContext;
import org.keycloak.connections.mongo.api.types.MapperRegistry;
import org.keycloak.connections.mongo.impl.EntityInfo;
import org.keycloak.connections.mongo.impl.MongoStoreImpl;
import org.keycloak.models.utils.reflection.Property;
import org.keycloak.util.reflections.Types;

public class BasicDBObjectMapper<S>
implements Mapper<BasicDBObject, S> {
    private static final Logger logger = Logger.getLogger(BasicDBObjectMapper.class);
    private final MongoStoreImpl mongoStoreImpl;
    private final MapperRegistry mapperRegistry;
    private final Class<S> expectedEntityType;

    public BasicDBObjectMapper(MongoStoreImpl mongoStoreImpl, MapperRegistry mapperRegistry, Class<S> expectedEntityType) {
        this.mongoStoreImpl = mongoStoreImpl;
        this.mapperRegistry = mapperRegistry;
        this.expectedEntityType = expectedEntityType;
    }

    @Override
    public S convertObject(MapperContext<BasicDBObject, S> context) {
        S entity;
        BasicDBObject dbObject = context.getObjectToConvert();
        if (dbObject == null) {
            return null;
        }
        EntityInfo entityInfo = this.mongoStoreImpl.getEntityInfo(this.expectedEntityType);
        try {
            entity = this.expectedEntityType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (String key : dbObject.keySet()) {
            Object value = dbObject.get(key);
            if ("_id".equals(key)) {
                if (!(entity instanceof MongoIdentifiableEntity)) continue;
                ((MongoIdentifiableEntity)entity).setId(value.toString());
                continue;
            }
            Property<Object> property = entityInfo.getPropertyByName(key);
            if (property != null) {
                this.setPropertyValue(entity, value, property);
                continue;
            }
            logger.warn((Object)("Property with key " + key + " not known for type " + this.expectedEntityType));
        }
        return entity;
    }

    private void setPropertyValue(Object entity, Object valueFromDB, Property property) {
        MapperContext context;
        if (valueFromDB == null) {
            property.setValue(entity, null);
            return;
        }
        Type type = property.getBaseType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            Type[] genericTypeArguments = parameterized.getActualTypeArguments();
            List<Type> genericTypes = Arrays.asList(genericTypeArguments);
            Class expectedReturnType = (Class)parameterized.getRawType();
            context = new MapperContext(valueFromDB, expectedReturnType, genericTypes);
        } else {
            Class expectedReturnType = (Class)type;
            expectedReturnType = Types.boxedClass((Class)expectedReturnType);
            context = new MapperContext(valueFromDB, expectedReturnType, null);
        }
        Object appObject = this.mapperRegistry.convertDBObjectToApplicationObject(context);
        if (!Types.boxedClass((Class)property.getJavaClass()).isAssignableFrom(appObject.getClass())) {
            throw new IllegalStateException("Converted object " + appObject + " is not of type " + context.getExpectedReturnType() + ". So can't be assigned as property " + property.getName() + " of " + entity.getClass());
        }
        property.setValue(entity, appObject);
    }

    @Override
    public Class<? extends BasicDBObject> getTypeOfObjectToConvert() {
        return BasicDBObject.class;
    }

    @Override
    public Class<S> getExpectedReturnType() {
        return this.expectedEntityType;
    }
}

