/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.services.Urls;
import org.keycloak.services.clientregistration.ClientRegistrationService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.wellknown.WellKnownProvider;

public class OIDCWellKnownProvider
implements WellKnownProvider {
    public static final List<String> DEFAULT_ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED = OIDCWellKnownProvider.list("RS256");
    public static final List<String> DEFAULT_GRANT_TYPES_SUPPORTED = OIDCWellKnownProvider.list("authorization_code", "implicit", "refresh_token", "password", "client_credentials");
    public static final List<String> DEFAULT_RESPONSE_TYPES_SUPPORTED = OIDCWellKnownProvider.list("code", "none", "id_token", "id_token token", "code id_token", "code token", "code id_token token");
    public static final List<String> DEFAULT_SUBJECT_TYPES_SUPPORTED = OIDCWellKnownProvider.list("public");
    public static final List<String> DEFAULT_RESPONSE_MODES_SUPPORTED = OIDCWellKnownProvider.list("query", "fragment", "form_post");
    private KeycloakSession session;

    public OIDCWellKnownProvider(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public Object getConfig() {
        UriInfo uriInfo = this.session.getContext().getUri();
        RealmModel realm = this.session.getContext().getRealm();
        UriBuilder uriBuilder = RealmsResource.protocolUrl(uriInfo);
        OIDCConfigurationRepresentation config = new OIDCConfigurationRepresentation();
        config.setIssuer(Urls.realmIssuer(uriInfo.getBaseUri(), realm.getName()));
        config.setAuthorizationEndpoint(uriBuilder.clone().path(OIDCLoginProtocolService.class, "auth").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setTokenEndpoint(uriBuilder.clone().path(OIDCLoginProtocolService.class, "token").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setUserinfoEndpoint(uriBuilder.clone().path(OIDCLoginProtocolService.class, "issueUserInfo").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setLogoutEndpoint(uriBuilder.clone().path(OIDCLoginProtocolService.class, "logout").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setJwksUri(uriBuilder.clone().path(OIDCLoginProtocolService.class, "certs").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setRegistrationEndpoint(RealmsResource.clientRegistrationUrl(uriInfo).path(ClientRegistrationService.class, "provider").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setIdTokenSigningAlgValuesSupported(DEFAULT_ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED);
        config.setResponseTypesSupported(DEFAULT_RESPONSE_TYPES_SUPPORTED);
        config.setSubjectTypesSupported(DEFAULT_SUBJECT_TYPES_SUPPORTED);
        config.setResponseModesSupported(DEFAULT_RESPONSE_MODES_SUPPORTED);
        config.setGrantTypesSupported(DEFAULT_GRANT_TYPES_SUPPORTED);
        return config;
    }

    public void close() {
    }

    private static List<String> list(String ... values) {
        LinkedList<String> s = new LinkedList<String>();
        for (String v : values) {
            s.add(v);
        }
        return s;
    }
}

