/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionContextResult;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.authentication.authenticators.broker.AbstractIdpAuthenticator;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.authentication.requiredactions.VerifyEmail;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.util.CookieHelper;

public class LoginActionsService {
    protected static final Logger logger = Logger.getLogger(LoginActionsService.class);
    public static final String ACTION_COOKIE = "KEYCLOAK_ACTION";
    public static final String AUTHENTICATE_PATH = "authenticate";
    public static final String REGISTRATION_PATH = "registration";
    public static final String RESET_CREDENTIALS_PATH = "reset-credentials";
    public static final String REQUIRED_ACTION = "required-action";
    public static final String FIRST_BROKER_LOGIN_PATH = "first-broker-login";
    private RealmModel realm;
    @Context
    private HttpRequest request;
    @Context
    protected HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private ClientConnection clientConnection;
    @Context
    protected Providers providers;
    @Context
    protected KeycloakSession session;
    private AuthenticationManager authManager;
    private EventBuilder event;

    public static UriBuilder loginActionsBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return LoginActionsService.loginActionsBaseUrl(baseUriBuilder);
    }

    public static UriBuilder authenticationFormProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "authenticateForm");
    }

    public static UriBuilder requiredActionProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "requiredActionPOST");
    }

    public static UriBuilder registrationFormProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "processRegister");
    }

    public static UriBuilder firstBrokerLoginProcessor(UriInfo uriInfo) {
        return LoginActionsService.loginActionsBaseUrl(uriInfo).path(LoginActionsService.class, "firstBrokerLoginGet");
    }

    public static UriBuilder loginActionsBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path(RealmsResource.class, "getLoginActionsService");
    }

    public LoginActionsService(RealmModel realm, AuthenticationManager authManager, EventBuilder event) {
        this.realm = realm;
        this.authManager = authManager;
        this.event = event;
    }

    private boolean checkSsl() {
        if (this.uriInfo.getBaseUri().getScheme().equals("https")) {
            return true;
        }
        return !this.realm.getSslRequired().isRequired(this.clientConnection);
    }

    @Path(value="authenticate")
    @GET
    public Response authenticate(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution) {
        this.event.event(EventType.LOGIN);
        Checks checks = new Checks();
        if (!checks.verifyCode(code, ClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return checks.response;
        }
        this.event.detail("code_id", code);
        ClientSessionCode clientSessionCode = checks.clientCode;
        ClientSessionModel clientSession = clientSessionCode.getClientSession();
        return this.processAuthentication(execution, clientSession, null);
    }

    protected Response processAuthentication(String execution, ClientSessionModel clientSession, String errorMessage) {
        return this.processFlow(execution, clientSession, AUTHENTICATE_PATH, this.realm.getBrowserFlow(), errorMessage, new AuthenticationProcessor());
    }

    protected Response processFlow(String execution, ClientSessionModel clientSession, String flowPath, AuthenticationFlowModel flow, String errorMessage, AuthenticationProcessor processor) {
        processor.setClientSession(clientSession).setFlowPath(flowPath).setBrowserFlow(true).setFlowId(flow.getId()).setConnection(this.clientConnection).setEventBuilder(this.event).setProtector(this.authManager.getProtector()).setRealm(this.realm).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.request);
        if (errorMessage != null) {
            processor.setForwardedErrorMessage(new FormMessage(null, errorMessage));
        }
        try {
            if (execution != null) {
                return processor.authenticationAction(execution);
            }
            return processor.authenticate();
        }
        catch (Exception e) {
            return processor.handleBrowserException(e);
        }
    }

    @Path(value="authenticate")
    @POST
    public Response authenticateForm(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution) {
        this.event.event(EventType.LOGIN);
        Checks checks = new Checks();
        if (!checks.verifyCode(code, ClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return checks.response;
        }
        ClientSessionCode clientCode = checks.clientCode;
        ClientSessionModel clientSession = clientCode.getClientSession();
        return this.processAuthentication(execution, clientSession, null);
    }

    @Path(value="reset-credentials")
    @POST
    public Response resetCredentialsPOST(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution) {
        return this.resetCredentials(code, execution);
    }

    @Path(value="reset-credentials")
    @GET
    public Response resetCredentialsGET(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution) {
        if (code == null) {
            if (!this.realm.isResetPasswordAllowed()) {
                this.event.event(EventType.RESET_PASSWORD);
                this.event.error("not_allowed");
                return ErrorPage.error(this.session, "resetCredentialNotAllowedMessage", new Object[0]);
            }
            ClientModel client = this.realm.getClientByClientId("account");
            ClientSessionModel clientSession = this.session.sessions().createClientSession(this.realm, client);
            clientSession.setAction(ClientSessionModel.Action.AUTHENTICATE.name());
            clientSession.setNote("action_key", KeycloakModelUtils.generateCodeSecret());
            clientSession.setAuthMethod("openid-connect");
            String redirectUri = Urls.accountBase(this.uriInfo.getBaseUri()).path("/").build(new Object[]{this.realm.getName()}).toString();
            clientSession.setRedirectUri(redirectUri);
            clientSession.setAction(ClientSessionModel.Action.AUTHENTICATE.name());
            clientSession.setNote("action_key", KeycloakModelUtils.generateCodeSecret());
            clientSession.setNote("response_type", "code");
            clientSession.setNote("redirect_uri", redirectUri);
            clientSession.setNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
            return this.processResetCredentials(null, clientSession, null);
        }
        return this.resetCredentials(code, execution);
    }

    protected Response resetCredentials(String code, String execution) {
        this.event.event(EventType.RESET_PASSWORD);
        Checks checks = new Checks();
        if (!checks.verifyCode(code, ClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.USER)) {
            return checks.response;
        }
        ClientSessionCode clientCode = checks.clientCode;
        ClientSessionModel clientSession = clientCode.getClientSession();
        if (!this.realm.isResetPasswordAllowed()) {
            this.event.client(clientCode.getClientSession().getClient());
            this.event.error("not_allowed");
            return ErrorPage.error(this.session, "resetCredentialNotAllowedMessage", new Object[0]);
        }
        return this.processResetCredentials(execution, clientSession, null);
    }

    protected Response processResetCredentials(String execution, ClientSessionModel clientSession, String errorMessage) {
        AuthenticationProcessor authProcessor = new AuthenticationProcessor(){

            @Override
            protected Response authenticationComplete() {
                boolean firstBrokerLoginInProgress;
                boolean bl = firstBrokerLoginInProgress = this.clientSession.getNote("BROKERED_CONTEXT") != null;
                if (firstBrokerLoginInProgress) {
                    UserModel linkingUser = AbstractIdpAuthenticator.getExistingUser(this.session, this.realm, this.clientSession);
                    if (!linkingUser.getId().equals(this.clientSession.getAuthenticatedUser().getId())) {
                        return ErrorPage.error(this.session, "identityProviderDifferentUserMessage", this.clientSession.getAuthenticatedUser().getUsername(), linkingUser.getUsername());
                    }
                    logger.debugf("Forget-password flow finished when authenticated user '%s' after first broker login.", (Object)linkingUser.getUsername());
                    return LoginActionsService.this.redirectToAfterFirstBrokerLoginEndpoint(this.clientSession);
                }
                return super.authenticationComplete();
            }
        };
        return this.processFlow(execution, clientSession, RESET_CREDENTIALS_PATH, this.realm.getResetCredentialsFlow(), errorMessage, authProcessor);
    }

    protected Response processRegistration(String execution, ClientSessionModel clientSession, String errorMessage) {
        return this.processFlow(execution, clientSession, REGISTRATION_PATH, this.realm.getRegistrationFlow(), errorMessage, new AuthenticationProcessor());
    }

    @Path(value="registration")
    @GET
    public Response registerPage(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution) {
        this.event.event(EventType.REGISTER);
        if (!this.realm.isRegistrationAllowed()) {
            this.event.error("registration_disabled");
            return ErrorPage.error(this.session, "registrationNotAllowedMessage", new Object[0]);
        }
        Checks checks = new Checks();
        if (!checks.verifyCode(code, ClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return checks.response;
        }
        this.event.detail("code_id", code);
        ClientSessionCode clientSessionCode = checks.clientCode;
        ClientSessionModel clientSession = clientSessionCode.getClientSession();
        AuthenticationManager.expireIdentityCookie(this.realm, this.uriInfo, this.clientConnection);
        return this.processRegistration(execution, clientSession, null);
    }

    @Path(value="registration")
    @POST
    public Response processRegister(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution) {
        this.event.event(EventType.REGISTER);
        if (!this.realm.isRegistrationAllowed()) {
            this.event.error("registration_disabled");
            return ErrorPage.error(this.session, "registrationNotAllowedMessage", new Object[0]);
        }
        Checks checks = new Checks();
        if (!checks.verifyCode(code, ClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return checks.response;
        }
        ClientSessionCode clientCode = checks.clientCode;
        ClientSessionModel clientSession = clientCode.getClientSession();
        return this.processRegistration(execution, clientSession, null);
    }

    @Path(value="first-broker-login")
    @GET
    public Response firstBrokerLoginGet(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution) {
        return this.firstBrokerLogin(code, execution);
    }

    @Path(value="first-broker-login")
    @POST
    public Response firstBrokerLoginPost(@QueryParam(value="code") String code, @QueryParam(value="execution") String execution) {
        return this.firstBrokerLogin(code, execution);
    }

    protected Response firstBrokerLogin(String code, String execution) {
        this.event.event(EventType.IDENTITY_PROVIDER_FIRST_LOGIN);
        Checks checks = new Checks();
        if (!checks.verifyCode(code, ClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return checks.response;
        }
        this.event.detail("code_id", code);
        ClientSessionCode clientSessionCode = checks.clientCode;
        ClientSessionModel clientSession = clientSessionCode.getClientSession();
        SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromClientSession(clientSession);
        if (serializedCtx == null) {
            throw new WebApplicationException(ErrorPage.error(this.session, "Not found serialized context in clientSession", new Object[0]));
        }
        BrokeredIdentityContext brokerContext = serializedCtx.deserialize(this.session, clientSession);
        AuthenticationFlowModel firstBrokerLoginFlow = this.realm.getAuthenticationFlowById(brokerContext.getIdpConfig().getFirstBrokerLoginFlowId());
        this.event.detail("identity_provider", brokerContext.getIdpConfig().getAlias()).detail("identity_provider_identity", brokerContext.getUsername());
        AuthenticationProcessor processor = new AuthenticationProcessor(){

            @Override
            protected Response authenticationComplete() {
                return LoginActionsService.this.redirectToAfterFirstBrokerLoginEndpoint(this.clientSession);
            }
        };
        return this.processFlow(execution, clientSession, FIRST_BROKER_LOGIN_PATH, firstBrokerLoginFlow, null, processor);
    }

    private Response redirectToAfterFirstBrokerLoginEndpoint(ClientSessionModel clientSession) {
        ClientSessionCode accessCode = new ClientSessionCode(this.realm, clientSession);
        clientSession.setTimestamp(Time.currentTime());
        URI redirect = Urls.identityProviderAfterFirstBrokerLogin(this.uriInfo.getBaseUri(), this.realm.getName(), accessCode.getCode());
        logger.debugf("Redirecting to '%s' ", (Object)redirect);
        return Response.status((int)302).location(redirect).build();
    }

    @Path(value="consent")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processConsent(MultivaluedMap<String, String> formData) {
        this.event.event(EventType.LOGIN);
        if (!this.checkSsl()) {
            return ErrorPage.error(this.session, "httpsRequiredMessage", new Object[0]);
        }
        String code = (String)formData.getFirst((Object)"code");
        ClientSessionCode accessCode = ClientSessionCode.parse(code, this.session, this.realm);
        if (accessCode == null || !accessCode.isValid(ClientSessionModel.Action.OAUTH_GRANT.name(), ClientSessionCode.ActionType.LOGIN)) {
            this.event.error("invalid_code");
            return ErrorPage.error(this.session, "invalidAccessCodeMessage", new Object[0]);
        }
        ClientSessionModel clientSession = accessCode.getClientSession();
        this.initEvent(clientSession);
        UserSessionModel userSession = clientSession.getUserSession();
        UserModel user = userSession.getUser();
        ClientModel client = clientSession.getClient();
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            AuthenticationManager.backchannelLogout(this.session, this.realm, userSession, this.uriInfo, this.clientConnection, this.headers, true);
            this.event.error("invalid_code");
            return ErrorPage.error(this.session, "sessionNotActiveMessage", new Object[0]);
        }
        if (formData.containsKey((Object)"cancel")) {
            LoginProtocol protocol = (LoginProtocol)this.session.getProvider(LoginProtocol.class, clientSession.getAuthMethod());
            protocol.setRealm(this.realm).setHttpHeaders(this.headers).setUriInfo(this.uriInfo).setEventBuilder(this.event);
            Response response = protocol.sendError(clientSession, LoginProtocol.Error.CONSENT_DENIED);
            this.event.error("rejected_by_user");
            return response;
        }
        UserConsentModel grantedConsent = user.getConsentByClient(client.getId());
        if (grantedConsent == null) {
            grantedConsent = new UserConsentModel(client);
            user.addConsent(grantedConsent);
        }
        for (RoleModel role : accessCode.getRequestedRoles()) {
            grantedConsent.addGrantedRole(role);
        }
        for (ProtocolMapperModel protocolMapper : accessCode.getRequestedProtocolMappers()) {
            if (!protocolMapper.isConsentRequired() || protocolMapper.getConsentText() == null) continue;
            grantedConsent.addGrantedProtocolMapper(protocolMapper);
        }
        user.updateConsent(grantedConsent);
        this.event.detail("consent", "consent_granted");
        this.event.success();
        return AuthenticationManager.redirectAfterSuccessfulFlow(this.session, this.realm, userSession, clientSession, this.request, this.uriInfo, this.clientConnection, this.event);
    }

    @Path(value="email-verification")
    @GET
    public Response emailVerification(@QueryParam(value="code") String code, @QueryParam(value="key") String key) {
        this.event.event(EventType.VERIFY_EMAIL);
        if (key != null) {
            Checks checks = new Checks();
            if (!checks.verifyCode(code, ClientSessionModel.Action.REQUIRED_ACTIONS.name(), ClientSessionCode.ActionType.USER)) {
                return checks.response;
            }
            ClientSessionCode accessCode = checks.clientCode;
            ClientSessionModel clientSession = accessCode.getClientSession();
            if (!ClientSessionModel.Action.VERIFY_EMAIL.name().equals(clientSession.getNote("CURRENT_REQUIRED_ACTION"))) {
                logger.error((Object)"required action doesn't match current required action");
                this.event.error("invalid_code");
                throw new WebApplicationException(ErrorPage.error(this.session, "invalidCodeMessage", new Object[0]));
            }
            UserSessionModel userSession = clientSession.getUserSession();
            UserModel user = userSession.getUser();
            this.initEvent(clientSession);
            this.event.event(EventType.VERIFY_EMAIL).detail("email", user.getEmail());
            String keyFromSession = clientSession.getNote("VERIFY_EMAIL_KEY");
            clientSession.removeNote("VERIFY_EMAIL_KEY");
            if (!key.equals(keyFromSession)) {
                logger.error((Object)"Invalid key for email verification");
                this.event.error("invalid_user_credentials");
                throw new WebApplicationException(ErrorPage.error(this.session, "invalidCodeMessage", new Object[0]));
            }
            user.setEmailVerified(true);
            user.removeRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
            this.event.success();
            String actionCookieValue = this.getActionCookie();
            if (actionCookieValue == null || !actionCookieValue.equals(userSession.getId())) {
                this.session.sessions().removeClientSession(this.realm, clientSession);
                return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setSuccess("emailVerifiedMessage", new Object[0]).createInfoPage();
            }
            this.event = this.event.clone().removeDetail("email").event(EventType.LOGIN);
            return AuthenticationProcessor.createRequiredActionRedirect(this.realm, clientSession, this.uriInfo);
        }
        Checks checks = new Checks();
        if (!checks.verifyCode(code, ClientSessionModel.Action.REQUIRED_ACTIONS.name(), ClientSessionCode.ActionType.USER)) {
            return checks.response;
        }
        ClientSessionCode accessCode = checks.clientCode;
        ClientSessionModel clientSession = accessCode.getClientSession();
        UserSessionModel userSession = clientSession.getUserSession();
        this.initEvent(clientSession);
        LoginActionsService.createActionCookie(this.realm, this.uriInfo, this.clientConnection, userSession.getId());
        VerifyEmail.setupKey(clientSession);
        return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setClientSessionCode(accessCode.getCode()).setClientSession(clientSession).setUser(userSession.getUser()).createResponse(UserModel.RequiredAction.VERIFY_EMAIL);
    }

    @Path(value="execute-actions")
    @GET
    public Response executeActions(@QueryParam(value="key") String key) {
        this.event.event(EventType.EXECUTE_ACTIONS);
        if (key != null) {
            Checks checks = new Checks();
            if (!checks.verifyCode(key, ClientSessionModel.Action.EXECUTE_ACTIONS.name(), ClientSessionCode.ActionType.USER)) {
                return checks.response;
            }
            ClientSessionModel clientSession = checks.clientCode.getClientSession();
            clientSession.getUserSession().getUser().setEmailVerified(true);
            clientSession.setNote("END_AFTER_REQUIRED_ACTIONS", "true");
            clientSession.setNote(ClientSessionModel.Action.EXECUTE_ACTIONS.name(), "true");
            return AuthenticationProcessor.createRequiredActionRedirect(this.realm, clientSession, this.uriInfo);
        }
        this.event.error("invalid_code");
        return ErrorPage.error(this.session, "invalidCodeMessage", new Object[0]);
    }

    private String getActionCookie() {
        return LoginActionsService.getActionCookie(this.headers, this.realm, this.uriInfo, this.clientConnection);
    }

    public static String getActionCookie(HttpHeaders headers, RealmModel realm, UriInfo uriInfo, ClientConnection clientConnection) {
        Cookie cookie = (Cookie)headers.getCookies().get(ACTION_COOKIE);
        AuthenticationManager.expireCookie(realm, ACTION_COOKIE, AuthenticationManager.getRealmCookiePath(realm, uriInfo), realm.getSslRequired().isRequired(clientConnection), clientConnection);
        return cookie != null ? cookie.getValue() : null;
    }

    public static void createActionCookie(RealmModel realm, UriInfo uriInfo, ClientConnection clientConnection, String sessionId) {
        CookieHelper.addCookie(ACTION_COOKIE, sessionId, AuthenticationManager.getRealmCookiePath(realm, uriInfo), null, null, -1, realm.getSslRequired().isRequired(clientConnection), true);
    }

    private void initEvent(ClientSessionModel clientSession) {
        UserSessionModel userSession = clientSession.getUserSession();
        String responseType = clientSession.getNote("response_type");
        if (responseType == null) {
            responseType = "code";
        }
        String respMode = clientSession.getNote("response_mode");
        OIDCResponseMode responseMode = OIDCResponseMode.parse(respMode, OIDCResponseType.parse(responseType));
        this.event.event(EventType.LOGIN).client(clientSession.getClient()).user(userSession.getUser()).session(userSession.getId()).detail("code_id", clientSession.getId()).detail("redirect_uri", clientSession.getRedirectUri()).detail("username", clientSession.getNote("ATTEMPTED_USERNAME")).detail("auth_method", userSession.getAuthMethod()).detail("username", userSession.getLoginUsername()).detail("response_type", responseType).detail("response_mode", responseMode.toString().toLowerCase());
        if (userSession.isRememberMe()) {
            this.event.detail("remember_me", "true");
        }
    }

    @Path(value="required-action")
    @POST
    public Response requiredActionPOST(@QueryParam(value="code") String code, @QueryParam(value="action") String action) {
        return this.processRequireAction(code, action);
    }

    @Path(value="required-action")
    @GET
    public Response requiredActionGET(@QueryParam(value="code") String code, @QueryParam(value="action") String action) {
        return this.processRequireAction(code, action);
    }

    public Response processRequireAction(String code, String action) {
        this.event.event(EventType.CUSTOM_REQUIRED_ACTION);
        this.event.detail("custom_required_action", action);
        Checks checks = new Checks();
        if (!checks.verifyCode(code, ClientSessionModel.Action.REQUIRED_ACTIONS.name(), ClientSessionCode.ActionType.USER)) {
            return checks.response;
        }
        ClientSessionCode clientCode = checks.clientCode;
        ClientSessionModel clientSession = clientCode.getClientSession();
        if (clientSession.getUserSession() == null) {
            logger.error((Object)"user session was null");
            this.event.error("user_session_not_found");
            throw new WebApplicationException(ErrorPage.error(this.session, "sessionNotActiveMessage", new Object[0]));
        }
        if (action == null && clientSession.getUserSession() != null) {
            this.initEvent(clientSession);
            this.event.event(EventType.LOGIN);
            return AuthenticationManager.nextActionAfterAuthentication(this.session, clientSession.getUserSession(), clientSession, this.clientConnection, this.request, this.uriInfo, this.event);
        }
        if (!action.equals(clientSession.getNote("CURRENT_REQUIRED_ACTION"))) {
            logger.error((Object)"required action doesn't match current required action");
            this.event.error("invalid_code");
            throw new WebApplicationException(ErrorPage.error(this.session, "invalidCodeMessage", new Object[0]));
        }
        RequiredActionFactory factory = (RequiredActionFactory)this.session.getKeycloakSessionFactory().getProviderFactory(RequiredActionProvider.class, action);
        if (factory == null) {
            logger.error((Object)"required action provider was null");
            this.event.error("invalid_code");
            throw new WebApplicationException(ErrorPage.error(this.session, "invalidCodeMessage", new Object[0]));
        }
        RequiredActionProvider provider = (RequiredActionProvider)factory.create(this.session);
        this.initEvent(clientSession);
        this.event.event(EventType.CUSTOM_REQUIRED_ACTION);
        RequiredActionContextResult context = new RequiredActionContextResult(clientSession.getUserSession(), clientSession, this.realm, this.event, this.session, this.request, clientSession.getUserSession().getUser(), factory){

            @Override
            public void ignore() {
                throw new RuntimeException("Cannot call ignore within processAction()");
            }
        };
        provider.processAction(context);
        if (context.getStatus() == RequiredActionContext.Status.SUCCESS) {
            this.event.success();
            clientSession.removeRequiredAction(factory.getId());
            clientSession.getUserSession().getUser().removeRequiredAction(factory.getId());
            URI redirect = LoginActionsService.loginActionsBaseUrl(this.uriInfo).path(REQUIRED_ACTION).queryParam("code", new Object[]{code}).build(new Object[]{this.realm.getName()});
            return Response.status((int)302).location(redirect).build();
        }
        if (context.getStatus() == RequiredActionContext.Status.CHALLENGE) {
            return context.getChallenge();
        }
        if (context.getStatus() == RequiredActionContext.Status.FAILURE) {
            LoginProtocol protocol = (LoginProtocol)context.getSession().getProvider(LoginProtocol.class, context.getClientSession().getAuthMethod());
            protocol.setRealm(context.getRealm()).setHttpHeaders(context.getHttpRequest().getHttpHeaders()).setUriInfo(context.getUriInfo()).setEventBuilder(this.event);
            this.event.detail("custom_required_action", action);
            Response response = protocol.sendError(context.getClientSession(), LoginProtocol.Error.CONSENT_DENIED);
            this.event.error("rejected_by_user");
            return response;
        }
        throw new RuntimeException("Unreachable");
    }

    private class Checks {
        ClientSessionCode clientCode;
        Response response;

        private Checks() {
        }

        boolean verifyCode(String code, String requiredAction, ClientSessionCode.ActionType actionType) {
            if (!this.verifyCode(code)) {
                return false;
            }
            return this.verifyAction(requiredAction, actionType);
        }

        public boolean verifyAction(String requiredAction, ClientSessionCode.ActionType actionType) {
            if (!this.clientCode.isValidAction(requiredAction)) {
                LoginActionsService.this.event.client(this.clientCode.getClientSession().getClient());
                LoginActionsService.this.event.error("invalid_code");
                this.response = ErrorPage.error(LoginActionsService.this.session, "invalidCodeMessage", new Object[0]);
                return false;
            }
            if (!this.clientCode.isActionActive(actionType)) {
                LoginActionsService.this.event.client(this.clientCode.getClientSession().getClient());
                LoginActionsService.this.event.clone().error("expired_code");
                if (this.clientCode.getClientSession().getAction().equals(ClientSessionModel.Action.AUTHENTICATE.name())) {
                    AuthenticationProcessor.resetFlow(this.clientCode.getClientSession());
                    this.response = LoginActionsService.this.processAuthentication(null, this.clientCode.getClientSession(), "loginTimeout");
                    return false;
                }
                this.response = ErrorPage.error(LoginActionsService.this.session, "expiredCodeMessage", new Object[0]);
                return false;
            }
            return true;
        }

        public boolean verifyCode(String code) {
            if (!LoginActionsService.this.checkSsl()) {
                LoginActionsService.this.event.error("ssl_required");
                this.response = ErrorPage.error(LoginActionsService.this.session, "httpsRequiredMessage", new Object[0]);
                return false;
            }
            if (!LoginActionsService.this.realm.isEnabled()) {
                LoginActionsService.this.event.error("realm_disabled");
                this.response = ErrorPage.error(LoginActionsService.this.session, "realmNotEnabledMessage", new Object[0]);
                return false;
            }
            ClientSessionCode.ParseResult result = ClientSessionCode.parseResult(code, LoginActionsService.this.session, LoginActionsService.this.realm);
            this.clientCode = result.getCode();
            if (this.clientCode == null) {
                if (result.isClientSessionNotFound()) {
                    try {
                        ClientSessionModel clientSession = RestartLoginCookie.restartSession(LoginActionsService.this.session, LoginActionsService.this.realm, code);
                        if (clientSession != null) {
                            LoginActionsService.this.event.clone().detail("restart_after_timeout", "true").error("expired_code");
                            this.response = LoginActionsService.this.processFlow(null, clientSession, LoginActionsService.AUTHENTICATE_PATH, LoginActionsService.this.realm.getBrowserFlow(), "loginTimeout", new AuthenticationProcessor());
                            return false;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"failed to parse RestartLoginCookie", (Throwable)e);
                    }
                }
                LoginActionsService.this.event.error("invalid_code");
                this.response = ErrorPage.error(LoginActionsService.this.session, "invalidCodeMessage", new Object[0]);
                return false;
            }
            ClientSessionModel clientSession = this.clientCode.getClientSession();
            if (clientSession == null) {
                LoginActionsService.this.event.error("invalid_code");
                this.response = ErrorPage.error(LoginActionsService.this.session, "invalidCodeMessage", new Object[0]);
                return false;
            }
            LoginActionsService.this.event.detail("code_id", clientSession.getId());
            ClientModel client = clientSession.getClient();
            if (client == null) {
                LoginActionsService.this.event.error("client_not_found");
                this.response = ErrorPage.error(LoginActionsService.this.session, "unknownLoginRequesterMessage", new Object[0]);
                LoginActionsService.this.session.sessions().removeClientSession(LoginActionsService.this.realm, clientSession);
                return false;
            }
            if (!client.isEnabled()) {
                LoginActionsService.this.event.error("client_not_found");
                this.response = ErrorPage.error(LoginActionsService.this.session, "loginRequesterNotEnabledMessage", new Object[0]);
                LoginActionsService.this.session.sessions().removeClientSession(LoginActionsService.this.realm, clientSession);
                return false;
            }
            LoginActionsService.this.session.getContext().setClient(client);
            return true;
        }
    }
}

