/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.IdentityProviderModel;

public class BrokeredIdentityContext {
    private String id;
    private String username;
    private String modelUsername;
    private String email;
    private String firstName;
    private String lastName;
    private String brokerSessionId;
    private String brokerUserId;
    private String code;
    private String token;
    private IdentityProviderModel idpConfig;
    private IdentityProvider idp;
    private Map<String, Object> contextData = new HashMap<String, Object>();
    private ClientSessionModel clientSession;

    public BrokeredIdentityContext(String id) {
        if (id == null) {
            throw new RuntimeException("No identifier provider for identity.");
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getModelUsername() {
        return this.modelUsername;
    }

    public void setModelUsername(String modelUsername) {
        this.modelUsername = modelUsername;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getBrokerSessionId() {
        return this.brokerSessionId;
    }

    public void setBrokerSessionId(String brokerSessionId) {
        this.brokerSessionId = brokerSessionId;
    }

    public String getBrokerUserId() {
        return this.brokerUserId;
    }

    public void setBrokerUserId(String brokerUserId) {
        this.brokerUserId = brokerUserId;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public IdentityProviderModel getIdpConfig() {
        return this.idpConfig;
    }

    public void setIdpConfig(IdentityProviderModel idpConfig) {
        this.idpConfig = idpConfig;
    }

    public IdentityProvider getIdp() {
        return this.idp;
    }

    public void setIdp(IdentityProvider idp) {
        this.idp = idp;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public void setContextData(Map<String, Object> contextData) {
        this.contextData = contextData;
    }

    public void setUserAttribute(String attributeName, String attributeValue) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(attributeValue);
        this.getContextData().put("user.attributes." + attributeName, list);
    }

    public String getUserAttribute(String attributeName) {
        List userAttribute = (List)this.getContextData().get("user.attributes." + attributeName);
        if (userAttribute == null || userAttribute.isEmpty()) {
            return null;
        }
        return (String)userAttribute.get(0);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public ClientSessionModel getClientSession() {
        return this.clientSession;
    }

    public void setClientSession(ClientSessionModel clientSession) {
        this.clientSession = clientSession;
    }

    public void setName(String name) {
        if (name != null) {
            int i = name.lastIndexOf(32);
            if (i != -1) {
                this.firstName = name.substring(0, i);
                this.lastName = name.substring(i + 1);
            } else {
                this.firstName = name;
            }
        }
    }

    public String toString() {
        return "{id='" + this.id + '\'' + ", username='" + this.username + '\'' + ", email='" + this.email + '\'' + '}';
    }
}

