/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.authenticators.broker.AbstractIdpAuthenticator;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.validation.Validation;
import org.keycloak.social.SocialIdentityProvider;
import org.keycloak.util.JsonSerialization;

public class IdentityBrokerService
implements IdentityProvider.AuthenticationCallback {
    private static final Logger LOGGER = Logger.getLogger(IdentityBrokerService.class);
    public static final String BROKER_PROVIDER_ID = "BROKER_PROVIDER_ID";
    private final RealmModel realmModel;
    @Context
    private UriInfo uriInfo;
    @Context
    private KeycloakSession session;
    @Context
    private ClientConnection clientConnection;
    @Context
    private HttpRequest request;
    @Context
    private HttpHeaders headers;
    private EventBuilder event;
    private BruteForceProtector protector;

    public IdentityBrokerService(RealmModel realmModel, BruteForceProtector protector) {
        if (realmModel == null) {
            throw new IllegalArgumentException("Realm can not be null.");
        }
        this.protector = protector;
        this.realmModel = realmModel;
    }

    public void init() {
        this.event = new EventBuilder(this.realmModel, this.session, this.clientConnection).event(EventType.IDENTITY_PROVIDER_LOGIN);
    }

    @POST
    @Path(value="/{provider_id}/login")
    public Response performPostLogin(@PathParam(value="provider_id") String providerId, @QueryParam(value="code") String code) {
        return this.performLogin(providerId, code);
    }

    @GET
    @Path(value="/{provider_id}/login")
    public Response performLogin(@PathParam(value="provider_id") String providerId, @QueryParam(value="code") String code) {
        this.event.detail("identity_provider", providerId);
        if (this.isDebugEnabled()) {
            LOGGER.debugf("Sending authentication request to identity provider [%s].", (Object)providerId);
        }
        try {
            ClientSessionCode clientSessionCode = this.parseClientSessionCode(code);
            IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
            Response response = identityProvider.performLogin(this.createAuthenticationRequest(providerId, clientSessionCode));
            if (response != null) {
                if (this.isDebugEnabled()) {
                    LOGGER.debugf("Identity provider [%s] is going to send a request [%s].", (Object)identityProvider, (Object)response);
                }
                return response;
            }
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage("couldNotSendAuthenticationRequestMessage", e, providerId);
        }
        catch (Exception e) {
            return this.redirectToErrorPage("unexpectedErrorHandlingRequestMessage", e, providerId);
        }
        return this.redirectToErrorPage("couldNotProceedWithAuthenticationRequestMessage", new Object[0]);
    }

    @Path(value="{provider_id}/endpoint")
    public Object getEndpoint(@PathParam(value="provider_id") String providerId) {
        IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
        Object callback = identityProvider.callback(this.realmModel, (IdentityProvider.AuthenticationCallback)this, this.event);
        ResteasyProviderFactory.getInstance().injectProperties(callback);
        return callback;
    }

    @Path(value="{provider_id}/token")
    @OPTIONS
    public Response retrieveTokenPreflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @GET
    @Path(value="{provider_id}/token")
    public Response retrieveToken(@PathParam(value="provider_id") String providerId) {
        return this.getToken(providerId, false);
    }

    private Response getToken(String providerId, boolean forceRetrieval) {
        this.event.event(EventType.IDENTITY_PROVIDER_RETRIEVE_TOKEN);
        try {
            AppAuthManager authManager = new AppAuthManager();
            AuthenticationManager.AuthResult authResult = authManager.authenticateBearerToken(this.session, this.realmModel, this.uriInfo, this.clientConnection, this.request.getHttpHeaders());
            if (authResult != null) {
                AccessToken.Access brokerRoles;
                AccessToken token = authResult.getToken();
                String[] audience = token.getAudience();
                ClientModel clientModel = this.realmModel.getClientByClientId(audience[0]);
                if (clientModel == null) {
                    return this.badRequest("Invalid client.");
                }
                this.session.getContext().setClient(clientModel);
                ClientModel brokerClient = this.realmModel.getClientByClientId("broker");
                if (brokerClient == null) {
                    return this.corsResponse(this.forbidden("Realm has not migrated to support the broker token exchange service"), clientModel);
                }
                Map resourceAccess = token.getResourceAccess();
                AccessToken.Access access = brokerRoles = resourceAccess == null ? null : (AccessToken.Access)resourceAccess.get("broker");
                if (brokerRoles == null || !brokerRoles.isUserInRole("read-token")) {
                    return this.corsResponse(this.forbidden("Client [" + clientModel.getClientId() + "] not authorized to retrieve tokens from identity provider [" + providerId + "]."), clientModel);
                }
                IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(this.session, this.realmModel, providerId);
                IdentityProviderModel identityProviderConfig = this.getIdentityProviderConfig(providerId);
                if (identityProviderConfig.isStoreToken()) {
                    FederatedIdentityModel identity = this.session.users().getFederatedIdentity(authResult.getUser(), providerId, this.realmModel);
                    if (identity == null) {
                        return this.corsResponse(this.badRequest("User [" + authResult.getUser().getId() + "] is not associated with identity provider [" + providerId + "]."), clientModel);
                    }
                    this.event.success();
                    return this.corsResponse(identityProvider.retrieveToken(identity), clientModel);
                }
                return this.corsResponse(this.badRequest("Identity Provider [" + providerId + "] does not support this operation."), clientModel);
            }
            return this.badRequest("Invalid token.");
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage("couldNotObtainTokenMessage", e, providerId);
        }
        catch (Exception e) {
            return this.redirectToErrorPage("unexpectedErrorRetrievingTokenMessage", e, providerId);
        }
    }

    public Response authenticated(BrokeredIdentityContext context) {
        ClientSessionCode clientCode = null;
        IdentityProviderModel identityProviderConfig = context.getIdpConfig();
        try {
            clientCode = this.parseClientSessionCode(context.getCode());
        }
        catch (Exception e) {
            return this.redirectToErrorPage("identityProviderAuthenticationFailedMessage", e, identityProviderConfig.getProviderId());
        }
        String providerId = identityProviderConfig.getAlias();
        if (!identityProviderConfig.isStoreToken()) {
            if (this.isDebugEnabled()) {
                LOGGER.debugf("Token will not be stored for identity provider [%s].", (Object)providerId);
            }
            context.setToken(null);
        }
        ClientSessionModel clientSession = clientCode.getClientSession();
        context.setClientSession(clientSession);
        this.session.getContext().setClient(clientSession.getClient());
        context.getIdp().preprocessFederatedIdentity(this.session, this.realmModel, context);
        Set mappers = this.realmModel.getIdentityProviderMappersByAlias(context.getIdpConfig().getAlias());
        if (mappers != null) {
            KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
            for (IdentityProviderMapperModel mapper : mappers) {
                IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                target.preprocessFederatedIdentity(this.session, this.realmModel, mapper, context);
            }
        }
        FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(providerId, context.getId(), context.getUsername(), context.getToken());
        this.event.event(EventType.IDENTITY_PROVIDER_LOGIN).detail("redirect_uri", clientSession.getRedirectUri()).detail("identity_provider_identity", context.getUsername());
        UserModel federatedUser = this.session.users().getUserByFederatedIdentity(federatedIdentityModel, this.realmModel);
        if (clientSession.getUserSession() != null) {
            return this.performAccountLinking(clientSession, context, federatedIdentityModel, federatedUser);
        }
        if (federatedUser == null) {
            LOGGER.debugf("Federated user not found for provider '%s' and broker username '%s' . Redirecting to flow for firstBrokerLogin", (Object)providerId, (Object)context.getUsername());
            String username = context.getModelUsername();
            if (username == null) {
                username = this.realmModel.isRegistrationEmailAsUsername() && !Validation.isBlank(context.getEmail()) ? context.getEmail() : (context.getUsername() == null ? context.getIdpConfig().getAlias() + "." + context.getId() : context.getIdpConfig().getAlias() + "." + context.getUsername());
            }
            username = username.trim();
            context.setModelUsername(username);
            clientSession.setTimestamp(Time.currentTime());
            SerializedBrokeredIdentityContext ctx = SerializedBrokeredIdentityContext.serialize(context);
            ctx.saveToClientSession(clientSession, "BROKERED_CONTEXT");
            URI redirect = LoginActionsService.firstBrokerLoginProcessor(this.uriInfo).queryParam("code", new Object[]{context.getCode()}).build(new Object[]{this.realmModel.getName()});
            return Response.status((int)302).location(redirect).build();
        }
        this.updateFederatedIdentity(context, federatedUser);
        clientSession.setAuthenticatedUser(federatedUser);
        return this.finishOrRedirectToPostBrokerLogin(clientSession, context, false);
    }

    @GET
    @Path(value="/after-first-broker-login")
    public Response afterFirstBrokerLogin(@QueryParam(value="code") String code) {
        ClientSessionCode clientCode = this.parseClientSessionCode(code);
        ClientSessionModel clientSession = clientCode.getClientSession();
        try {
            this.event.detail("code_id", clientSession.getId()).removeDetail("auth_method");
            SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromClientSession(clientSession, "BROKERED_CONTEXT");
            if (serializedCtx == null) {
                throw new IdentityBrokerException("Not found serialized context in clientSession");
            }
            BrokeredIdentityContext context = serializedCtx.deserialize(this.session, clientSession);
            String providerId = context.getIdpConfig().getAlias();
            this.event.detail("identity_provider", providerId);
            this.event.detail("identity_provider_identity", context.getUsername());
            clientSession.removeNote("BROKERED_CONTEXT");
            UserModel federatedUser = clientSession.getAuthenticatedUser();
            if (federatedUser == null) {
                throw new IdentityBrokerException("Couldn't found authenticated federatedUser in clientSession");
            }
            this.event.user(federatedUser);
            this.event.detail("username", federatedUser.getUsername());
            if (context.getIdpConfig().isAddReadTokenRoleOnCreate()) {
                ClientModel brokerClient = this.realmModel.getClientByClientId("broker");
                if (brokerClient == null) {
                    throw new IdentityBrokerException("Client 'broker' not available. Maybe realm has not migrated to support the broker token exchange service");
                }
                RoleModel readTokenRole = brokerClient.getRole("read-token");
                federatedUser.grantRole(readTokenRole);
            }
            FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(context.getIdpConfig().getAlias(), context.getId(), context.getUsername(), context.getToken());
            this.session.users().addFederatedIdentity(this.realmModel, federatedUser, federatedIdentityModel);
            String isRegisteredNewUser = clientSession.getNote("BROKER_REGISTERED_NEW_USER");
            if (Boolean.parseBoolean(isRegisteredNewUser)) {
                LOGGER.debugf("Registered new user '%s' after first login with identity provider '%s'. Identity provider username is '%s' . ", (Object)federatedUser.getUsername(), (Object)providerId, (Object)context.getUsername());
                context.getIdp().importNewUser(this.session, this.realmModel, federatedUser, context);
                Set mappers = this.realmModel.getIdentityProviderMappersByAlias(providerId);
                if (mappers != null) {
                    KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
                    for (IdentityProviderMapperModel mapper : mappers) {
                        IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                        target.importNewUser(this.session, this.realmModel, federatedUser, mapper, context);
                    }
                }
                if (context.getIdpConfig().isTrustEmail() && !Validation.isBlank(federatedUser.getEmail()) && !Boolean.parseBoolean(clientSession.getNote("UPDATE_PROFILE_EMAIL_CHANGED"))) {
                    LOGGER.debugf("Email verified automatically after registration of user '%s' through Identity provider '%s' ", (Object)federatedUser.getUsername(), (Object)context.getIdpConfig().getAlias());
                    federatedUser.setEmailVerified(true);
                }
                this.event.event(EventType.REGISTER).detail("register_method", "broker").detail("email", federatedUser.getEmail()).success();
            } else {
                LOGGER.debugf("Linked existing keycloak user '%s' with identity provider '%s' . Identity provider username is '%s' .", (Object)federatedUser.getUsername(), (Object)providerId, (Object)context.getUsername());
                this.event.event(EventType.FEDERATED_IDENTITY_LINK).success();
                this.updateFederatedIdentity(context, federatedUser);
            }
            return this.finishOrRedirectToPostBrokerLogin(clientSession, context, true);
        }
        catch (Exception e) {
            return this.redirectToErrorPage("identityProviderUnexpectedErrorMessage", e, new Object[0]);
        }
    }

    private Response finishOrRedirectToPostBrokerLogin(ClientSessionModel clientSession, BrokeredIdentityContext context, boolean wasFirstBrokerLogin) {
        String postBrokerLoginFlowId = context.getIdpConfig().getPostBrokerLoginFlowId();
        if (postBrokerLoginFlowId == null) {
            LOGGER.debugf("Skip redirect to postBrokerLogin flow. PostBrokerLogin flow not set for identityProvider '%s'.", (Object)context.getIdpConfig().getAlias());
            return this.afterPostBrokerLoginFlowSuccess(clientSession, context, wasFirstBrokerLogin);
        }
        LOGGER.debugf("Redirect to postBrokerLogin flow after authentication with identityProvider '%s'.", (Object)context.getIdpConfig().getAlias());
        clientSession.setTimestamp(Time.currentTime());
        SerializedBrokeredIdentityContext ctx = SerializedBrokeredIdentityContext.serialize(context);
        ctx.saveToClientSession(clientSession, "PBL_BROKERED_IDENTITY_CONTEXT");
        clientSession.setNote("PBL_AFTER_FIRST_BROKER_LOGIN", String.valueOf(wasFirstBrokerLogin));
        URI redirect = LoginActionsService.postBrokerLoginProcessor(this.uriInfo).queryParam("code", new Object[]{context.getCode()}).build(new Object[]{this.realmModel.getName()});
        return Response.status((int)302).location(redirect).build();
    }

    @GET
    @Path(value="/after-post-broker-login")
    public Response afterPostBrokerLoginFlow(@QueryParam(value="code") String code) {
        ClientSessionCode clientCode = this.parseClientSessionCode(code);
        ClientSessionModel clientSession = clientCode.getClientSession();
        try {
            SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromClientSession(clientSession, "PBL_BROKERED_IDENTITY_CONTEXT");
            if (serializedCtx == null) {
                throw new IdentityBrokerException("Not found serialized context in clientSession. Note PBL_BROKERED_IDENTITY_CONTEXT was null");
            }
            BrokeredIdentityContext context = serializedCtx.deserialize(this.session, clientSession);
            String wasFirstBrokerLoginNote = clientSession.getNote("PBL_AFTER_FIRST_BROKER_LOGIN");
            boolean wasFirstBrokerLogin = Boolean.parseBoolean(wasFirstBrokerLoginNote);
            String authStateNoteKey = "PBL_AUTH_STATE." + context.getIdpConfig().getAlias();
            String authState = clientSession.getNote(authStateNoteKey);
            if (!Boolean.parseBoolean(authState)) {
                throw new IdentityBrokerException("Invalid request. Not found the flag that post-broker-login flow was finished");
            }
            clientSession.removeNote("PBL_BROKERED_IDENTITY_CONTEXT");
            clientSession.removeNote("PBL_AFTER_FIRST_BROKER_LOGIN");
            return this.afterPostBrokerLoginFlowSuccess(clientSession, context, wasFirstBrokerLogin);
        }
        catch (IdentityBrokerException e) {
            return this.redirectToErrorPage("identityProviderUnexpectedErrorMessage", e, new Object[0]);
        }
    }

    private Response afterPostBrokerLoginFlowSuccess(ClientSessionModel clientSession, BrokeredIdentityContext context, boolean wasFirstBrokerLogin) {
        boolean firstBrokerLoginInProgress;
        String providerId = context.getIdpConfig().getAlias();
        UserModel federatedUser = clientSession.getAuthenticatedUser();
        if (wasFirstBrokerLogin) {
            String isDifferentBrowser = clientSession.getNote("IS_DIFFERENT_BROWSER");
            if (Boolean.parseBoolean(isDifferentBrowser)) {
                this.session.sessions().removeClientSession(this.realmModel, clientSession);
                return ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setSuccess("identityProviderLinkSuccess", new Object[]{context.getIdpConfig().getAlias(), context.getUsername()}).createInfoPage();
            }
            return this.finishBrokerAuthentication(context, federatedUser, clientSession, providerId);
        }
        boolean bl = firstBrokerLoginInProgress = clientSession.getNote("BROKERED_CONTEXT") != null;
        if (firstBrokerLoginInProgress) {
            LOGGER.debugf("Reauthenticated with broker '%s' when linking user '%s' with other broker", (Object)context.getIdpConfig().getAlias(), (Object)federatedUser.getUsername());
            UserModel linkingUser = AbstractIdpAuthenticator.getExistingUser(this.session, this.realmModel, clientSession);
            if (!linkingUser.getId().equals(federatedUser.getId())) {
                return this.redirectToErrorPage("identityProviderDifferentUserMessage", federatedUser.getUsername(), linkingUser.getUsername());
            }
            return this.afterFirstBrokerLogin(context.getCode());
        }
        return this.finishBrokerAuthentication(context, federatedUser, clientSession, providerId);
    }

    private Response finishBrokerAuthentication(BrokeredIdentityContext context, UserModel federatedUser, ClientSessionModel clientSession, String providerId) {
        UserSessionModel userSession = this.session.sessions().createUserSession(this.realmModel, federatedUser, federatedUser.getUsername(), this.clientConnection.getRemoteAddr(), "broker", false, context.getBrokerSessionId(), context.getBrokerUserId());
        this.event.user(federatedUser);
        this.event.session(userSession);
        TokenManager.attachClientSession(userSession, clientSession);
        context.getIdp().attachUserSession(userSession, clientSession, context);
        userSession.setNote(BROKER_PROVIDER_ID, providerId);
        if (this.isDebugEnabled()) {
            LOGGER.debugf("Performing local authentication for user [%s].", (Object)federatedUser);
        }
        return AuthenticationProcessor.createRequiredActionRedirect(this.realmModel, clientSession, this.uriInfo);
    }

    public Response cancelled(String code) {
        ClientSessionCode clientCode = ClientSessionCode.parse(code, this.session, this.realmModel);
        if (clientCode.getClientSession() == null || !clientCode.isValid(ClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return this.redirectToErrorPage("invalidCodeMessage", new Object[0]);
        }
        return this.browserAuthentication(clientCode.getClientSession(), null);
    }

    public Response error(String code, String message) {
        ClientSessionCode clientCode = ClientSessionCode.parse(code, this.session, this.realmModel);
        if (clientCode.getClientSession() == null || !clientCode.isValid(ClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            return this.redirectToErrorPage("invalidCodeMessage", new Object[0]);
        }
        return this.browserAuthentication(clientCode.getClientSession(), message);
    }

    private Response performAccountLinking(ClientSessionModel clientSession, BrokeredIdentityContext context, FederatedIdentityModel federatedIdentityModel, UserModel federatedUser) {
        this.event.event(EventType.FEDERATED_IDENTITY_LINK);
        if (federatedUser != null) {
            return this.redirectToAccountErrorPage(clientSession, "identityProviderAlreadyLinkedMessage", context.getIdpConfig().getAlias());
        }
        UserModel authenticatedUser = clientSession.getUserSession().getUser();
        if (this.isDebugEnabled()) {
            LOGGER.debugf("Linking account [%s] from identity provider [%s] to user [%s].", (Object)federatedIdentityModel, (Object)context.getIdpConfig().getAlias(), (Object)authenticatedUser);
        }
        if (!authenticatedUser.isEnabled()) {
            return this.redirectToAccountErrorPage(clientSession, "accountDisabledMessage", new Object[0]);
        }
        if (!authenticatedUser.hasRole(this.realmModel.getClientByClientId("account").getRole("manage-account"))) {
            return this.redirectToErrorPage("insufficientPermissionMessage", new Object[0]);
        }
        this.session.users().addFederatedIdentity(this.realmModel, authenticatedUser, federatedIdentityModel);
        context.getIdp().attachUserSession(clientSession.getUserSession(), clientSession, context);
        this.event.user(authenticatedUser).detail("username", authenticatedUser.getUsername()).detail("identity_provider", federatedIdentityModel.getIdentityProvider()).detail("identity_provider_identity", federatedIdentityModel.getUserName()).success();
        return Response.status((int)302).location(UriBuilder.fromUri((String)clientSession.getRedirectUri()).build(new Object[0])).build();
    }

    private void updateFederatedIdentity(BrokeredIdentityContext context, UserModel federatedUser) {
        FederatedIdentityModel federatedIdentityModel = this.session.users().getFederatedIdentity(federatedUser, context.getIdpConfig().getAlias(), this.realmModel);
        if (context.getIdpConfig().isStoreToken() && !ObjectUtil.isEqualOrBothNull((Object)context.getToken(), (Object)federatedIdentityModel.getToken())) {
            federatedIdentityModel.setToken(context.getToken());
            this.session.users().updateFederatedIdentity(this.realmModel, federatedUser, federatedIdentityModel);
            if (this.isDebugEnabled()) {
                LOGGER.debugf("Identity [%s] update with response from identity provider [%s].", (Object)federatedUser, (Object)context.getIdpConfig().getAlias());
            }
        }
        context.getIdp().updateBrokeredUser(this.session, this.realmModel, federatedUser, context);
        Set mappers = this.realmModel.getIdentityProviderMappersByAlias(context.getIdpConfig().getAlias());
        if (mappers != null) {
            KeycloakSessionFactory sessionFactory = this.session.getKeycloakSessionFactory();
            for (IdentityProviderMapperModel mapper : mappers) {
                IdentityProviderMapper target = (IdentityProviderMapper)sessionFactory.getProviderFactory(IdentityProviderMapper.class, mapper.getIdentityProviderMapper());
                target.updateBrokeredUser(this.session, this.realmModel, federatedUser, mapper, context);
            }
        }
    }

    private ClientSessionCode parseClientSessionCode(String code) {
        ClientSessionCode clientCode = ClientSessionCode.parse(code, this.session, this.realmModel);
        if (clientCode != null && clientCode.isValid(ClientSessionModel.Action.AUTHENTICATE.name(), ClientSessionCode.ActionType.LOGIN)) {
            ClientSessionModel clientSession = clientCode.getClientSession();
            if (clientSession != null) {
                ClientModel client = clientSession.getClient();
                if (client == null) {
                    throw new IdentityBrokerException("Invalid client");
                }
                LOGGER.debugf("Got authorization code from client [%s].", (Object)client.getClientId());
                this.event.client(client);
                this.session.getContext().setClient(client);
                if (clientSession.getUserSession() != null) {
                    this.event.session(clientSession.getUserSession());
                }
            }
            if (this.isDebugEnabled()) {
                LOGGER.debugf("Authorization code is valid.", new Object[0]);
            }
            return clientCode;
        }
        throw new IdentityBrokerException("Invalid code, please login again through your client.");
    }

    private AuthenticationRequest createAuthenticationRequest(String providerId, ClientSessionCode clientSessionCode) {
        ClientSessionModel clientSession = null;
        String relayState = null;
        if (clientSessionCode != null) {
            clientSession = clientSessionCode.getClientSession();
            relayState = clientSessionCode.getCode();
        }
        return new AuthenticationRequest(this.session, this.realmModel, clientSession, this.request, this.uriInfo, relayState, this.getRedirectUri(providerId));
    }

    private String getRedirectUri(String providerId) {
        return Urls.identityProviderAuthnResponse(this.uriInfo.getBaseUri(), providerId, this.realmModel.getName()).toString();
    }

    private Response redirectToErrorPage(String message, Object ... parameters) {
        return this.redirectToErrorPage(message, null, parameters);
    }

    private Response redirectToErrorPage(String message, Throwable throwable, Object ... parameters) {
        if (message == null) {
            message = "identityProviderUnexpectedErrorMessage";
        }
        this.fireErrorEvent(message, throwable);
        return ErrorPage.error(this.session, message, parameters);
    }

    private Response redirectToAccountErrorPage(ClientSessionModel clientSession, String message, Object ... parameters) {
        this.fireErrorEvent(message);
        FormMessage errorMessage = new FormMessage(message, parameters);
        try {
            String serializedError = JsonSerialization.writeValueAsString((Object)errorMessage);
            clientSession.setNote("ACCOUNT_MGMT_FORWARDED_ERROR", serializedError);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return Response.status((int)302).location(UriBuilder.fromUri((String)clientSession.getRedirectUri()).build(new Object[0])).build();
    }

    private Response redirectToLoginPage(Throwable t, ClientSessionCode clientCode) {
        String message = t.getMessage();
        if (message == null) {
            message = "identityProviderUnexpectedErrorMessage";
        }
        this.fireErrorEvent(message);
        return this.browserAuthentication(clientCode.getClientSession(), message);
    }

    protected Response browserAuthentication(ClientSessionModel clientSession, String errorMessage) {
        this.event.event(EventType.LOGIN);
        AuthenticationFlowModel flow = this.realmModel.getBrowserFlow();
        String flowId = flow.getId();
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setClientSession(clientSession).setFlowPath("authenticate").setFlowId(flowId).setConnection(this.clientConnection).setEventBuilder(this.event).setProtector(this.protector).setRealm(this.realmModel).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.request);
        if (errorMessage != null) {
            processor.setForwardedErrorMessage(new FormMessage(null, errorMessage));
        }
        try {
            return processor.authenticate();
        }
        catch (Exception e) {
            return processor.handleBrowserException(e);
        }
    }

    private Response badRequest(String message) {
        this.fireErrorEvent(message);
        return ErrorResponse.error(message, Response.Status.BAD_REQUEST);
    }

    private Response forbidden(String message) {
        this.fireErrorEvent(message);
        return ErrorResponse.error(message, Response.Status.FORBIDDEN);
    }

    public static IdentityProvider getIdentityProvider(KeycloakSession session, RealmModel realm, String alias) {
        IdentityProviderModel identityProviderModel = realm.getIdentityProviderByAlias(alias);
        if (identityProviderModel != null) {
            IdentityProviderFactory providerFactory = IdentityBrokerService.getIdentityProviderFactory(session, identityProviderModel);
            if (providerFactory == null) {
                throw new IdentityBrokerException("Could not find factory for identity provider [" + alias + "].");
            }
            return providerFactory.create(identityProviderModel);
        }
        throw new IdentityBrokerException("Identity Provider [" + alias + "] not found.");
    }

    private static IdentityProviderFactory getIdentityProviderFactory(KeycloakSession session, IdentityProviderModel model) {
        HashMap<String, IdentityProviderFactory> availableProviders = new HashMap<String, IdentityProviderFactory>();
        ArrayList allProviders = new ArrayList();
        allProviders.addAll(session.getKeycloakSessionFactory().getProviderFactories(IdentityProvider.class));
        allProviders.addAll(session.getKeycloakSessionFactory().getProviderFactories(SocialIdentityProvider.class));
        for (ProviderFactory providerFactory : allProviders) {
            availableProviders.put(providerFactory.getId(), (IdentityProviderFactory)providerFactory);
        }
        return (IdentityProviderFactory)availableProviders.get(model.getProviderId());
    }

    private IdentityProviderModel getIdentityProviderConfig(String providerId) {
        IdentityProviderModel model = this.realmModel.getIdentityProviderByAlias(providerId);
        if (model == null) {
            throw new IdentityBrokerException("Configuration for identity provider [" + providerId + "] not found.");
        }
        return model;
    }

    private Response corsResponse(Response response, ClientModel clientModel) {
        return Cors.add(this.request, Response.fromResponse((Response)response)).auth().allowedOrigins(clientModel).build();
    }

    private void fireErrorEvent(String message, Throwable throwable) {
        if (!this.event.getEvent().getType().toString().endsWith("_ERROR")) {
            boolean newTransaction = !this.session.getTransaction().isActive();
            try {
                if (newTransaction) {
                    this.session.getTransaction().begin();
                }
                this.event.error(message);
                if (newTransaction) {
                    this.session.getTransaction().commit();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Could not fire event.", (Throwable)e);
                this.rollback();
            }
        }
        if (throwable != null) {
            LOGGER.error((Object)message, throwable);
        } else {
            LOGGER.error((Object)message);
        }
    }

    private void fireErrorEvent(String message) {
        this.fireErrorEvent(message, null);
    }

    private boolean isDebugEnabled() {
        return LOGGER.isDebugEnabled();
    }

    private void rollback() {
        if (this.session.getTransaction().isActive()) {
            this.session.getTransaction().rollback();
        }
    }
}

