/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntitiesDescriptorType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.exportimport.ClientDescriptionConverter;
import org.keycloak.exportimport.ClientDescriptionConverterFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.saml.v2.util.SAMLMetadataUtil;
import org.keycloak.saml.processing.core.util.CoreConfigUtil;

public class EntityDescriptorDescriptionConverter
implements ClientDescriptionConverter,
ClientDescriptionConverterFactory {
    public static final String ID = "saml2-entity-descriptor";

    public boolean isSupported(String description) {
        return (description = description.trim()).startsWith("<") && description.endsWith(">") && description.contains("EntityDescriptor");
    }

    public ClientRepresentation convertToInternal(String description) {
        return EntityDescriptorDescriptionConverter.loadEntityDescriptors(new ByteArrayInputStream(description.getBytes()));
    }

    private static ClientRepresentation loadEntityDescriptors(InputStream is) {
        String assertionConsumerServiceRedirectBinding;
        String assertionConsumerServicePostBinding;
        String logoutPost;
        EntitiesDescriptorType entities;
        Object metadata;
        try {
            metadata = new SAMLParser().parse(is);
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
        if (EntitiesDescriptorType.class.isInstance(metadata)) {
            entities = (EntitiesDescriptorType)metadata;
        } else {
            entities = new EntitiesDescriptorType();
            entities.addEntityDescriptor(metadata);
        }
        if (entities.getEntityDescriptor().size() != 1) {
            throw new RuntimeException("Expected one entity descriptor");
        }
        EntityDescriptorType entity = (EntityDescriptorType)entities.getEntityDescriptor().get(0);
        String entityId = entity.getEntityID();
        ClientRepresentation app = new ClientRepresentation();
        app.setClientId(entityId);
        HashMap<String, String> attributes = new HashMap<String, String>();
        app.setAttributes(attributes);
        LinkedList<String> redirectUris = new LinkedList<String>();
        app.setRedirectUris(redirectUris);
        app.setFullScopeAllowed(Boolean.valueOf(true));
        app.setProtocol("saml");
        attributes.put("saml.server.signature", "true");
        attributes.put("saml.signature.algorithm", SignatureAlgorithm.RSA_SHA256.toString());
        attributes.put("saml.authnstatement", "true");
        SPSSODescriptorType spDescriptorType = CoreConfigUtil.getSPDescriptor((EntityDescriptorType)entity);
        if (spDescriptorType.isWantAssertionsSigned().booleanValue()) {
            attributes.put("saml.assertion.signature", "true");
        }
        if ((logoutPost = EntityDescriptorDescriptionConverter.getLogoutLocation(spDescriptorType, JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get())) != null) {
            attributes.put("saml_single_logout_service_url_post", logoutPost);
        }
        String logoutRedirect = EntityDescriptorDescriptionConverter.getLogoutLocation(spDescriptorType, JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get());
        if (logoutPost != null) {
            attributes.put("saml_single_logout_service_url_redirect", logoutRedirect);
        }
        if ((assertionConsumerServicePostBinding = CoreConfigUtil.getServiceURL((SPSSODescriptorType)spDescriptorType, (String)JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get())) != null) {
            attributes.put("saml_assertion_consumer_url_post", assertionConsumerServicePostBinding);
            redirectUris.add(assertionConsumerServicePostBinding);
        }
        if ((assertionConsumerServiceRedirectBinding = CoreConfigUtil.getServiceURL((SPSSODescriptorType)spDescriptorType, (String)JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get())) != null) {
            attributes.put("saml_assertion_consumer_url_redirect", assertionConsumerServiceRedirectBinding);
            redirectUris.add(assertionConsumerServiceRedirectBinding);
        }
        for (KeyDescriptorType keyDescriptor : spDescriptorType.getKeyDescriptor()) {
            X509Certificate cert = null;
            try {
                cert = SAMLMetadataUtil.getCertificate((KeyDescriptorType)keyDescriptor);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
            catch (ProcessingException e) {
                throw new RuntimeException(e);
            }
            String certPem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)cert);
            if (keyDescriptor.getUse() == KeyTypes.SIGNING) {
                attributes.put("saml.client.signature", "true");
                attributes.put("saml.signing.certificate", certPem);
                continue;
            }
            if (keyDescriptor.getUse() != KeyTypes.ENCRYPTION) continue;
            attributes.put("saml.encrypt", "true");
            attributes.put("saml.encryption.certificate", certPem);
        }
        return app;
    }

    private static String getLogoutLocation(SPSSODescriptorType idp, String bindingURI) {
        String logoutResponseLocation = null;
        List endpoints = idp.getSingleLogoutService();
        for (EndpointType endpoint : endpoints) {
            if (!endpoint.getBinding().toString().equals(bindingURI)) continue;
            if (endpoint.getLocation() != null) {
                logoutResponseLocation = endpoint.getLocation().toString();
                break;
            }
            logoutResponseLocation = null;
            break;
        }
        return logoutResponseLocation;
    }

    public ClientDescriptionConverter create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }
}

