/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.AbstractLoginProtocolFactory;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlClientTemplate;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.protocol.saml.SamlRepresentationAttributes;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.protocol.saml.mappers.RoleListMapper;
import org.keycloak.protocol.saml.mappers.UserPropertyAttributeStatementMapper;
import org.keycloak.representations.idm.CertificateRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientTemplateRepresentation;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.constants.X500SAMLProfileConstants;
import org.keycloak.services.managers.AuthenticationManager;

public class SamlProtocolFactory
extends AbstractLoginProtocolFactory {
    static List<ProtocolMapperModel> builtins = new ArrayList<ProtocolMapperModel>();
    static List<ProtocolMapperModel> defaultBuiltins = new ArrayList<ProtocolMapperModel>();

    public Object createProtocolEndpoint(RealmModel realm, EventBuilder event, AuthenticationManager authManager) {
        return new SamlService(realm, event, authManager);
    }

    public LoginProtocol create(KeycloakSession session) {
        return new SamlProtocol().setSession(session);
    }

    public void init(Config.Scope config) {
    }

    public String getId() {
        return "saml";
    }

    public List<ProtocolMapperModel> getBuiltinMappers() {
        return builtins;
    }

    public List<ProtocolMapperModel> getDefaultBuiltinMappers() {
        return defaultBuiltins;
    }

    protected void addDefaults(ClientModel client) {
        for (ProtocolMapperModel model : defaultBuiltins) {
            model.setProtocol(this.getId());
            client.addProtocolMapper(model);
        }
    }

    public void setupClientDefaults(ClientRepresentation clientRep, ClientModel newClient) {
        SamlRepresentationAttributes rep = new SamlRepresentationAttributes(clientRep.getAttributes());
        SamlClient client = new SamlClient(newClient);
        if (clientRep.isStandardFlowEnabled() == null) {
            newClient.setStandardFlowEnabled(true);
        }
        if (rep.getCanonicalizationMethod() == null) {
            client.setCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#");
        }
        if (rep.getSignatureAlgorithm() == null) {
            client.setSignatureAlgorithm(SignatureAlgorithm.RSA_SHA256);
        }
        if (rep.getNameIDFormat() == null) {
            client.setNameIDFormat("username");
        }
        if (rep.getIncludeAuthnStatement() == null) {
            client.setIncludeAuthnStatement(true);
        }
        if (rep.getForceNameIDFormat() == null) {
            client.setForceNameIDFormat(false);
        }
        if (rep.getSamlServerSignature() == null) {
            client.setRequiresRealmSignature(true);
        }
        if (rep.getForcePostBinding() == null) {
            client.setForcePostBinding(true);
        }
        if (rep.getClientSignature() == null) {
            client.setRequiresClientSignature(true);
        }
        if (client.requiresClientSignature() && client.getClientSigningCertificate() == null) {
            CertificateRepresentation info = KeycloakModelUtils.generateKeyPairCertificate((String)newClient.getClientId());
            client.setClientSigningCertificate(info.getCertificate());
            client.setClientSigningPrivateKey(info.getPrivateKey());
        }
        if (clientRep.isFrontchannelLogout() == null) {
            newClient.setFrontchannelLogout(true);
        }
    }

    public void setupTemplateDefaults(ClientTemplateRepresentation clientRep, ClientTemplateModel newClient) {
        SamlRepresentationAttributes rep = new SamlRepresentationAttributes(clientRep.getAttributes());
        SamlClientTemplate client = new SamlClientTemplate(newClient);
        if (clientRep.isStandardFlowEnabled() == null) {
            newClient.setStandardFlowEnabled(true);
        }
        if (rep.getCanonicalizationMethod() == null) {
            client.setCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#");
        }
        if (rep.getSignatureAlgorithm() == null) {
            client.setSignatureAlgorithm(SignatureAlgorithm.RSA_SHA256);
        }
        if (rep.getNameIDFormat() == null) {
            client.setNameIDFormat("username");
        }
        if (rep.getIncludeAuthnStatement() == null) {
            client.setIncludeAuthnStatement(true);
        }
        if (rep.getForceNameIDFormat() == null) {
            client.setForceNameIDFormat(false);
        }
        if (rep.getSamlServerSignature() == null) {
            client.setRequiresRealmSignature(true);
        }
        if (rep.getForcePostBinding() == null) {
            client.setForcePostBinding(true);
        }
        if (rep.getClientSignature() == null) {
            client.setRequiresClientSignature(true);
        }
        if (clientRep.isFrontchannelLogout() == null) {
            newClient.setFrontchannelLogout(true);
        }
    }

    static {
        ProtocolMapperModel model = UserPropertyAttributeStatementMapper.createAttributeMapper("X500 email", "email", X500SAMLProfileConstants.EMAIL.get(), JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get(), X500SAMLProfileConstants.EMAIL.getFriendlyName(), true, "${email}");
        builtins.add(model);
        model = UserPropertyAttributeStatementMapper.createAttributeMapper("X500 givenName", "firstName", X500SAMLProfileConstants.GIVEN_NAME.get(), JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get(), X500SAMLProfileConstants.GIVEN_NAME.getFriendlyName(), true, "${givenName}");
        builtins.add(model);
        model = UserPropertyAttributeStatementMapper.createAttributeMapper("X500 surname", "lastName", X500SAMLProfileConstants.SURNAME.get(), JBossSAMLURIConstants.ATTRIBUTE_FORMAT_URI.get(), X500SAMLProfileConstants.SURNAME.getFriendlyName(), true, "${familyName}");
        builtins.add(model);
        model = RoleListMapper.create("role list", "Role", "Basic", null, false);
        builtins.add(model);
        defaultBuiltins.add(model);
    }
}

