/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.broker.provider.AbstractIdentityProviderMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;

public class UserAttributeMapper
extends AbstractIdentityProviderMapper {
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"saml"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String ATTRIBUTE_NAME = "attribute.name";
    public static final String ATTRIBUTE_FRIENDLY_NAME = "attribute.friendly.name";
    public static final String USER_ATTRIBUTE = "user.attribute";
    public static final String PROVIDER_ID = "saml-user-attribute-idp-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Attribute Importer";
    }

    public String getDisplayType() {
        return "Attribute Importer";
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String attribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE);
        String value = this.getAttribute(mapperModel, context);
        if (value != null) {
            context.setUserAttribute(attribute, value.toString());
        }
    }

    protected String getAttribute(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String friendly;
        String name = (String)mapperModel.getConfig().get(ATTRIBUTE_NAME);
        if (name != null && name.trim().equals("")) {
            name = null;
        }
        if ((friendly = (String)mapperModel.getConfig().get(ATTRIBUTE_FRIENDLY_NAME)) != null && friendly.trim().equals("")) {
            friendly = null;
        }
        AssertionType assertion = (AssertionType)context.getContextData().get("SAML_ASSERTION");
        for (AttributeStatementType statement : assertion.getAttributeStatements()) {
            for (AttributeStatementType.ASTChoiceType choice : statement.getAttributes()) {
                AttributeType attr = choice.getAttribute();
                if (name != null && !name.equals(attr.getName()) || friendly != null && !friendly.equals(attr.getFriendlyName())) continue;
                List attributeValue = attr.getAttributeValue();
                if (attributeValue == null || attributeValue.isEmpty()) {
                    return null;
                }
                return attributeValue.get(0).toString();
            }
        }
        return null;
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String attribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE);
        String value = this.getAttribute(mapperModel, context);
        String current = user.getFirstAttribute(attribute);
        if (value != null && !value.equals(current)) {
            user.setSingleAttribute(attribute, value.toString());
        } else if (value == null) {
            user.removeAttribute(attribute);
        }
    }

    public String getHelpText() {
        return "Import declared saml attribute if it exists in assertion into the specified user attribute.";
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(ATTRIBUTE_NAME);
        property.setLabel("Attribute Name");
        property.setHelpText("Name of attribute to search for in assertion.  You can leave this blank and specify a friendly name instead.");
        property.setType("String");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(ATTRIBUTE_FRIENDLY_NAME);
        property.setLabel("Friendly Name");
        property.setHelpText("Friendly name of attribute to search for in assertion.  You can leave this blank and specify a name instead.");
        property.setType("String");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(USER_ATTRIBUTE);
        property.setLabel("User Attribute Name");
        property.setHelpText("User attribute name to store saml attribute.");
        property.setType("String");
        configProperties.add(property);
    }
}

