/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.linkedin;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.codehaus.jackson.JsonNode;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.oidc.util.JsonSimpleHttp;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.social.SocialIdentityProvider;

public class LinkedInIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    private static final Logger log = Logger.getLogger(LinkedInIdentityProvider.class);
    public static final String AUTH_URL = "https://www.linkedin.com/uas/oauth2/authorization";
    public static final String TOKEN_URL = "https://www.linkedin.com/uas/oauth2/accessToken";
    public static final String PROFILE_URL = "https://api.linkedin.com/v1/people/~:(id,formatted-name,email-address,public-profile-url)?format=json";
    public static final String DEFAULT_SCOPE = "r_basicprofile r_emailaddress";

    public LinkedInIdentityProvider(OAuth2IdentityProviderConfig config) {
        super(config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        log.debug((Object)"doGetFederatedIdentity()");
        try {
            JsonNode profile = JsonSimpleHttp.asJson((SimpleHttp)SimpleHttp.doGet((String)PROFILE_URL).header("Authorization", "Bearer " + accessToken));
            BrokeredIdentityContext user = new BrokeredIdentityContext(this.getJsonProperty(profile, "id"));
            String username = LinkedInIdentityProvider.extractUsernameFromProfileURL(this.getJsonProperty(profile, "publicProfileUrl"));
            user.setUsername(username);
            user.setName(this.getJsonProperty(profile, "formattedName"));
            user.setEmail(this.getJsonProperty(profile, "emailAddress"));
            user.setIdpConfig((IdentityProviderModel)this.getConfig());
            user.setIdp((IdentityProvider)this);
            AbstractJsonUserAttributeMapper.storeUserProfileForMapper((BrokeredIdentityContext)user, (JsonNode)profile, (String)this.getConfig().getAlias());
            return user;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from linkedIn.", (Throwable)e);
        }
    }

    protected static String extractUsernameFromProfileURL(String profileURL) {
        if (LinkedInIdentityProvider.isNotBlank(profileURL)) {
            try {
                log.debug((Object)("go to extract username from profile URL " + profileURL));
                URL u = new URL(profileURL);
                String path = u.getPath();
                if (LinkedInIdentityProvider.isNotBlank(path) && path.length() > 1) {
                    String[] pe;
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    if ((pe = path.split("/")).length >= 2) {
                        return URLDecoder.decode(pe[1], "UTF-8");
                    }
                    log.warn((Object)("LinkedIn profile URL path is without second part: " + profileURL));
                } else {
                    log.warn((Object)("LinkedIn profile URL is without path part: " + profileURL));
                }
            }
            catch (MalformedURLException e) {
                log.warn((Object)("LinkedIn profile URL is malformed: " + profileURL));
            }
            catch (Exception e) {
                log.warn((Object)("LinkedIn profile URL " + profileURL + " username extraction failed due: " + e.getMessage()));
            }
        }
        return null;
    }

    private static boolean isNotBlank(String s) {
        return s != null && s.trim().length() > 0;
    }

    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

