/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml;

import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.dom.saml.v1.assertion.SAML11AssertionType;
import org.keycloak.dom.saml.v1.assertion.SAML11AttributeStatementType;
import org.keycloak.dom.saml.v1.assertion.SAML11AuthenticationStatementType;
import org.keycloak.dom.saml.v1.assertion.SAML11AuthorizationDecisionStatementType;
import org.keycloak.dom.saml.v1.assertion.SAML11ConditionsType;
import org.keycloak.dom.saml.v1.assertion.SAML11SubjectStatementType;
import org.keycloak.dom.saml.v1.assertion.SAML11SubjectType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.parsers.ParserNamespaceSupport;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAML11SubjectParser;
import org.keycloak.saml.processing.core.parsers.util.SAML11ParserUtil;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Element;

public class SAML11AssertionParser
implements ParserNamespaceSupport {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final String ASSERTION = JBossSAMLConstants.ASSERTION.get();

    public SAML11AssertionType fromElement(Element element) throws ConfigurationException, ProcessingException, ParsingException {
        XMLEventReader xmlEventReader = StaxParserUtil.getXMLEventReader(DocumentUtil.getNodeAsStream(element));
        return (SAML11AssertionType)this.parse(xmlEventReader);
    }

    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
        startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, this.ASSERTION);
        SAML11AssertionType assertion = this.parseBaseAttributes(startElement);
        Attribute issuerAttribute = startElement.getAttributeByName(new QName("Issuer"));
        String issuer = StaxParserUtil.getAttributeValue(issuerAttribute);
        assertion.setIssuer(issuer);
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                xmlEvent = StaxParserUtil.getNextEvent(xmlEventReader);
                EndElement endElement = (EndElement)xmlEvent;
                String endElementTag = StaxParserUtil.getEndElementName(endElement);
                if (endElementTag.equals(JBossSAMLConstants.ASSERTION.get())) break;
                throw logger.parserUnknownEndElement(endElementTag);
            }
            StartElement peekedElement = null;
            peekedElement = xmlEvent instanceof StartElement ? (StartElement)xmlEvent : StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (peekedElement == null) break;
            String tag = StaxParserUtil.getStartElementName(peekedElement);
            if (tag.equals(JBossSAMLConstants.SIGNATURE.get())) {
                assertion.setSignature(StaxParserUtil.getDOMElement(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ISSUER.get().equalsIgnoreCase(tag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                issuer = StaxParserUtil.getElementText(xmlEventReader);
                assertion.setIssuer(issuer);
                continue;
            }
            if (JBossSAMLConstants.SUBJECT.get().equalsIgnoreCase(tag)) {
                SAML11SubjectParser subjectParser = new SAML11SubjectParser();
                SAML11SubjectType subject = (SAML11SubjectType)subjectParser.parse(xmlEventReader);
                SAML11SubjectStatementType subStat = new SAML11SubjectStatementType();
                subStat.setSubject(subject);
                continue;
            }
            if (JBossSAMLConstants.CONDITIONS.get().equalsIgnoreCase(tag)) {
                startElement = (StartElement)xmlEvent;
                SAML11ConditionsType conditions = SAML11ParserUtil.parseSAML11Conditions(xmlEventReader);
                assertion.setConditions(conditions);
                continue;
            }
            if ("AuthenticationStatement".equals(tag)) {
                startElement = (StartElement)xmlEvent;
                SAML11AuthenticationStatementType authStat = SAML11ParserUtil.parseAuthenticationStatement(xmlEventReader);
                assertion.add(authStat);
                continue;
            }
            if ("AttributeStatement".equalsIgnoreCase(tag)) {
                SAML11AttributeStatementType attributeStatementType = SAML11ParserUtil.parseSAML11AttributeStatement(xmlEventReader);
                assertion.add(attributeStatementType);
                continue;
            }
            if ("AuthorizationDecisionStatement".equalsIgnoreCase(tag)) {
                SAML11AuthorizationDecisionStatementType authzStat = SAML11ParserUtil.parseSAML11AuthorizationDecisionStatement(xmlEventReader);
                assertion.add(authzStat);
                continue;
            }
            throw logger.parserUnknownTag(tag, peekedElement.getLocation());
        }
        return assertion;
    }

    @Override
    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return nsURI.equals(JBossSAMLURIConstants.ASSERTION_NSURI.get()) && localPart.equals(JBossSAMLConstants.ASSERTION.get());
    }

    private SAML11AssertionType parseBaseAttributes(StartElement nextElement) throws ParsingException {
        Attribute idAttribute = nextElement.getAttributeByName(new QName("AssertionID"));
        if (idAttribute == null) {
            throw logger.parserRequiredAttribute("AssertionID");
        }
        String id = StaxParserUtil.getAttributeValue(idAttribute);
        Attribute majVersionAttribute = nextElement.getAttributeByName(new QName("MajorVersion"));
        String majVersion = StaxParserUtil.getAttributeValue(majVersionAttribute);
        StringUtil.match("1", majVersion);
        Attribute minVersionAttribute = nextElement.getAttributeByName(new QName("MinorVersion"));
        String minVersion = StaxParserUtil.getAttributeValue(minVersionAttribute);
        StringUtil.match("1", minVersion);
        Attribute issueInstantAttribute = nextElement.getAttributeByName(new QName(JBossSAMLConstants.ISSUE_INSTANT.get()));
        XMLGregorianCalendar issueInstant = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(issueInstantAttribute));
        return new SAML11AssertionType(id, issueInstant);
    }
}

