/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.profile.ecp.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.Response;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.keycloak.saml.processing.core.saml.v2.util.DocumentUtil;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class Soap {
    public static SoapFaultBuilder createFault() {
        return new SoapFaultBuilder();
    }

    public static SoapMessageBuilder createMessage() {
        return new SoapMessageBuilder();
    }

    public static String toSamlHttpPostMessage(InputStream inputStream) {
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage soapMessage = messageFactory.createMessage(null, inputStream);
            SOAPBody soapBody = soapMessage.getSOAPBody();
            Node authnRequestNode = soapBody.getFirstChild();
            Document document = DocumentUtil.createDocument();
            document.appendChild(document.importNode(authnRequestNode, true));
            return PostBindingUtil.base64Encode((String)DocumentUtil.asString((Document)document));
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating fault message.", e);
        }
    }

    public static class SoapFaultBuilder {
        private final SOAPFault fault;
        private final SoapMessageBuilder messageBuilder = Soap.createMessage();

        private SoapFaultBuilder() {
            try {
                this.fault = this.messageBuilder.getMessage().getSOAPBody().addFault();
            }
            catch (SOAPException e) {
                throw new RuntimeException("Could not create SOAP Fault.", e);
            }
        }

        public SoapFaultBuilder detail(String detail) {
            try {
                this.fault.addDetail().setValue(detail);
            }
            catch (SOAPException e) {
                throw new RuntimeException("Error creating fault message.", e);
            }
            return this;
        }

        public SoapFaultBuilder reason(String reason) {
            try {
                this.fault.setFaultString(reason);
            }
            catch (SOAPException e) {
                throw new RuntimeException("Error creating fault message.", e);
            }
            return this;
        }

        public SoapFaultBuilder code(String code) {
            try {
                this.fault.setFaultCode(code);
            }
            catch (SOAPException e) {
                throw new RuntimeException("Error creating fault message.", e);
            }
            return this;
        }

        public Response build() {
            return this.messageBuilder.build(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public static class SoapMessageBuilder {
        private final SOAPMessage message;
        private final SOAPBody body;
        private final SOAPEnvelope envelope;

        private SoapMessageBuilder() {
            try {
                this.message = MessageFactory.newInstance().createMessage();
                this.envelope = this.message.getSOAPPart().getEnvelope();
                this.body = this.message.getSOAPBody();
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating fault message.", e);
            }
        }

        public SoapMessageBuilder addToBody(Document document) {
            try {
                this.body.addDocument(document);
            }
            catch (SOAPException e) {
                throw new RuntimeException("Could not add document to SOAP body.", e);
            }
            return this;
        }

        public SoapMessageBuilder addNamespace(String prefix, String ns) {
            try {
                this.envelope.addNamespaceDeclaration(prefix, ns);
            }
            catch (SOAPException e) {
                throw new RuntimeException("Could not add namespace to SOAP Envelope.", e);
            }
            return this;
        }

        public SOAPHeaderElement addHeader(String name, String prefix) {
            try {
                return this.envelope.getHeader().addHeaderElement(this.envelope.createQName(name, prefix));
            }
            catch (SOAPException e) {
                throw new RuntimeException("Could not add SOAP Header.", e);
            }
        }

        public Name createName(String name) {
            try {
                return this.envelope.createName(name);
            }
            catch (SOAPException e) {
                throw new RuntimeException("Could not create Name.", e);
            }
        }

        public Response build() {
            return this.build(Response.Status.OK);
        }

        Response build(Response.Status status) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                this.message.writeTo((OutputStream)outputStream);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while building SOAP Fault.", e);
            }
            return Response.status((Response.Status)status).entity((Object)outputStream.toByteArray()).build();
        }

        SOAPMessage getMessage() {
            return this.message;
        }
    }
}

