/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.security.PublicKey;
import javax.ws.rs.POST;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.node.ObjectNode;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.OAuthErrorException;
import org.keycloak.RSATokenVerifier;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.util.JsonSerialization;

public class TokenIntrospectionEndpoint {
    private static final String TOKEN_TYPE_ACCESS_TOKEN = "access_token";
    private static final String TOKEN_TYPE_REFRESH_TOKEN = "refresh_token";
    private static final String PARAM_TOKEN_TYPE_HINT = "token_type_hint";
    private static final String PARAM_TOKEN = "token";
    @Context
    private KeycloakSession session;
    @Context
    private HttpRequest request;
    @Context
    private HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private ClientConnection clientConnection;
    private final RealmModel realm;
    private final TokenManager tokenManager;
    private final EventBuilder event;

    public TokenIntrospectionEndpoint(RealmModel realm, TokenManager tokenManager, EventBuilder event) {
        this.realm = realm;
        this.tokenManager = tokenManager;
        this.event = event;
    }

    @POST
    @NoCache
    public Response introspect() {
        String token;
        this.event.event(EventType.INTROSPECT_TOKEN);
        this.checkSsl();
        this.checkRealm();
        this.authorizeClient();
        MultivaluedMap formParams = this.request.getDecodedFormParameters();
        String tokenTypeHint = (String)formParams.getFirst((Object)PARAM_TOKEN_TYPE_HINT);
        if (tokenTypeHint == null) {
            tokenTypeHint = TOKEN_TYPE_ACCESS_TOKEN;
        }
        if ((token = (String)formParams.getFirst((Object)PARAM_TOKEN)) == null) {
            throw this.throwErrorResponseException("invalid_request", "Token not provided.", Response.Status.BAD_REQUEST);
        }
        try {
            ObjectNode tokenMetadata;
            AccessToken toIntrospect = this.toAccessToken(tokenTypeHint, token);
            if (toIntrospect.isActive()) {
                tokenMetadata = JsonSerialization.createObjectNode((Object)toIntrospect);
                tokenMetadata.put("client_id", toIntrospect.getIssuedFor());
                tokenMetadata.put("username", toIntrospect.getPreferredUsername());
            } else {
                tokenMetadata = JsonSerialization.createObjectNode();
            }
            tokenMetadata.put("active", toIntrospect.isActive());
            this.event.success();
            return Response.ok((Object)JsonSerialization.writeValueAsBytes((Object)tokenMetadata)).build();
        }
        catch (Exception e) {
            throw this.throwErrorResponseException("invalid_request", "Failed to introspect token.", Response.Status.BAD_REQUEST);
        }
    }

    private AccessToken toAccessToken(String tokenTypeHint, String token) throws JWSInputException, OAuthErrorException {
        if (TOKEN_TYPE_ACCESS_TOKEN.equals(tokenTypeHint)) {
            return this.toAccessToken(token);
        }
        if (TOKEN_TYPE_REFRESH_TOKEN.equals(tokenTypeHint)) {
            return this.tokenManager.toRefreshToken(this.realm, token);
        }
        throw this.throwErrorResponseException("invalid_request", "Unsupported token type [" + tokenTypeHint + "].", Response.Status.BAD_REQUEST);
    }

    private void authorizeClient() {
        try {
            ClientModel client = AuthorizeClientUtil.authorizeClient(this.session, this.event).getClient();
            this.event.client(client);
            if (client == null || client.isPublicClient()) {
                throw this.throwErrorResponseException("invalid_request", "Client not allowed.", Response.Status.FORBIDDEN);
            }
        }
        catch (ErrorResponseException ere) {
            throw ere;
        }
        catch (Exception e) {
            throw this.throwErrorResponseException("invalid_request", "Authentication failed.", Response.Status.UNAUTHORIZED);
        }
    }

    private AccessToken toAccessToken(String tokenString) {
        try {
            return RSATokenVerifier.toAccessToken((String)tokenString, (PublicKey)this.realm.getPublicKey());
        }
        catch (VerificationException e) {
            throw new ErrorResponseException("invalid_request", "Invalid token.", Response.Status.UNAUTHORIZED);
        }
    }

    private void checkSsl() {
        if (!this.uriInfo.getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new ErrorResponseException("invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    private void checkRealm() {
        if (!this.realm.isEnabled()) {
            throw new ErrorResponseException("access_denied", "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }

    private ErrorResponseException throwErrorResponseException(String error, String detail, Response.Status status) {
        this.event.detail("detail", detail).error(error);
        return new ErrorResponseException(error, detail, status);
    }
}

