/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.keycloak.common.util.Encode;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;

public abstract class OIDCRedirectUriBuilder {
    protected final KeycloakUriBuilder uriBuilder;

    protected OIDCRedirectUriBuilder(KeycloakUriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder;
    }

    public abstract OIDCRedirectUriBuilder addParam(String var1, String var2);

    public abstract Response build();

    public static OIDCRedirectUriBuilder fromUri(String baseUri, OIDCResponseMode responseMode) {
        KeycloakUriBuilder uriBuilder = KeycloakUriBuilder.fromUri((String)baseUri);
        switch (responseMode) {
            case QUERY: {
                return new QueryRedirectUriBuilder(uriBuilder);
            }
            case FRAGMENT: {
                return new FragmentRedirectUriBuilder(uriBuilder);
            }
            case FORM_POST: {
                return new FormPostRedirectUriBuilder(uriBuilder);
            }
        }
        throw new IllegalStateException("Not possible to end here");
    }

    private static class FormPostRedirectUriBuilder
    extends OIDCRedirectUriBuilder {
        private Map<String, String> params = new HashMap<String, String>();

        protected FormPostRedirectUriBuilder(KeycloakUriBuilder uriBuilder) {
            super(uriBuilder);
        }

        @Override
        public OIDCRedirectUriBuilder addParam(String paramName, String paramValue) {
            this.params.put(paramName, Encode.encodeQueryParam((String)paramValue));
            return this;
        }

        @Override
        public Response build() {
            StringBuilder builder = new StringBuilder();
            URI redirectUri = this.uriBuilder.build(new Object[0]);
            builder.append("<HTML>");
            builder.append("  <HEAD>");
            builder.append("    <TITLE>OIDC Form_Post Response</TITLE>");
            builder.append("  </HEAD>");
            builder.append("  <BODY Onload=\"document.forms[0].submit()\">");
            builder.append("    <FORM METHOD=\"POST\" ACTION=\"" + redirectUri.toString() + "\">");
            for (Map.Entry<String, String> param : this.params.entrySet()) {
                builder.append("  <INPUT TYPE=\"HIDDEN\" NAME=\"").append(param.getKey()).append("\" VALUE=\"").append(param.getValue()).append("\" />");
            }
            builder.append("      <NOSCRIPT>");
            builder.append("        <P>JavaScript is disabled. We strongly recommend to enable it. Click the button below to continue .</P>");
            builder.append("        <INPUT name=\"continue\" TYPE=\"SUBMIT\" VALUE=\"CONTINUE\" />");
            builder.append("      </NOSCRIPT>");
            builder.append("    </FORM>");
            builder.append("  </BODY>");
            builder.append("</HTML>");
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.TEXT_HTML_TYPE).entity((Object)builder.toString()).build();
        }
    }

    private static class FragmentRedirectUriBuilder
    extends OIDCRedirectUriBuilder {
        private StringBuilder fragment;

        protected FragmentRedirectUriBuilder(KeycloakUriBuilder uriBuilder) {
            super(uriBuilder);
        }

        @Override
        public OIDCRedirectUriBuilder addParam(String paramName, String paramValue) {
            String param = paramName + "=" + Encode.encodeQueryParam((String)paramValue);
            if (this.fragment == null) {
                this.fragment = new StringBuilder(param);
            } else {
                this.fragment.append("&").append(param);
            }
            return this;
        }

        @Override
        public Response build() {
            if (this.fragment != null) {
                this.uriBuilder.encodedFragment(this.fragment.toString());
            }
            URI redirectUri = this.uriBuilder.build(new Object[0]);
            Response.ResponseBuilder location = Response.status((int)302).location(redirectUri);
            return location.build();
        }
    }

    private static class QueryRedirectUriBuilder
    extends OIDCRedirectUriBuilder {
        protected QueryRedirectUriBuilder(KeycloakUriBuilder uriBuilder) {
            super(uriBuilder);
        }

        @Override
        public OIDCRedirectUriBuilder addParam(String paramName, String paramValue) {
            this.uriBuilder.queryParam(paramName, new Object[]{paramValue});
            return this;
        }

        @Override
        public Response build() {
            URI redirectUri = this.uriBuilder.build(new Object[0]);
            Response.ResponseBuilder location = Response.status((int)302).location(redirectUri);
            return location.build();
        }
    }
}

