/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration;

import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientregistration.AbstractClientRegistrationProvider;
import org.keycloak.services.clientregistration.ClientRegistrationAuth;

public class DefaultClientRegistrationProvider
extends AbstractClientRegistrationProvider {
    public DefaultClientRegistrationProvider(KeycloakSession session) {
        super(session);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createDefault(ClientRepresentation client) {
        client = this.create(client);
        URI uri = this.session.getContext().getUri().getAbsolutePathBuilder().path(client.getClientId()).build(new Object[0]);
        return Response.created((URI)uri).entity((Object)client).build();
    }

    @GET
    @Path(value="{clientId}")
    @Produces(value={"application/json"})
    public Response getDefault(@PathParam(value="clientId") String clientId) {
        ClientRepresentation client = this.get(clientId);
        return Response.ok((Object)client).build();
    }

    @PUT
    @Path(value="{clientId}")
    @Consumes(value={"application/json"})
    public Response updateDefault(@PathParam(value="clientId") String clientId, ClientRepresentation client) {
        client = this.update(clientId, client);
        return Response.ok((Object)client).build();
    }

    @DELETE
    @Path(value="{clientId}")
    public void deleteDefault(@PathParam(value="clientId") String clientId) {
        this.delete(clientId);
    }

    @Override
    public void setAuth(ClientRegistrationAuth auth) {
        this.auth = auth;
    }

    @Override
    public void setEvent(EventBuilder event) {
        this.event = event;
    }

    @Override
    public void close() {
    }
}

