/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClientTemplateRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ClientTemplateResource;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.RealmAuth;

public class ClientTemplatesResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmModel realm;
    private RealmAuth auth;
    private AdminEventBuilder adminEvent;
    @Context
    protected KeycloakSession session;

    public ClientTemplatesResource(RealmModel realm, RealmAuth auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.auth = auth;
        this.adminEvent = adminEvent;
        auth.init(RealmAuth.Resource.CLIENT);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<ClientTemplateRepresentation> getClientTemplates() {
        this.auth.requireAny();
        ArrayList<ClientTemplateRepresentation> rep = new ArrayList<ClientTemplateRepresentation>();
        List clientModels = this.realm.getClientTemplates();
        boolean view = this.auth.hasView();
        for (ClientTemplateModel clientModel : clientModels) {
            if (view) {
                rep.add(ModelToRepresentation.toRepresentation((ClientTemplateModel)clientModel));
                continue;
            }
            ClientTemplateRepresentation client = new ClientTemplateRepresentation();
            client.setId(clientModel.getId());
            client.setName(clientModel.getName());
            client.setDescription(clientModel.getDescription());
            client.setProtocol(clientModel.getProtocol());
            rep.add(client);
        }
        return rep;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createClientTemplate(@Context UriInfo uriInfo, ClientTemplateRepresentation rep) {
        this.auth.requireManage();
        try {
            ClientTemplateModel clientModel = RepresentationToModel.createClientTemplate((KeycloakSession)this.session, (RealmModel)this.realm, (ClientTemplateRepresentation)rep);
            this.adminEvent.operation(OperationType.CREATE).resourcePath(uriInfo, clientModel.getId()).representation(rep).success();
            return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(clientModel.getId()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Client Template " + rep.getName() + " already exists");
        }
    }

    @Path(value="{id}")
    public ClientTemplateResource getClient(@PathParam(value="id") String id) {
        ClientTemplateModel clientModel = this.realm.getClientTemplateById(id);
        if (clientModel == null) {
            throw new NotFoundException("Could not find client template");
        }
        ClientTemplateResource clientResource = new ClientTemplateResource(this.realm, this.auth, clientModel, this.session, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)clientResource);
        return clientResource;
    }
}

