/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.GroupResource;
import org.keycloak.services.resources.admin.RealmAuth;

public class GroupsResource {
    private static Logger logger = Logger.getLogger(GroupsResource.class);
    private final RealmModel realm;
    private final KeycloakSession session;
    private final RealmAuth auth;
    private final AdminEventBuilder adminEvent;
    @Context
    private UriInfo uriInfo;

    public GroupsResource(RealmModel realm, KeycloakSession session, RealmAuth auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
        this.adminEvent = adminEvent;
    }

    public GroupsResource(RealmAuth auth, RealmModel realm, KeycloakSession session, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
        this.adminEvent = adminEvent;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<GroupRepresentation> getGroups() {
        this.auth.requireView();
        return ModelToRepresentation.toGroupHierarchy((RealmModel)this.realm, (boolean)false);
    }

    @Path(value="{id}")
    public GroupResource getGroupById(@PathParam(value="id") String id) {
        GroupModel group = this.realm.getGroupById(id);
        if (group == null) {
            throw new NotFoundException("Could not find group by id");
        }
        GroupResource resource = new GroupResource(this.realm, group, this.session, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addTopLevelGroup(GroupRepresentation rep) {
        GroupModel child = null;
        Response.ResponseBuilder builder = Response.status((int)204);
        if (rep.getId() != null) {
            child = this.realm.getGroupById(rep.getId());
            if (child == null) {
                throw new NotFoundException("Could not find child by id");
            }
        } else {
            child = this.realm.createGroup(rep.getName());
            GroupResource.updateGroup(rep, child);
            URI uri = this.uriInfo.getAbsolutePathBuilder().path(child.getId()).build(new Object[0]);
            builder.status(201).location(uri);
        }
        this.realm.moveGroup(child, null);
        return builder.build();
    }
}

