/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.LDAPConfig;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.models.UserFederationProviderModel;

public class LDAPIdentityStoreRegistry {
    private static final Logger logger = Logger.getLogger(LDAPIdentityStoreRegistry.class);
    private Map<String, LDAPIdentityStoreContext> ldapStores = new ConcurrentHashMap<String, LDAPIdentityStoreContext>();

    public LDAPIdentityStore getLdapStore(UserFederationProviderModel model) {
        LDAPIdentityStoreContext context = this.ldapStores.get(model.getId());
        Map config = model.getConfig();
        if (context == null || !config.equals(context.config)) {
            this.logLDAPConfig(model.getDisplayName(), config);
            LDAPIdentityStore store = LDAPIdentityStoreRegistry.createLdapIdentityStore(config);
            context = new LDAPIdentityStoreContext(config, store);
            this.ldapStores.put(model.getId(), context);
        }
        return context.store;
    }

    private void logLDAPConfig(String fedProviderDisplayName, Map<String, String> ldapConfig) {
        HashMap<String, String> copy = new HashMap<String, String>(ldapConfig);
        copy.remove("bindCredential");
        logger.infof("Creating new LDAP based partition manager for the Federation provider: " + fedProviderDisplayName + ", LDAP Configuration: " + copy, new Object[0]);
    }

    public static LDAPIdentityStore createLdapIdentityStore(Map<String, String> ldapConfig) {
        LDAPConfig cfg = new LDAPConfig(ldapConfig);
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.authentication", "none simple");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.initsize", "1");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.maxsize", "1000");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.prefsize", "5");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.timeout", "300000");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.protocol", "plain");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.debug", "off");
        return new LDAPIdentityStore(cfg);
    }

    private static void checkSystemProperty(String name, String defaultValue) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, defaultValue);
        }
    }

    private class LDAPIdentityStoreContext {
        private Map<String, String> config;
        private LDAPIdentityStore store;

        private LDAPIdentityStoreContext(Map<String, String> config, LDAPIdentityStore store) {
            this.config = config;
            this.store = store;
        }
    }
}

