/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;

public class ClientRoleMappingsResource {
    protected static final Logger logger = Logger.getLogger(ClientRoleMappingsResource.class);
    protected RealmModel realm;
    protected RealmAuth auth;
    protected RoleMapperModel user;
    protected ClientModel client;
    protected AdminEventBuilder adminEvent;
    private UriInfo uriInfo;

    public ClientRoleMappingsResource(UriInfo uriInfo, RealmModel realm, RealmAuth auth, RoleMapperModel user, ClientModel client, AdminEventBuilder adminEvent) {
        this.uriInfo = uriInfo;
        this.realm = realm;
        this.auth = auth;
        this.user = user;
        this.client = client;
        this.adminEvent = adminEvent;
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getClientRoleMappings() {
        this.auth.requireView();
        Set mappings = this.user.getClientRoleMappings(this.client);
        ArrayList<RoleRepresentation> mapRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : mappings) {
            mapRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return mapRep;
    }

    @Path(value="composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getCompositeClientRoleMappings() {
        this.auth.requireView();
        Set roles = this.client.getRoles();
        ArrayList<RoleRepresentation> mapRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roles) {
            if (!this.user.hasRole(roleModel)) continue;
            mapRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return mapRep;
    }

    @Path(value="available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getAvailableClientRoleMappings() {
        this.auth.requireView();
        Set available = this.client.getRoles();
        return ClientRoleMappingsResource.getAvailableRoles(this.user, available);
    }

    public static List<RoleRepresentation> getAvailableRoles(RoleMapperModel mapper, Set<RoleModel> available) {
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (RoleModel roleModel : available) {
            if (mapper.hasRole(roleModel)) continue;
            roles.add(roleModel);
        }
        ArrayList<RoleRepresentation> mappings = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roles) {
            mappings.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return mappings;
    }

    @POST
    @Consumes(value={"application/json"})
    public void addClientRoleMapping(List<RoleRepresentation> roles) {
        this.auth.requireManage();
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = this.client.getRole(role.getName());
            if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                throw new NotFoundException("Role not found");
            }
            this.user.grantRole(roleModel);
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo).representation(roles).success();
    }

    @DELETE
    @Consumes(value={"application/json"})
    public void deleteClientRoleMapping(List<RoleRepresentation> roles) {
        this.auth.requireManage();
        if (roles == null) {
            Set roleModels = this.user.getClientRoleMappings(this.client);
            for (RoleModel roleModel : roleModels) {
                ClientModel client;
                if (!(roleModel.getContainer() instanceof ClientModel) && !(client = (ClientModel)roleModel.getContainer()).getId().equals(this.client.getId())) continue;
                this.user.deleteRoleMapping(roleModel);
            }
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.client.getRole(role.getName());
                if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.user.deleteRoleMapping(roleModel);
            }
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).representation(roles).success();
    }
}

