/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.Location;
import twitter4j.ParseUtil;
import twitter4j.ResponseList;
import twitter4j.ResponseListImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.conf.Configuration;

final class LocationJSONImpl
implements Location {
    private static final long serialVersionUID = -1312752311160422264L;
    private final int woeid;
    private final String countryName;
    private final String countryCode;
    private final String placeName;
    private final int placeCode;
    private final String name;
    private final String url;

    LocationJSONImpl(JSONObject location) throws TwitterException {
        try {
            this.woeid = ParseUtil.getInt("woeid", location);
            this.countryName = ParseUtil.getUnescapedString("country", location);
            this.countryCode = ParseUtil.getRawString("countryCode", location);
            if (!location.isNull("placeType")) {
                JSONObject placeJSON = location.getJSONObject("placeType");
                this.placeName = ParseUtil.getUnescapedString("name", placeJSON);
                this.placeCode = ParseUtil.getInt("code", placeJSON);
            } else {
                this.placeName = null;
                this.placeCode = -1;
            }
            this.name = ParseUtil.getUnescapedString("name", location);
            this.url = ParseUtil.getUnescapedString("url", location);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    static ResponseList<Location> createLocationList(HttpResponse res, Configuration conf) throws TwitterException {
        if (conf.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
        }
        return LocationJSONImpl.createLocationList(res.asJSONArray(), conf.isJSONStoreEnabled());
    }

    static ResponseList<Location> createLocationList(JSONArray list, boolean storeJSON) throws TwitterException {
        try {
            int size = list.length();
            ResponseListImpl<Location> locations = new ResponseListImpl<Location>(size, null);
            for (int i = 0; i < size; ++i) {
                JSONObject json = list.getJSONObject(i);
                LocationJSONImpl location = new LocationJSONImpl(json);
                locations.add(location);
                if (!storeJSON) continue;
                TwitterObjectFactory.registerJSONObject(location, json);
            }
            if (storeJSON) {
                TwitterObjectFactory.registerJSONObject(locations, list);
            }
            return locations;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public int getWoeid() {
        return this.woeid;
    }

    @Override
    public String getCountryName() {
        return this.countryName;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public String getPlaceName() {
        return this.placeName;
    }

    @Override
    public int getPlaceCode() {
        return this.placeCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocationJSONImpl)) {
            return false;
        }
        LocationJSONImpl that = (LocationJSONImpl)o;
        return this.woeid == that.woeid;
    }

    public int hashCode() {
        return this.woeid;
    }

    public String toString() {
        return "LocationJSONImpl{woeid=" + this.woeid + ", countryName='" + this.countryName + '\'' + ", countryCode='" + this.countryCode + '\'' + ", placeName='" + this.placeName + '\'' + ", placeCode='" + this.placeCode + '\'' + ", name='" + this.name + '\'' + ", url='" + this.url + '\'' + '}';
    }
}

