/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.saml.v2.util;

import javax.xml.stream.XMLStreamWriter;
import org.keycloak.dom.xmlsec.w3.xmldsig.DSAKeyValueType;
import org.keycloak.dom.xmlsec.w3.xmldsig.KeyInfoType;
import org.keycloak.dom.xmlsec.w3.xmldsig.KeyValueType;
import org.keycloak.dom.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.keycloak.dom.xmlsec.w3.xmldsig.X509CertificateType;
import org.keycloak.dom.xmlsec.w3.xmldsig.X509DataType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.StaxUtil;
import org.w3c.dom.Element;

public class StaxWriterUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static void writeKeyInfo(XMLStreamWriter writer, KeyInfoType keyInfo) throws ProcessingException {
        if (keyInfo.getContent() == null || keyInfo.getContent().size() == 0) {
            throw logger.writerInvalidKeyInfoNullContentError();
        }
        StaxUtil.writeStartElement(writer, "ds", "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        StaxUtil.writeNameSpace(writer, "ds", "http://www.w3.org/2000/09/xmldsig#");
        Object content = keyInfo.getContent().get(0);
        if (content instanceof Element) {
            Element element = (Element)keyInfo.getContent().get(0);
            StaxUtil.writeDOMNode(writer, element);
        } else if (content instanceof X509DataType) {
            X509DataType type = (X509DataType)content;
            if (type.getDataObjects().size() == 0) {
                throw logger.writerNullValueError("X509Data");
            }
            StaxUtil.writeStartElement(writer, "ds", "X509Data", "http://www.w3.org/2000/09/xmldsig#");
            Object obj = type.getDataObjects().get(0);
            if (obj instanceof Element) {
                Element element = (Element)obj;
                StaxUtil.writeDOMElement(writer, element);
            } else if (obj instanceof X509CertificateType) {
                X509CertificateType cert = (X509CertificateType)obj;
                StaxUtil.writeStartElement(writer, "ds", "X509Certificate", "http://www.w3.org/2000/09/xmldsig#");
                StaxUtil.writeCharacters(writer, new String(cert.getEncodedCertificate()));
                StaxUtil.writeEndElement(writer);
            }
            StaxUtil.writeEndElement(writer);
        } else if (content instanceof KeyValueType) {
            KeyValueType keyvalueType = (KeyValueType)content;
            StaxUtil.writeStartElement(writer, "ds", "KeyValue", "http://www.w3.org/2000/09/xmldsig#");
            if (keyvalueType instanceof DSAKeyValueType) {
                StaxWriterUtil.writeDSAKeyValueType(writer, (DSAKeyValueType)keyvalueType);
            }
            if (keyvalueType instanceof RSAKeyValueType) {
                StaxWriterUtil.writeRSAKeyValueType(writer, (RSAKeyValueType)keyvalueType);
            }
            StaxUtil.writeEndElement(writer);
        } else {
            throw new ProcessingException("PL00069: Parser: Type not supported:" + content);
        }
        StaxUtil.writeEndElement(writer);
    }

    public static void writeRSAKeyValueType(XMLStreamWriter writer, RSAKeyValueType type) throws ProcessingException {
        String prefix = "ds";
        StaxUtil.writeStartElement(writer, prefix, "RSAKeyValue", "http://www.w3.org/2000/09/xmldsig#");
        byte[] modulus = type.getModulus();
        StaxUtil.writeStartElement(writer, prefix, "Modulus", "http://www.w3.org/2000/09/xmldsig#");
        StaxUtil.writeCharacters(writer, new String(modulus));
        StaxUtil.writeEndElement(writer);
        byte[] exponent = type.getExponent();
        StaxUtil.writeStartElement(writer, prefix, "Exponent", "http://www.w3.org/2000/09/xmldsig#");
        StaxUtil.writeCharacters(writer, new String(exponent));
        StaxUtil.writeEndElement(writer);
        StaxUtil.writeEndElement(writer);
    }

    public static void writeDSAKeyValueType(XMLStreamWriter writer, DSAKeyValueType type) throws ProcessingException {
        byte[] pgen;
        byte[] seed;
        byte[] y;
        byte[] g;
        byte[] q;
        String prefix = "ds";
        StaxUtil.writeStartElement(writer, prefix, "DSAKeyValue", "http://www.w3.org/2000/09/xmldsig#");
        byte[] p = type.getP();
        if (p != null) {
            StaxUtil.writeStartElement(writer, prefix, "P", "http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters(writer, new String(p));
            StaxUtil.writeEndElement(writer);
        }
        if ((q = type.getQ()) != null) {
            StaxUtil.writeStartElement(writer, prefix, "Q", "http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters(writer, new String(q));
            StaxUtil.writeEndElement(writer);
        }
        if ((g = type.getG()) != null) {
            StaxUtil.writeStartElement(writer, prefix, "G", "http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters(writer, new String(g));
            StaxUtil.writeEndElement(writer);
        }
        if ((y = type.getY()) != null) {
            StaxUtil.writeStartElement(writer, prefix, "Y", "http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters(writer, new String(y));
            StaxUtil.writeEndElement(writer);
        }
        if ((seed = type.getSeed()) != null) {
            StaxUtil.writeStartElement(writer, prefix, "Seed", "http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters(writer, new String(seed));
            StaxUtil.writeEndElement(writer);
        }
        if ((pgen = type.getPgenCounter()) != null) {
            StaxUtil.writeStartElement(writer, prefix, "PgenCounter", "http://www.w3.org/2000/09/xmldsig#");
            StaxUtil.writeCharacters(writer, new String(pgen));
            StaxUtil.writeEndElement(writer);
        }
        StaxUtil.writeEndElement(writer);
    }
}

