/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider.wildfly;

import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.keycloak.Config;
import org.keycloak.theme.JarThemeProviderFactory;

public class ModuleThemeProviderFactory
extends JarThemeProviderFactory {
    public void init(Config.Scope config) {
        String[] modules = config.getArray("modules");
        if (modules != null) {
            try {
                for (String moduleSpec : modules) {
                    Module module = Module.getContextModuleLoader().loadModule(ModuleIdentifier.fromString((String)moduleSpec));
                    ModuleClassLoader classLoader = module.getClassLoader();
                    this.loadThemes((ClassLoader)classLoader, classLoader.getResourceAsStream("META-INF/keycloak-themes.json"));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load themes", e);
            }
        }
    }

    public String getId() {
        return "module";
    }
}

